/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.cache;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUConcurrentCache<K, V> {
    private final Map<K, V> cache;
    private final int limit;

    public LRUConcurrentCache(final int maxEntries) {
        this.limit = maxEntries;
        this.cache = new LinkedHashMap<K, V>(maxEntries, 0.75f, true){
            private static final long serialVersionUID = -1236481390177598762L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > maxEntries;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<K, V> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        Map<K, V> map = this.cache;
        synchronized (map) {
            return this.cache.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Map<K, V> map = this.cache;
        synchronized (map) {
            return this.cache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        Map<K, V> map = this.cache;
        synchronized (map) {
            this.cache.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        Map<K, V> map = this.cache;
        synchronized (map) {
            return this.cache.remove(key);
        }
    }

    public int size() {
        return this.cache.size();
    }

    public int limit() {
        return this.limit;
    }

    public String toString() {
        return "LRUConcurrentCache{cache=" + this.cache + "}";
    }
}

