/*
 * Decompiled with CFR 0.152.
 */
package tigase.form;

import java.util.List;
import java.util.logging.Logger;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class AbstractForm {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    protected String instruction;
    protected String title;
    protected String type;

    public AbstractForm(Element form) {
        this.type = form.getAttributeStaticStr("type");
        this.log.finest("Retriving Data Form type " + this.type);
        List children = form.getChildren();
        if (children != null) {
            for (Element sub : children) {
                if ("title".equals(sub.getName())) {
                    this.title = sub.getCData();
                    this.log.finest("read Data Form title [" + this.title + "]");
                    continue;
                }
                if (!"instructions".equals(sub.getName())) continue;
                this.instruction = sub.getCData();
                this.log.finest("read Data Form instruction [" + this.instruction + "]");
            }
        }
    }

    public AbstractForm(String type, String title, String instruction) {
        this.type = type;
        this.title = title;
        this.instruction = instruction;
    }

    public Element getElement() {
        Element form = new Element("x");
        form.setAttribute("xmlns", "jabber:x:data");
        if (this.type != null) {
            form.setAttribute("type", this.type);
        }
        if (this.title != null) {
            form.addChild((XMLNodeIfc)new Element("title", this.title));
        }
        if (this.instruction != null) {
            form.addChild((XMLNodeIfc)new Element("instructions", this.instruction));
        }
        return form;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeOrElse(String defValue) {
        if (this.type == null) {
            return defValue;
        }
        return this.type;
    }

    public boolean isType(String type) {
        return this.type != null && this.type.equals(type);
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(String type) {
        this.type = type;
    }
}

