/*
 * Decompiled with CFR 0.152.
 */
package tigase.criteria;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import tigase.criteria.Criteria;
import tigase.xml.Element;

public class ElementCriteria
implements Criteria {
    private Map<String, String> attrs = new TreeMap<String, String>();
    private String cdata = null;
    private String name;
    private Criteria nextCriteria;

    public static final ElementCriteria empty() {
        return new ElementCriteria(null, null, null, null);
    }

    public static final ElementCriteria name(String name) {
        return new ElementCriteria(name, null, null, null);
    }

    public static final ElementCriteria name(String name, String xmlns) {
        return new ElementCriteria(name, null, new String[]{"xmlns"}, new String[]{xmlns});
    }

    public static final ElementCriteria name(String name, String cdata, String[] attNames, String[] attValues) {
        return new ElementCriteria(name, cdata, attNames, attValues);
    }

    public static final ElementCriteria name(String name, String[] attNames, String[] attValues) {
        return new ElementCriteria(name, null, attNames, attValues);
    }

    public static final ElementCriteria nameType(String name, String type) {
        return new ElementCriteria(name, null, new String[]{"type"}, new String[]{type});
    }

    public static final ElementCriteria xmlns(String xmlns) {
        return new ElementCriteria(null, null, new String[]{"xmlns"}, new String[]{xmlns});
    }

    public ElementCriteria(String name, String cdata, String[] attname, String[] attValue) {
        this.cdata = cdata;
        this.name = name;
        if (attname != null && attValue != null) {
            for (int i = 0; i < attname.length; ++i) {
                this.attrs.put(attname[i], attValue[i]);
            }
        }
    }

    @Override
    public Criteria add(Criteria criteria) {
        if (this.nextCriteria == null) {
            this.nextCriteria = criteria;
        } else {
            Criteria c = this.nextCriteria;
            c.add(criteria);
        }
        return this;
    }

    @Override
    public boolean match(Element element) {
        if (this.name != null && this.name != element.getName()) {
            return false;
        }
        if (!(this.cdata == null || element.getCData() != null && this.cdata.equals(element.getCData()))) {
            return false;
        }
        boolean result = true;
        for (Map.Entry<String, String> entry : this.attrs.entrySet()) {
            String x = element.getAttribute(entry.getKey());
            if (x != null && x.equals(entry.getValue())) continue;
            result = false;
            break;
        }
        if (this.nextCriteria != null) {
            List children = element.getChildren();
            boolean subres = false;
            if (children != null) {
                for (Element sub : children) {
                    if (!this.nextCriteria.match(sub)) continue;
                    subres = true;
                    break;
                }
            }
            result &= subres;
        }
        return result;
    }
}

