/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import tigase.util.TigaseStringprepException;
import tigase.xmpp.BareJID;

public class JID
implements Comparable<JID> {
    private BareJID bareJid = null;
    private String resource = null;
    private String to_string = null;

    public JID(String jid) throws TigaseStringprepException {
        String[] parsedJid = BareJID.parseJID(jid);
        this.bareJid = BareJID.bareJIDInstance(parsedJid[0], parsedJid[1]);
        this.setResource(parsedJid[2]);
    }

    public JID(String localpart, String domain, String resource) throws TigaseStringprepException {
        this.bareJid = BareJID.bareJIDInstance(localpart, domain);
        this.setResource(resource);
    }

    public JID(BareJID bareJid, String resource) throws TigaseStringprepException {
        this.bareJid = bareJid;
        this.setResource(resource);
    }

    public void setResource(String resource) throws TigaseStringprepException {
        this.resource = BareJID.stringPrep.resourceprep(resource);
        this.to_string = BareJID.toString(this.bareJid, resource);
    }

    public String getResource() {
        return this.resource;
    }

    public void setBareJID(BareJID bareJid) {
        this.bareJid = bareJid;
        this.to_string = BareJID.toString(bareJid, this.resource);
    }

    public BareJID getBareJID() {
        return this.bareJid;
    }

    public String getLocalpart() {
        return this.bareJid.getLocalpart();
    }

    public String getDomain() {
        return this.bareJid.getDomain();
    }

    public String toString() {
        return this.to_string;
    }

    @Override
    public int compareTo(JID o) {
        return this.to_string.compareTo(o.to_string);
    }

    public boolean equals(Object b) {
        if (b instanceof JID) {
            JID jid = (JID)b;
            return this.bareJid.equals(jid.bareJid) && (this.resource == jid.resource || this.resource != null && this.resource.equals(jid.resource));
        }
        return false;
    }

    public int hashCode() {
        return this.to_string.hashCode();
    }
}

