/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Logger;

public abstract class JDBCAbstract {
    private static final Logger log = Logger.getLogger(JDBCAbstract.class.getName());
    public static final String DERBY_CONNVALID_QUERY = "values 1";
    public static final String JDBC_CONNVALID_QUERY = "select 1";
    private String db_conn = null;
    private Connection conn = null;
    private PreparedStatement conn_valid_st = null;
    private long lastConnectionValidated = 0L;
    private long connectionValidateInterval = 60000L;
    private boolean derby_mode = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkConnection() throws SQLException {
        try {
            PreparedStatement preparedStatement = this.conn_valid_st;
            synchronized (preparedStatement) {
                long tmp = System.currentTimeMillis();
                if (tmp - this.lastConnectionValidated >= this.connectionValidateInterval) {
                    this.conn_valid_st.executeQuery();
                    this.lastConnectionValidated = tmp;
                }
            }
        }
        catch (Exception e) {
            this.initRepo();
        }
        return true;
    }

    protected void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepo() throws SQLException {
        String string = this.db_conn;
        synchronized (string) {
            this.derby_mode = this.db_conn.startsWith("jdbc:derby");
            this.conn = DriverManager.getConnection(this.db_conn);
            this.conn.setAutoCommit(true);
            this.initPreparedStatements();
        }
    }

    public String getResourceUri() {
        return this.db_conn;
    }

    public void setResourceUri(String uri) {
        this.db_conn = uri;
    }

    public PreparedStatement prepareStatement(String query) throws SQLException {
        try {
            return this.conn.prepareStatement(query);
        }
        catch (SQLException e) {
            log.warning("Can't prepare statement for query: " + query);
            throw e;
        }
    }

    public CallableStatement prepareCallable(String query) throws SQLException {
        return this.conn.prepareCall(query);
    }

    protected void initPreparedStatements() throws SQLException {
        String query = this.derby_mode ? DERBY_CONNVALID_QUERY : JDBC_CONNVALID_QUERY;
        this.conn_valid_st = this.conn.prepareStatement(query);
    }

    public abstract void initRepository(String var1, Map<String, String> var2) throws SQLException;
}

