/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Algorithms {
    private Algorithms() {
    }

    public static final String hexDigest(String id, String secret, String alg) throws NoSuchAlgorithmException {
        return Algorithms.bytesToHex(Algorithms.digest(id, secret, alg));
    }

    public static final byte[] digest(String id, String secret, String alg) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(alg);
        String conc = id + secret;
        md.update(conc.getBytes());
        return md.digest();
    }

    public static final String bytesToHex(byte[] buff) {
        StringBuilder res = new StringBuilder();
        for (byte b : buff) {
            char ch = Character.forDigit(b >> 4 & 0xF, 16);
            res.append(ch);
            ch = Character.forDigit(b & 0xF, 16);
            res.append(ch);
        }
        return res.toString();
    }

    private static String help() {
        return " -id id\t\t\t\tid used to calculate digest\n -pass pass\t\t\tpassword phrase for digest calculation\n -alg alg\t\t\talgorith to use for calculating digest\n";
    }

    public static void main(String[] args) throws Exception {
        String id = null;
        String pass = null;
        String alg = "MD5";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h")) {
                System.out.println(Algorithms.help());
                System.exit(0);
            }
            if (args[i].equals("-id")) {
                id = args[++i];
            }
            if (args[i].equals("-pass")) {
                pass = args[++i];
            }
            if (!args[i].equals("-alg")) continue;
            alg = args[++i];
        }
        if (id == null) {
            id = "";
        }
        System.out.println(Algorithms.hexDigest(id, pass, alg));
    }
}

