/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.util.Arrays;

public class Base64 {
    private static final char[] toBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] fromBase64 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    private Base64() {
    }

    public static byte[] decode(String input) {
        byte b3;
        byte b2;
        byte b1;
        int groups = input.length() / 4;
        int pads = 0;
        if (input.endsWith("=")) {
            ++pads;
            if (input.charAt(input.length() - 2) == '=') {
                ++pads;
            }
            if (Base64.isWhiteSpace(input.charAt(input.length() - 6))) {
                --groups;
            }
        }
        byte[] result = new byte[groups * 3 - pads];
        int incnt = 0;
        int outcnt = 0;
        int n = groups = pads > 0 ? groups - 1 : groups;
        while (incnt / 4 < groups) {
            while (Base64.isWhiteSpace(input.charAt(incnt))) {
                ++incnt;
            }
            b1 = fromBase64[input.charAt(incnt++)];
            b2 = fromBase64[input.charAt(incnt++)];
            b3 = fromBase64[input.charAt(incnt++)];
            byte b4 = fromBase64[input.charAt(incnt++)];
            result[outcnt++] = (byte)(b1 << 2 | b2 >> 4);
            result[outcnt++] = (byte)(b2 << 4 | b3 >> 2);
            result[outcnt++] = (byte)(b3 << 6 | b4);
        }
        if (pads > 0) {
            while (Base64.isWhiteSpace(input.charAt(incnt))) {
                ++incnt;
            }
            b1 = fromBase64[input.charAt(incnt++)];
            b2 = fromBase64[input.charAt(incnt++)];
            result[outcnt++] = (byte)(b1 << 2 | b2 >> 4);
            if (pads == 1) {
                b3 = fromBase64[input.charAt(incnt++)];
                result[outcnt++] = (byte)(b2 << 4 | b3 >> 2);
            }
        }
        return Arrays.copyOf(result, outcnt);
    }

    public static String encode(byte[] input) {
        return Base64.encodeChunk(input, 0);
    }

    public static String encodeChunk(byte[] input, int chunkSize) {
        int groups;
        int pads = ((groups = input.length / 3) * 3 + 3 - input.length) % 3;
        StringBuilder result = new StringBuilder(groups * 4 + (pads > 0 ? 1 : 0));
        for (int i = 0; i < groups; ++i) {
            int c1 = (input[i * 3] & 0xFF) >> 2;
            int c2 = (input[i * 3] & 0xFF) << 4 & 0x3F | (input[i * 3 + 1] & 0xFF) >> 4;
            int c3 = (input[i * 3 + 1] & 0xFF) << 2 & 0x3F | (input[i * 3 + 2] & 0xFF) >> 6;
            int c4 = input[i * 3 + 2] & 0x3F;
            result.append(toBase64[c1]);
            result.append(toBase64[c2]);
            result.append(toBase64[c3]);
            result.append(toBase64[c4]);
            if (chunkSize == 0 || (i + 1) % (chunkSize / 4) != 0) continue;
            result.append("\r\n");
        }
        switch (pads) {
            case 1: {
                int c1 = (input[groups * 3] & 0xFF) >> 2;
                int c2 = (input[groups * 3] & 0xFF) << 4 & 0x3F | (input[groups * 3 + 1] & 0xFF) >> 4;
                int c3 = (input[groups * 3 + 1] & 0xFF) << 2 & 0x3F;
                result.append(toBase64[c1]);
                result.append(toBase64[c2]);
                result.append(toBase64[c3]);
                result.append('=');
                break;
            }
            case 2: {
                int c1 = (input[groups * 3] & 0xFF) >> 2;
                int c2 = (input[groups * 3] & 0xFF) << 4 & 0x3F;
                result.append(toBase64[c1]);
                result.append(toBase64[c2]);
                result.append("==");
                break;
            }
        }
        return result.toString();
    }

    private static boolean isWhiteSpace(char charToCheck) {
        switch (charToCheck) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        if (args[0].equals("-decode")) {
            System.out.println(new String(Base64.decode(args[1])));
        }
        if (args[0].equals("-encode")) {
            System.out.println(Base64.encode(args[1].getBytes()));
        }
    }
}

