/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import tigase.util.TigaseStringprepException;
import tigase.util.XMPPStringPrepFactory;
import tigase.util.XMPPStringPrepIfc;

public final class BareJID
implements Comparable<BareJID> {
    static XMPPStringPrepIfc stringPrep = XMPPStringPrepFactory.getDefaultXMPPStringPrep();
    private final String domain;
    private final String localpart;
    private final String to_string;

    private BareJID(String localpart, String domain) {
        this.localpart = localpart;
        this.domain = domain.intern();
        this.to_string = BareJID.toString(this.localpart, this.domain);
    }

    public static BareJID bareJIDInstance(String jid) throws TigaseStringprepException {
        String[] parsedJid = BareJID.parseJID(jid);
        return BareJID.bareJIDInstance(parsedJid[0], parsedJid[1]);
    }

    public static BareJID bareJIDInstance(String p_localpart, String p_domain) throws TigaseStringprepException {
        String f_localpart = p_localpart == null ? null : stringPrep.nodeprep(p_localpart);
        String f_domain = stringPrep.nameprep(p_domain);
        return new BareJID(f_localpart, f_domain);
    }

    public static BareJID bareJIDInstanceNS(String jid) {
        String[] parsedJid = BareJID.parseJID(jid);
        return BareJID.bareJIDInstanceNS(parsedJid[0], parsedJid[1]);
    }

    public static BareJID bareJIDInstanceNS(String p_localpart, String p_domain) {
        return new BareJID(p_localpart, p_domain);
    }

    public static String jidToBareJID(String jid) {
        String[] parsed = BareJID.parseJID(jid);
        return BareJID.toString(parsed[0], parsed[1]);
    }

    public static String[] parseJID(String jid) {
        String[] result = new String[3];
        int idx = jid.indexOf(47);
        result[2] = idx == -1 ? null : jid.substring(idx + 1);
        String id = idx == -1 ? jid : jid.substring(0, idx);
        idx = id.indexOf(64);
        result[0] = idx == -1 ? null : id.substring(0, idx);
        result[1] = idx == -1 ? id : id.substring(idx + 1);
        return result;
    }

    public static String toString(String p_localpart, String p_domain) {
        return p_localpart != null && p_localpart.length() > 0 ? p_localpart + "@" + p_domain : p_domain;
    }

    public static String toString(String p_localpart, String p_domain, String p_resource) {
        return BareJID.toString(p_localpart, p_domain) + (p_resource != null && p_resource.length() > 0 ? "/" + p_resource : "");
    }

    public static String toString(BareJID bareJid, String p_resource) {
        return bareJid.toString() + (p_resource != null && p_resource.length() > 0 ? "/" + p_resource : "");
    }

    public static void useStringprepProcessor(String stringprepProcessor) {
        stringPrep = XMPPStringPrepFactory.getXMPPStringPrep(stringprepProcessor);
    }

    @Override
    public int compareTo(BareJID o) {
        return this.to_string.compareTo(o.to_string);
    }

    public boolean equals(Object b) {
        boolean result = false;
        if (b instanceof BareJID) {
            result = this.domain == ((BareJID)b).domain && (this.localpart == null ? this.localpart == ((BareJID)b).localpart : this.localpart.equals(((BareJID)b).localpart));
        }
        return result;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getLocalpart() {
        return this.localpart;
    }

    public int hashCode() {
        return this.to_string.hashCode();
    }

    public String toString() {
        return this.to_string;
    }
}

