/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import tigase.util.DNSEntry;
import tigase.util.SimpleCache;

public class DNSResolver {
    private static final Logger log = Logger.getLogger(DNSResolver.class.getName());
    private static final String LOCALHOST = "localhost";
    private static final String OPEN_DNS_HIT_NXDOMAIN = "hit-nxdomain.opendns.com";
    private static final long DNS_CACHE_TIME = 60000L;
    private static Map<String, DNSEntry[]> srv_cache = Collections.synchronizedMap(new SimpleCache(100, 60000L));
    private static Map<String, DNSEntry> ip_cache = Collections.synchronizedMap(new SimpleCache(100, 60000L));
    private static String[] localnames = null;
    private static String defaultHostname = null;
    private static String opendns_hit_nxdomain_ip = null;
    private static long resolveDefaultTime = 0L;

    public static String[] getDefHostNames() {
        return localnames != null ? Arrays.copyOf(localnames, localnames.length) : null;
    }

    public static String getDefaultHostname() {
        return defaultHostname;
    }

    public static String getHostIP(String hostname) throws UnknownHostException {
        DNSEntry cache_res = ip_cache.get(hostname);
        if (cache_res != null) {
            return cache_res.getIp();
        }
        InetAddress[] all = InetAddress.getAllByName(hostname);
        String ip_address = all[0].getHostAddress();
        if (ip_address.equals(opendns_hit_nxdomain_ip)) {
            throw new UnknownHostException("OpenDNS NXDOMAIN");
        }
        ip_cache.put(hostname, new DNSEntry(hostname, ip_address));
        return ip_address;
    }

    public static DNSEntry[] getHostSRV_Entries(String hostname) throws UnknownHostException {
        DNSEntry[] entries;
        int port;
        String result_host;
        block16: {
            DNSEntry[] cache_res = srv_cache.get(hostname);
            if (cache_res != null) {
                return cache_res;
            }
            result_host = hostname;
            port = 5269;
            int priority = 0;
            int weight = 0;
            long ttl = 3600000L;
            entries = null;
            try {
                Hashtable<String, String> env = new Hashtable<String, String>(5);
                env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                InitialDirContext ctx = new InitialDirContext(env);
                Attributes attrs = ctx.getAttributes("_xmpp-server._tcp." + hostname, new String[]{"SRV"});
                Attribute att = attrs.get("SRV");
                if (att != null && att.size() > 0) {
                    entries = new DNSEntry[att.size()];
                    for (int i = 0; i < entries.length; ++i) {
                        String[] dns_resp = att.get(i).toString().split(" ");
                        try {
                            priority = Integer.parseInt(dns_resp[0]);
                        }
                        catch (Exception e) {
                            priority = 0;
                        }
                        try {
                            weight = Integer.parseInt(dns_resp[1]);
                        }
                        catch (Exception e) {
                            weight = 0;
                        }
                        try {
                            port = Integer.parseInt(dns_resp[2]);
                        }
                        catch (Exception e) {
                            port = 5269;
                        }
                        result_host = dns_resp[3];
                        InetAddress[] all = InetAddress.getAllByName(result_host);
                        String ip_address = all[0].getHostAddress();
                        if (ip_address.equals(opendns_hit_nxdomain_ip)) {
                            throw new UnknownHostException("OpenDNS NXDOMAIN");
                        }
                        entries[i] = new DNSEntry(hostname, ip_address, port, ttl, priority, weight);
                    }
                } else {
                    log.log(Level.FINER, "Empty SRV DNS records set for domain: {0}", hostname);
                }
                ctx.close();
            }
            catch (NamingException e) {
                result_host = hostname;
                if (!log.isLoggable(Level.FINER)) break block16;
                log.log(Level.FINER, "Problem getting SRV DNS records for domain: " + hostname, e);
            }
        }
        if (entries == null) {
            InetAddress[] all = InetAddress.getAllByName(result_host);
            String ip_address = all[0].getHostAddress();
            if (ip_address.equals(opendns_hit_nxdomain_ip)) {
                throw new UnknownHostException("OpenDNS NXDOMAIN");
            }
            entries = new DNSEntry[]{new DNSEntry(hostname, ip_address, port)};
        }
        if (entries != null) {
            srv_cache.put(hostname, entries);
        }
        return entries;
    }

    public static DNSEntry getHostSRV_Entry(String hostname) throws UnknownHostException {
        DNSEntry[] entries = DNSResolver.getHostSRV_Entries(hostname);
        if (entries == null || entries.length == 0) {
            return null;
        }
        return entries[0];
    }

    public static String getHostSRV_IP(String hostname) throws UnknownHostException {
        DNSEntry entry = DNSResolver.getHostSRV_Entry(hostname);
        return entry != null ? entry.getIp() : null;
    }

    public static void main(String[] args) throws Exception {
        String host = "gmail.com";
        if (args.length > 0) {
            host = args[0];
        }
        System.out.println(host + ": " + Arrays.toString(DNSResolver.getHostSRV_Entries(host)));
        System.out.println("Localhost name: " + InetAddress.getLocalHost().getHostName());
        System.out.println("Localhost canonnical name: " + InetAddress.getLocalHost().getCanonicalHostName());
        System.out.println("Is local loopback: " + InetAddress.getLocalHost().isLoopbackAddress());
        for (String hostname : localnames) {
            InetAddress[] all;
            for (InetAddress addr : all = InetAddress.getAllByName(hostname)) {
                System.out.println("  ------   ");
                System.out.println("Host name: " + addr.getHostName());
                System.out.println("Host getCanonicalHostName(): " + addr.getCanonicalHostName());
                System.out.println("Host getHostAddress(): " + addr.getHostAddress());
                System.out.println("Is isLoopbackAddress()  : " + addr.isLoopbackAddress());
                System.out.println("Is isAnyLocalAddress()  : " + addr.isAnyLocalAddress());
                System.out.println("Is isLinkLocalAddress() : " + addr.isLinkLocalAddress());
                System.out.println("Is isSiteLocalAddress() : " + addr.isSiteLocalAddress());
            }
        }
    }

    static {
        long start = System.currentTimeMillis();
        ip_cache.put(LOCALHOST, new DNSEntry(LOCALHOST, "127.0.0.1"));
        try {
            if (!LOCALHOST.equals(InetAddress.getLocalHost().getHostName().toLowerCase())) {
                localnames = new String[2];
                DNSResolver.localnames[0] = InetAddress.getLocalHost().getHostName().toLowerCase();
                DNSResolver.localnames[1] = LOCALHOST;
                InetAddress[] all = InetAddress.getAllByName(localnames[0]);
                ip_cache.put(localnames[0], new DNSEntry(localnames[0], all[0].getHostAddress().toLowerCase()));
            } else {
                localnames = new String[]{LOCALHOST};
            }
            for (String hostname : localnames) {
                InetAddress[] all;
                for (InetAddress addr : all = InetAddress.getAllByName(hostname)) {
                    if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isLinkLocalAddress() || addr.isSiteLocalAddress()) continue;
                    defaultHostname = addr.getHostName().toLowerCase();
                }
            }
            if (defaultHostname == null) {
                defaultHostname = localnames[0];
            }
        }
        catch (UnknownHostException e) {
            localnames = new String[]{LOCALHOST};
        }
        new Thread("OpenDNS checker"){

            @Override
            public void run() {
                try {
                    opendns_hit_nxdomain_ip = InetAddress.getByName(DNSResolver.OPEN_DNS_HIT_NXDOMAIN).getHostAddress();
                }
                catch (UnknownHostException e) {
                    opendns_hit_nxdomain_ip = null;
                }
            }
        }.start();
        resolveDefaultTime = System.currentTimeMillis() - start;
        if (resolveDefaultTime > 0L) {
            log.warning("Resolving default host name took: " + resolveDefaultTime);
        }
    }
}

