/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class Telnet {
    private static int port = 5222;
    private static String hostname = "localhost";
    private static boolean debug = false;
    private static boolean stopped = false;
    private static String file = null;
    private static boolean continuous = false;
    private static long delay = 100L;

    public Telnet() {
    }

    public static String help() {
        return "\nParameters:\n -h                this help message\n -n hostname       host name\n -p port           port number\n -f file           file with content to send to remote host\n -c                continuous sending file content\n -t millis         delay between sending file content\n -v                prints server version info\n -d [true|false]   turn on|off debug mode\n";
    }

    public static String version() {
        return "\n-- \nTigase XMPP Telnet, version: " + Telnet.class.getPackage().getImplementationVersion() + "\n" + "Author:\tArtur Hefczyc <artur.hefczyc@tigase.org>\n" + "-- \n";
    }

    public static void parseParams(String[] args) throws Exception {
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h")) {
                    System.out.print(Telnet.help());
                    System.exit(0);
                }
                if (args[i].equals("-v")) {
                    System.out.print(Telnet.version());
                    System.exit(0);
                }
                if (args[i].equals("-f")) {
                    if (i + 1 == args.length) {
                        System.out.print(Telnet.help());
                        System.exit(1);
                    } else {
                        file = args[++i];
                    }
                }
                if (args[i].equals("-n")) {
                    if (i + 1 == args.length) {
                        System.out.print(Telnet.help());
                        System.exit(1);
                    } else {
                        hostname = args[++i];
                    }
                }
                if (args[i].equals("-p")) {
                    if (i + 1 == args.length) {
                        System.out.print(Telnet.help());
                        System.exit(1);
                    } else {
                        port = Integer.decode(args[++i]);
                    }
                }
                if (args[i].equals("-d")) {
                    if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                        debug = true;
                    } else {
                        boolean bl = debug = args[++i].charAt(0) != '-' && (args[i].equals("true") || args[i].equals("yes"));
                    }
                }
                if (!args[i].equals("-c")) continue;
                continuous = i + 1 == args.length || args[i + 1].startsWith("-") ? true : args[++i].charAt(0) != '-' && (args[i].equals("true") || args[i].equals("yes"));
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Telnet.parseParams(args);
        String data = null;
        if (file != null) {
            FileReader fr = new FileReader(file);
            char[] buff = new char[16384];
            int res = -1;
            StringBuilder sb = new StringBuilder();
            while ((res = fr.read(buff)) != -1) {
                sb.append(buff, 0, res);
            }
            fr.close();
            data = sb.toString();
        }
        Socket sock = new Socket(hostname, port);
        new Telnet(sock, data);
    }

    public Telnet(Socket sock, String data) throws IOException {
        StreamListener sl1 = new StreamListener(sock.getInputStream(), System.out, "Hello, this Tigase Telnet program, type your input...\n");
        StreamListener sl2 = new StreamListener(System.in, sock.getOutputStream(), data);
        new Thread(sl1).start();
        new Thread(sl2).start();
    }

    private static class StreamListener
    implements Runnable {
        private InputStream is = null;
        private OutputStream os = null;
        private String data = null;

        private StreamListener(InputStream is, OutputStream os, String data) {
            this.is = is;
            this.os = os;
            this.data = data;
        }

        public void run() {
            try {
                int chr;
                if (this.data != null) {
                    this.os.write(this.data.getBytes());
                }
                while (this.data != null && continuous && !stopped) {
                    this.os.write(this.data.getBytes());
                    if (this.os == System.out) break;
                    Thread.currentThread();
                    Thread.sleep(delay);
                }
                while (!stopped && (chr = this.is.read()) != -1) {
                    this.os.write(chr);
                    this.os.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.exit(1);
        }
    }
}

