/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import tigase.util.SimpleCache;

public class DNSResolver {
    private static final Logger log = Logger.getLogger("tigase.util.DNSResolver");
    private static final String LOCALHOST = "localhost";
    private static final String OPEN_DNS_HIT_NXDOMAIN = "hit-nxdomain.opendns.com";
    private static final long DNS_CACHE_TIME = 3600000L;
    private static Map<String, Object> cache = Collections.synchronizedMap(new SimpleCache(100, 3600000L));
    private static String[] localnames = null;
    private static String defaultHostname = null;
    private static String opendns_hit_nxdomain_ip = null;

    public static String getDefaultHostname() {
        return defaultHostname;
    }

    public static String[] getDefHostNames() {
        return localnames != null ? Arrays.copyOf(localnames, localnames.length) : null;
    }

    public static String getHostSRV_IP(String hostname) throws UnknownHostException {
        String cache_res = (String)cache.get(hostname);
        if (cache_res != null) {
            return cache_res;
        }
        String result_host = hostname;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attrs = ctx.getAttributes("_xmpp-server._tcp." + hostname, new String[]{"SRV"});
            Attribute att = attrs.get("SRV");
            if (att != null) {
                String res = att.get().toString();
                int idx = res.lastIndexOf(" ");
                result_host = res.substring(idx + 1, res.length());
            }
            ctx.close();
        }
        catch (NamingException e) {
            result_host = hostname;
        }
        InetAddress[] all = InetAddress.getAllByName(result_host);
        String ip_address = all[0].getHostAddress();
        if (ip_address.equals(opendns_hit_nxdomain_ip)) {
            throw new UnknownHostException("OpenDNS NXDOMAIN");
        }
        cache.put(hostname, ip_address);
        return ip_address;
    }

    public static String getHostIP(String hostname) throws UnknownHostException {
        String cache_res = (String)cache.get(hostname);
        if (cache_res != null) {
            return cache_res;
        }
        InetAddress[] all = InetAddress.getAllByName(hostname);
        String ip_address = all[0].getHostAddress();
        if (ip_address.equals(opendns_hit_nxdomain_ip)) {
            throw new UnknownHostException("OpenDNS NXDOMAIN");
        }
        cache.put(hostname, ip_address);
        return ip_address;
    }

    public static void main(String[] args) throws Exception {
        String host = "gmail.com";
        if (args.length > 0) {
            host = args[0];
        }
        System.out.println("gmail.com IP: " + DNSResolver.getHostSRV_IP(host));
        System.out.println("Localhost name: " + InetAddress.getLocalHost().getHostName());
        System.out.println("Localhost canonnical name: " + InetAddress.getLocalHost().getCanonicalHostName());
        System.out.println("Is local loopback: " + InetAddress.getLocalHost().isLoopbackAddress());
        for (String hostname : localnames) {
            InetAddress[] all;
            for (InetAddress addr : all = InetAddress.getAllByName(hostname)) {
                System.out.println("  ------   ");
                System.out.println("Host name: " + addr.getHostName());
                System.out.println("Host getCanonicalHostName(): " + addr.getCanonicalHostName());
                System.out.println("Host getHostAddress(): " + addr.getHostAddress());
                System.out.println("Is isLoopbackAddress()  : " + addr.isLoopbackAddress());
                System.out.println("Is isAnyLocalAddress()  : " + addr.isAnyLocalAddress());
                System.out.println("Is isLinkLocalAddress() : " + addr.isLinkLocalAddress());
                System.out.println("Is isSiteLocalAddress() : " + addr.isSiteLocalAddress());
            }
        }
    }

    static {
        cache.put(LOCALHOST, "127.0.0.1");
        try {
            if (!LOCALHOST.equals(InetAddress.getLocalHost().getHostName().toLowerCase())) {
                localnames = new String[2];
                DNSResolver.localnames[0] = InetAddress.getLocalHost().getHostName().toLowerCase();
                DNSResolver.localnames[1] = LOCALHOST;
                InetAddress[] all = InetAddress.getAllByName(localnames[0]);
                cache.put(localnames[0], all[0].getHostAddress().toLowerCase());
            } else {
                localnames = new String[]{LOCALHOST};
            }
            for (String hostname : localnames) {
                InetAddress[] all;
                for (InetAddress addr : all = InetAddress.getAllByName(hostname)) {
                    if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isLinkLocalAddress() || addr.isSiteLocalAddress()) continue;
                    defaultHostname = addr.getHostName().toLowerCase();
                }
            }
            if (defaultHostname == null) {
                defaultHostname = localnames[0];
            }
        }
        catch (UnknownHostException e) {
            localnames = new String[]{LOCALHOST};
        }
        try {
            opendns_hit_nxdomain_ip = InetAddress.getByName(OPEN_DNS_HIT_NXDOMAIN).getHostAddress();
        }
        catch (UnknownHostException e) {
            opendns_hit_nxdomain_ip = null;
        }
    }
}

