/*
 * Decompiled with CFR 0.152.
 */
package tigase.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import tigase.form.Field;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Form {
    private List<Field> fields = new ArrayList<Field>();
    private Map<String, Field> fieldsByVar = new HashMap<String, Field>();
    private String instruction;
    private Logger log = Logger.getLogger(this.getClass().getName());
    private String title;
    private String type;

    public Form(Element form) {
        this.type = form.getAttribute("type");
        this.log.finest("Retriving Data Form type " + this.type);
        List children = form.getChildren();
        if (children != null) {
            for (Element sub : children) {
                if ("title".equals(sub.getName())) {
                    this.title = sub.getCData();
                    this.log.finest("read Data Form title [" + this.title + "]");
                    continue;
                }
                if ("instructions".equals(sub.getName())) {
                    this.instruction = sub.getCData();
                    this.log.finest("read Data Form instruction [" + this.instruction + "]");
                    continue;
                }
                if (!"field".equals(sub.getName())) continue;
                Field field = new Field(sub);
                this.log.finest("read Data Form field [" + field.getVar() + "]");
                this.fields.add(field);
                this.fieldsByVar.put(field.getVar(), field);
            }
        }
    }

    public Form(String type, String title, String instruction) {
        this.type = type;
        this.title = title;
        this.instruction = instruction;
    }

    public void addField(Field field) {
        Field cf;
        Field field2 = cf = field.getVar() != null ? this.fieldsByVar.get(field.getVar()) : null;
        if (cf != null) {
            int p = this.fields.indexOf(cf);
            this.fields.remove(cf);
            this.fields.add(p, field);
        } else {
            this.fields.add(field);
        }
        if (field.getVar() != null) {
            this.fieldsByVar.put(field.getVar(), field);
        }
    }

    public void clear() {
        this.fields.clear();
        this.fieldsByVar.clear();
    }

    public void copyValuesFrom(Element form) {
        this.log.finest("Copying values from form ");
        List children = form.getChildren();
        if (children != null) {
            for (Element sub : children) {
                if (!"field".equals(sub.getName())) continue;
                Field field = new Field(sub);
                Field f = this.fieldsByVar.get(field.getVar());
                if (f != null) {
                    f.setValues(field.getValues());
                    continue;
                }
                this.log.warning("Field " + field.getVar() + " is not declared in form '" + this.title + "'!");
            }
        }
    }

    public void copyValuesFrom(Form form) {
        for (Field field : form.fields) {
            Field f = this.fieldsByVar.get(field.getVar());
            if (f != null) {
                f.setValues(field.getValues());
                continue;
            }
            this.log.warning("Field " + field.getVar() + " is not declared in form '" + this.title + "'!");
        }
    }

    public Field get(String var) {
        return this.fieldsByVar.get(var);
    }

    public List<Field> getAllFields() {
        return this.fields;
    }

    public Boolean getAsBoolean(String var) {
        Field f = this.get(var);
        if (f != null) {
            String v = f.getValue();
            if (v == null) {
                return null;
            }
            if ("1".equals(v)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public Integer getAsInteger(String var) {
        Field f = this.get(var);
        if (f != null) {
            String v = f.getValue();
            return Integer.parseInt(v);
        }
        return null;
    }

    public String getAsString(String var) {
        Field f = this.get(var);
        if (f != null) {
            String v = f.getValue();
            return v;
        }
        return null;
    }

    public String[] getAsStrings(String var) {
        Field f = this.get(var);
        if (f != null) {
            String[] v = f.getValues();
            return v;
        }
        return null;
    }

    public Element getElement() {
        Element form = new Element("x");
        form.setAttribute("xmlns", "jabber:x:data");
        form.setAttribute("type", this.type);
        if (this.title != null) {
            form.addChild((XMLNodeIfc)new Element("title", this.title));
        }
        if (this.instruction != null) {
            form.addChild((XMLNodeIfc)new Element("instructions", this.instruction));
        }
        for (Field field : this.fields) {
            form.addChild((XMLNodeIfc)field.getElement());
        }
        return form;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public boolean is(String var) {
        return this.fieldsByVar.containsKey(var);
    }

    public void removeField(String var) {
        Field cf = this.fieldsByVar.remove(var);
        if (cf != null) {
            this.fields.remove(cf);
        }
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(String type) {
        this.type = type;
    }
}

