/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import tigase.util.CacheObject;
import tigase.util.SizedCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCache<K, V>
implements Map<K, V> {
    private static final Logger log = Logger.getLogger("tigase.util.SimpleCache");
    private static final long serialVersionUID = 1L;
    private SizedCache<K, CacheObject<V>> cache = null;
    private long cache_time = 1000L;
    protected boolean cache_off = false;

    public SimpleCache(int maxSize, long time) {
        this.cache_time = time;
        String cache_on = System.getProperty("tigase.cache");
        if (cache_on == null || cache_on.equals("true") || cache_on.equals("1") || cache_on.equals("yes") || cache_on.equals("on")) {
            this.cache_off = false;
            this.cache = new SizedCache(maxSize);
        } else {
            this.cache_off = true;
            log.warning("Tigase cache turned off.");
        }
    }

    @Override
    public V get(Object key) {
        if (this.cache_off) {
            return null;
        }
        CacheObject cob = (CacheObject)this.cache.get(key);
        if (cob != null && cob.time + this.cache_time >= System.currentTimeMillis()) {
            return cob.data;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (this.cache_off) {
            return null;
        }
        V result = this.get(key);
        CacheObject cob = new CacheObject();
        cob.time = System.currentTimeMillis();
        cob.data = value;
        this.cache.put(key, cob);
        return result;
    }

    @Override
    public void clear() {
        if (this.cache_off) {
            return;
        }
        this.cache.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.cache_off) {
            return false;
        }
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.cache_off) {
            return false;
        }
        if (value == null) {
            for (CacheObject v : this.cache.values()) {
                if (v.data != null) continue;
                return true;
            }
        } else {
            for (CacheObject v : this.cache.values()) {
                if (!value.equals(v.data)) continue;
                return true;
            }
        }
        return false;
    }

    protected Map<K, V> dataMap() {
        if (this.cache_off) {
            return null;
        }
        Set cache_res = this.cache.entrySet();
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : cache_res) {
            result.put(entry.getKey(), ((CacheObject)entry.getValue()).data);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.cache_off) {
            return null;
        }
        return this.dataMap().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this.cache_off) {
            return false;
        }
        return ((Object)this.dataMap()).equals(o);
    }

    @Override
    public int hashCode() {
        if (this.cache_off) {
            return 0;
        }
        return ((Object)this.dataMap()).hashCode();
    }

    @Override
    public boolean isEmpty() {
        if (this.cache_off) {
            return true;
        }
        return this.cache.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        if (this.cache_off) {
            return null;
        }
        return this.cache.keySet();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (this.cache_off) {
            return;
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        if (this.cache_off) {
            return null;
        }
        CacheObject cache_res = (CacheObject)this.cache.remove(key);
        if (cache_res != null) {
            return cache_res.data;
        }
        return null;
    }

    @Override
    public int size() {
        if (this.cache_off) {
            return 0;
        }
        return this.cache.size();
    }

    @Override
    public Collection<V> values() {
        if (this.cache_off) {
            return null;
        }
        return this.dataMap().values();
    }
}

