/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import tigase.util.SimpleCache;

public class DNSResolver {
    private static final Logger log = Logger.getLogger("tigase.util.DNSResolver");
    private static final String LOCALHOST = "localhost";
    private static final long DNS_CACHE_TIME = 3600000L;
    private static Map<String, Object> cache = Collections.synchronizedMap(new SimpleCache(100, 3600000L));
    private static String[] localnames = null;

    public static String[] getDefHostNames() {
        return localnames != null ? Arrays.copyOf(localnames, localnames.length) : null;
    }

    public static String getHostSRV_IP(String hostname) throws UnknownHostException {
        String cache_res = (String)cache.get(hostname);
        if (cache_res != null) {
            return cache_res;
        }
        String result_host = hostname;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attrs = ctx.getAttributes("_xmpp-server._tcp." + hostname, new String[]{"SRV"});
            Attribute att = attrs.get("SRV");
            if (att != null) {
                String res = att.get().toString();
                int idx = res.lastIndexOf(" ");
                result_host = res.substring(idx + 1, res.length());
            }
            ctx.close();
        }
        catch (NamingException e) {
            result_host = hostname;
        }
        InetAddress[] all = InetAddress.getAllByName(result_host);
        cache.put(hostname, all[0].getHostAddress());
        return all[0].getHostAddress();
    }

    public static void main(String[] args) throws Exception {
        String host = "gmail.com";
        if (args.length > 0) {
            host = args[0];
        }
        System.out.println("IP: " + DNSResolver.getHostSRV_IP(host));
    }

    static {
        cache.put(LOCALHOST, "127.0.0.1");
        try {
            if (!LOCALHOST.equals(InetAddress.getLocalHost().getHostName())) {
                localnames = new String[2];
                DNSResolver.localnames[0] = InetAddress.getLocalHost().getHostName();
                DNSResolver.localnames[1] = LOCALHOST;
                InetAddress[] all = InetAddress.getAllByName(localnames[0]);
                cache.put(localnames[0], all[0].getHostAddress());
            } else {
                localnames = new String[]{LOCALHOST};
            }
        }
        catch (UnknownHostException e) {
            localnames = new String[]{LOCALHOST};
        }
    }
}

