/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.net.UnknownHostException;
import tigase.util.DNSResolver;

public abstract class JIDUtils {
    public static final String getNodeID(String jid) {
        int idx = jid.indexOf(47);
        return idx == -1 ? jid : jid.substring(0, idx);
    }

    public static final String getNodeResource(String jid) {
        int idx = jid.indexOf(47);
        return idx == -1 ? null : jid.substring(idx + 1);
    }

    public static final String getNodeHost(String jid) {
        String id = JIDUtils.getNodeID(jid);
        int idx = id.lastIndexOf(64);
        return idx == -1 ? id : id.substring(idx + 1);
    }

    public static final String getNodeHostIP(String jid) throws UnknownHostException {
        String domain = JIDUtils.getNodeHost(jid);
        return DNSResolver.getHostSRV_IP(domain);
    }

    public static final String getNodeNick(String jid) {
        String id = JIDUtils.getNodeID(jid);
        int idx = id.indexOf(64);
        return idx == -1 ? null : id.substring(0, idx);
    }

    public static final String getNodeID(String nick, String domain) {
        return nick != null && nick.length() > 0 ? nick + "@" + domain : domain;
    }

    public static final String getJID(String nick, String domain, String resource) {
        StringBuilder sb = new StringBuilder();
        if (nick != null) {
            sb.append(nick + "@");
        }
        if (domain == null) {
            throw new NullPointerException("Valid JIDUtils must contain at least domain name.");
        }
        sb.append(domain);
        if (resource != null) {
            sb.append("/" + resource);
        }
        return sb.toString();
    }

    public static final String checkNickName(String nickname) {
        if (nickname == null || nickname.length() == 0) {
            return "Nickname empty.";
        }
        if (nickname.contains(" ") || nickname.contains("\t") || nickname.contains("@") || nickname.contains("&")) {
            return "Nickname contains invalid characters.";
        }
        return null;
    }
}

