/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import tigase.util.ClassComparator;
import tigase.util.ObjectComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    public static String getClassNameFromFileName(String fileName) {
        String class_name = null;
        if (fileName.endsWith(".class")) {
            String tmp_class_name = fileName.substring(0, fileName.length() - 6).replace('\\', '.');
            class_name = tmp_class_name.replace('/', '.');
        }
        return class_name;
    }

    public static void walkInDirForFiles(File base_dir, String path, Set<String> set) {
        File tmp_file = new File(base_dir, path);
        if (tmp_file.isDirectory()) {
            String[] files;
            for (String file : files = tmp_file.list()) {
                ClassUtil.walkInDirForFiles(base_dir, new File(path, file).toString(), set);
            }
        } else {
            set.add(path);
        }
    }

    public static Set<String> getFileListDeep(File path) {
        TreeSet<String> set = new TreeSet<String>();
        if (path.isDirectory()) {
            String[] files;
            for (String file : files = path.list()) {
                ClassUtil.walkInDirForFiles(path, file, set);
            }
        } else {
            set.add(path.toString());
        }
        return set;
    }

    public static Set<String> getClassNamesFromDir(File dir) {
        Set<String> tmp_set = ClassUtil.getFileListDeep(dir);
        TreeSet<String> result = new TreeSet<String>();
        for (String elem : tmp_set) {
            String class_name = ClassUtil.getClassNameFromFileName(elem);
            if (class_name == null) continue;
            result.add(class_name);
        }
        return result;
    }

    public static Set<String> getClassNamesFromJar(File jarFile) throws IOException {
        TreeSet<String> result = new TreeSet<String>();
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> jar_entries = jar.entries();
        while (jar_entries.hasMoreElements()) {
            JarEntry jar_entry = jar_entries.nextElement();
            String class_name = ClassUtil.getClassNameFromFileName(jar_entry.getName());
            if (class_name == null) continue;
            result.add(class_name);
        }
        return result;
    }

    public static Set<Class> getClassesFromNames(Set<String> names) throws ClassNotFoundException {
        TreeSet<Class> classes = new TreeSet<Class>(new ClassComparator());
        for (String name : names) {
            try {
                Class<?> cls = Class.forName(name);
                classes.add(cls);
            }
            catch (NoClassDefFoundError e) {
            }
            catch (Throwable e) {
                Throwable cause = e.getCause();
                e.printStackTrace();
                if (cause == null) continue;
                cause.printStackTrace();
            }
        }
        return classes;
    }

    public static Set<Class> getClassesFromClassPath() throws IOException, ClassNotFoundException {
        TreeSet<Class> classes_set = new TreeSet<Class>(new ClassComparator());
        String classpath = System.getProperty("java.class.path");
        StringTokenizer stok = new StringTokenizer(classpath, File.pathSeparator, false);
        while (stok.hasMoreTokens()) {
            Set<String> class_names;
            String path = stok.nextToken();
            File file = new File(path);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                class_names = ClassUtil.getClassNamesFromDir(file);
                classes_set.addAll(ClassUtil.getClassesFromNames(class_names));
            }
            if (!file.isFile()) continue;
            class_names = ClassUtil.getClassNamesFromJar(file);
            classes_set.addAll(ClassUtil.getClassesFromNames(class_names));
        }
        return classes_set;
    }

    public static <T extends Class> Set<T> getClassesImplementing(Set<Class> classes, T cls) {
        TreeSet<Class> classes_set = new TreeSet<Class>(new ClassComparator());
        for (Class c : classes) {
            int mod;
            if (!cls.isAssignableFrom(c) || Modifier.isAbstract(mod = c.getModifiers()) || Modifier.isInterface(mod)) continue;
            classes_set.add(c);
        }
        return classes_set;
    }

    public static <T extends Class> Set<T> getClassesImplementing(T cls) throws IOException, ClassNotFoundException {
        return ClassUtil.getClassesImplementing(ClassUtil.getClassesFromClassPath(), cls);
    }

    public static <T> Set<T> getImplementations(Class<T> obj) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        TreeSet<Object> result = new TreeSet<Object>(new ObjectComparator());
        for (Class<T> cls : ClassUtil.getClassesImplementing(obj)) {
            result.add(cls.newInstance());
        }
        return result;
    }
}

