/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.security.SecureRandom;
import java.security.SecureRandomSpi;

public class VMPCRandom
extends SecureRandom {
    private static final long serialVersionUID = 4516013411867308772L;

    public VMPCRandom() {
        super(new Spi(), new SecureRandom().getProvider());
    }

    public static class Spi
    extends SecureRandomSpi {
        private static final long serialVersionUID = 6772408791281461866L;
        private byte n = 0;
        private byte[] P = new byte[]{118, -82, 96, -6, -105, 7, 18, 45, 114, -26, -62, -79, 15, -32, -61, 62, -60, 48, -65, -56, 102, -23, 121, -29, -52, 53, -75, 84, 104, -48, 76, -101, -1, 20, 33, 50, 120, 8, -67, 99, 19, 71, -43, 42, -45, -54, -36, 109, 56, -39, -7, 52, 14, 115, -126, 70, 4, 98, -94, -24, -55, 79, -78, -77, -74, -103, 43, 124, 55, -106, 127, -116, 34, 95, 119, -9, -27, 23, -19, -31, 107, -118, -10, -128, -47, 125, -71, 54, 5, -33, 108, 58, 81, -22, 87, -108, -120, 6, -84, -59, 44, 17, -70, -51, -102, 47, 32, -69, -97, -17, -114, 113, 110, 27, -124, -80, -49, 40, -14, -85, -42, 22, 69, -89, -125, 1, 2, 46, 59, 117, -98, -96, -87, -95, 126, -53, 116, -127, -111, 11, -122, 68, 66, 63, 21, 36, 49, 105, -3, -50, 122, -30, 28, -76, -117, 31, 106, 101, 123, -28, -12, -11, -34, 24, -5, -35, -16, 67, 9, 83, -44, -110, -113, -99, -100, 89, 0, 61, -93, 65, -37, 85, -107, 64, -57, 73, -4, 10, -92, 16, 100, 111, 75, -38, -21, -18, -72, -88, -20, -66, 94, -64, -63, 78, 51, 82, 88, 13, -104, -112, -68, 37, -2, 72, 93, -40, 35, 3, 60, 57, -121, -8, -109, -25, -46, 91, -13, 41, 97, -41, 30, 39, -123, -119, 80, 103, -73, 86, -81, 77, 12, -90, 29, 74, 112, -83, -91, -115, -15, 25, 26, -86, -58, 92, 38, 90};
        private byte s = (byte)-34;

        public Spi() {
            long seed = System.nanoTime();
            byte[] s = new byte[4];
            s[3] = (byte)(seed & 0xFFL);
            s[2] = (byte)((seed & 0xFF00L) >> 8);
            s[1] = (byte)((seed & 0xFF0000L) >> 16);
            s[0] = (byte)((seed & 0xFFFFFFFFFF000000L) >> 24);
            this.engineSetSeed(s);
        }

        protected byte[] engineGenerateSeed(int numBytes) {
            byte[] result = new byte[numBytes];
            this.engineNextBytes(result);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void engineNextBytes(byte[] bytes) {
            Spi spi = this;
            synchronized (spi) {
                for (int i = 0; i != bytes.length; ++i) {
                    this.s = this.P[this.s + this.P[this.n & 0xFF] & 0xFF];
                    bytes[i] = this.P[this.P[this.P[this.s & 0xFF] & 0xFF] + 1 & 0xFF];
                    byte temp = this.P[this.n & 0xFF];
                    this.P[this.n & 0xFF] = this.P[this.s & 0xFF];
                    this.P[this.s & 0xFF] = temp;
                    this.n = (byte)(this.n + 1 & 0xFF);
                }
            }
        }

        protected void engineSetSeed(byte[] seed) {
            if (seed != null && this.P != null) {
                for (int m = 0; m < seed.length; ++m) {
                    this.s = this.P[this.s + this.P[this.n & 0xFF] + seed[m] & 0xFF];
                    byte temp = this.P[this.n & 0xFF];
                    this.P[this.n & 0xFF] = this.P[this.s & 0xFF];
                    this.P[this.s & 0xFF] = temp;
                    this.n = (byte)(this.n + 1 & 0xFF);
                }
            }
        }
    }
}

