/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.db;

import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Stream;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.unified.QueryCriteria;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataSource;
import tigase.db.TigaseDBException;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.rsm.RSM;

public interface UnifiedArchiveRepository<DS extends DataSource>
extends MessageArchiveRepository<QueryCriteria, DS> {
    public Stream<? extends Item> queryRecents(BareJID var1, Date var2, Date var3, Set<Type> var4, Set<CallCondition> var5, RSM var6) throws TigaseDBException;

    public Stream<? extends FileItem> queryFiles(FileQuery var1, RSM var2) throws RepositoryException;

    public static final class ItemType
    extends Enum<ItemType> {
        public static final /* enum */ ItemType message = new ItemType("message", 0);
        public static final /* enum */ ItemType chat = new ItemType("chat", 1);
        public static final /* enum */ ItemType groupchat = new ItemType("groupchat", 2);
        public static final /* enum */ ItemType presence = new ItemType("presence", 10);
        public static final /* enum */ ItemType login = new ItemType("login", 128);
        public static final /* enum */ ItemType logout = new ItemType("logout", 129);
        public static final /* enum */ ItemType call = new ItemType("call", 132);
        private final String a;
        private final short b;
        public static final EnumSet MESSAGE_TYPES;
        private static final /* synthetic */ ItemType[] c;

        public static ItemType[] values() {
            return (ItemType[])c.clone();
        }

        public static ItemType valueOf(String name) {
            return Enum.valueOf(ItemType.class, name);
        }

        private ItemType(String stringValue, short shortValue) {
            this.a = stringValue;
            this.b = shortValue;
        }

        public short getShortValue() {
            return this.b;
        }

        public String getStringValue() {
            return this.a;
        }

        public static ItemType from(short value) {
            switch (value) {
                case 0: {
                    return message;
                }
                case 1: {
                    return chat;
                }
                case 2: {
                    return groupchat;
                }
                case 10: {
                    return presence;
                }
                case 128: {
                    return login;
                }
                case 129: {
                    return logout;
                }
                case 132: {
                    return call;
                }
            }
            return null;
        }

        public static ItemType from(String name) {
            switch (name) {
                case "message": {
                    return message;
                }
                case "chat": {
                    return chat;
                }
                case "groupchat": {
                    return groupchat;
                }
                case "presence": {
                    return presence;
                }
                case "login": {
                    return login;
                }
                case "logout": {
                    return logout;
                }
                case "call": {
                    return call;
                }
            }
            return null;
        }

        private static /* synthetic */ ItemType[] a() {
            return new ItemType[]{message, chat, groupchat, presence, login, logout, call};
        }

        static {
            c = ItemType.a();
            MESSAGE_TYPES = EnumSet.of(message, chat, groupchat);
        }
    }

    public static interface FileMetadata {
        public String getURL();

        public String getMediaType();

        public String getDescription();

        public String getName();

        public Long getSize();
    }

    public static interface FileItem
    extends FileMetadata {
        public String getId();

        public BareJID getOwner();

        public BareJID getBuddy();

        public Date getTimestamp();
    }

    public static interface FileQuery {
        public BareJID getDomain();

        public BareJID getOwner();

        public BareJID getBuddy();

        public Date getAfter();

        public Date getBefore();

        public String getContains();

        public String getMediaType();

        public Long getSmallerThan();

        public Long getBiggerThan();
    }

    public static interface Item
    extends MessageArchiveRepository.Item {
        public ItemType getItemType();

        public Long getDuration();

        public String getCondition();
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type chat = new Type();
        public static final /* enum */ Type call = new Type();
        public static final /* enum */ Type groupchat = new Type();
        private static final /* synthetic */ Type[] a;

        public static Type[] values() {
            return (Type[])a.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private static /* synthetic */ Type[] a() {
            return new Type[]{chat, call, groupchat};
        }

        static {
            a = Type.a();
        }
    }

    public static final class CallCondition
    extends Enum<CallCondition> {
        public static final /* enum */ CallCondition success = new CallCondition();
        public static final /* enum */ CallCondition missed = new CallCondition();
        public static final /* enum */ CallCondition canceled = new CallCondition();
        private static final /* synthetic */ CallCondition[] a;

        public static CallCondition[] values() {
            return (CallCondition[])a.clone();
        }

        public static CallCondition valueOf(String name) {
            return Enum.valueOf(CallCondition.class, name);
        }

        private static /* synthetic */ CallCondition[] a() {
            return new CallCondition[]{success, missed, canceled};
        }

        static {
            a = CallCondition.a();
        }
    }
}

