/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.db;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.unified.db.UnifiedArchiveRepository;
import tigase.component.exceptions.RepositoryException;
import tigase.db.AbstractDataSourceAwareTestCase;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataSourceAware;
import tigase.db.TigaseDBException;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.rsm.RSM;

public class JDBCUnifiedArchiveRepositoryWithRecentsTest2
extends AbstractDataSourceAwareTestCase<DataRepository, UnifiedArchiveRepository> {
    private static final String PROJECT_ID = "unified-archive";
    private static final String VERSION = "3.0.0-SNAPSHOT";
    @ClassRule
    public static TestRule rule = new TestRule(){

        public Statement apply(Statement stmnt, Description d) {
            if (uri == null || !uri.startsWith("jdbc:")) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        Assume.assumeTrue((String)"Ignored due to not passed DB URI!", (boolean)false);
                    }
                };
            }
            return stmnt;
        }
    };
    private List<JID> buddies = new ArrayList<JID>();
    private BareJID owner;
    private UnifiedArchiveRepository<DataRepository> repo;
    private Date start;
    private Date end;
    private List<Date> newestMessageDate = new ArrayList<Date>();

    @BeforeClass
    public static void prepareTest() throws DBInitException {
        JDBCUnifiedArchiveRepositoryWithRecentsTest2.loadSchema((String)PROJECT_ID, (String)VERSION, Collections.singleton(PROJECT_ID));
    }

    @Before
    public void setup() throws RepositoryException, InstantiationException, IllegalAccessException, TigaseStringprepException, InterruptedException, SQLException, ClassNotFoundException {
        this.repo = (UnifiedArchiveRepository)this.getDataSourceAware();
        this.owner = BareJID.bareJIDInstance((String)("owner-" + UUID.randomUUID().toString()), (String)"test.com");
        this.start = new Date(System.currentTimeMillis() - 10000L);
        this.end = new Date(System.currentTimeMillis() + 10000L);
        Thread.sleep(1000L);
        this.buddies.add(JID.jidInstance((String)("chat-" + UUID.randomUUID().toString()), (String)"test.com", (String)"res-1"));
        this.buddies.add(JID.jidInstance((String)("chat-" + UUID.randomUUID().toString()), (String)"test.com", (String)"res-1"));
        long diff = (this.end.getTime() - this.start.getTime()) / 5L;
        for (int i = 0; i < 2; ++i) {
            JID buddy = this.buddies.get(i);
            long startX = this.start.getTime() - (long)(1000 * i);
            Date date = new Date(startX + diff * 3L);
            Element elem = this.createGroupchat(this.owner, buddy, MessageArchiveRepository.Direction.incoming, UUID.randomUUID().toString());
            this.repo.archiveMessage(this.owner, buddy, date, elem, UUID.randomUUID().toString(), null);
            date = new Date(startX + diff * 4L);
            elem = this.createGroupchat(this.owner, buddy, MessageArchiveRepository.Direction.incoming, UUID.randomUUID().toString());
            this.repo.archiveMessage(this.owner, buddy, date, elem, UUID.randomUUID().toString(), null);
            if (i == 1) {
                elem = this.createGroupchat(this.owner, buddy, MessageArchiveRepository.Direction.incoming, UUID.randomUUID().toString());
                this.repo.archiveMessage(this.owner, buddy, date, elem, UUID.randomUUID().toString(), null);
            }
            this.newestMessageDate.add(date);
            date = new Date(startX + diff * 2L);
            elem = this.createGroupchat(this.owner, buddy, MessageArchiveRepository.Direction.incoming, UUID.randomUUID().toString());
            this.repo.archiveMessage(this.owner, buddy, date, elem, UUID.randomUUID().toString(), null);
            date = new Date(startX + diff * 1L);
            elem = this.createGroupchat(this.owner, buddy, MessageArchiveRepository.Direction.incoming, UUID.randomUUID().toString());
            this.repo.archiveMessage(this.owner, buddy, date, elem, UUID.randomUUID().toString(), null);
        }
    }

    @After
    public void tearDown() throws TigaseDBException {
        for (JID buddy : this.buddies) {
            this.repo.removeItems(this.owner, buddy.getBareJID().toString(), this.start, this.end);
        }
        this.repo.destroy();
    }

    @Test
    public void testQueryRecentsAll() throws TigaseDBException {
        try {
            this.assertRecentsQueryAll(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    @Test
    public void testQueryRecentsAllSince() throws TigaseDBException {
        this.assertRecentsQueryAll(this.start);
    }

    @Test
    public void testQueryRecentGroupchats() throws TigaseDBException {
        List<UnifiedArchiveRepository.Item> results = this.repo.queryRecents(this.owner, this.start, null, EnumSet.of(UnifiedArchiveRepository.Type.groupchat), EnumSet.allOf(UnifiedArchiveRepository.CallCondition.class), new RSM()).collect(Collectors.toList());
        List<BareJID> expBuddies = this.buddies.stream().map(buddy -> buddy.getBareJID()).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)results.size());
        this.assertItem(results, expBuddies, this.newestMessageDate, 0, UnifiedArchiveRepository.ItemType.groupchat);
        this.assertItem(results, expBuddies, this.newestMessageDate, 1, UnifiedArchiveRepository.ItemType.groupchat);
    }

    protected Class<? extends DataSourceAware> getDataSourceAwareIfc() {
        return UnifiedArchiveRepository.class;
    }

    private void assertRecentsQueryAll(Date start) throws TigaseDBException {
        List<UnifiedArchiveRepository.Item> results = this.repo.queryRecents(this.owner, start, null, EnumSet.allOf(UnifiedArchiveRepository.Type.class), EnumSet.allOf(UnifiedArchiveRepository.CallCondition.class), new RSM()).collect(Collectors.toList());
        List<BareJID> expBuddies = this.buddies.stream().map(buddy -> buddy.getBareJID()).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)results.size());
        this.assertItem(results, expBuddies, this.newestMessageDate, 0, UnifiedArchiveRepository.ItemType.groupchat);
        this.assertItem(results, expBuddies, this.newestMessageDate, 1, UnifiedArchiveRepository.ItemType.groupchat);
    }

    private void assertItem(List<UnifiedArchiveRepository.Item> results, List<BareJID> expBuddies, List<Date> expDates, int pos, UnifiedArchiveRepository.ItemType itemType) {
        this.assertItem(results, expBuddies, expDates, pos, itemType, null);
    }

    private void assertItem(List<UnifiedArchiveRepository.Item> results, List<BareJID> expBuddies, List<Date> expDates, int pos, UnifiedArchiveRepository.ItemType itemType, Predicate<UnifiedArchiveRepository.Item> itemPredicate) {
        UnifiedArchiveRepository.Item item = results.get(pos);
        Assert.assertEquals((Object)expBuddies.get(pos).toString(), (Object)item.getWith());
        Assert.assertEquals((Object)itemType, (Object)item.getItemType());
        Assert.assertTrue((expDates.get(pos).getTime() / 1000L == item.getTimestamp().getTime() / 1000L ? 1 : 0) != 0);
        if (itemPredicate != null) {
            Assert.assertTrue((boolean)itemPredicate.test(item));
        }
    }

    private Element createGroupchat(BareJID owner, JID buddy, MessageArchiveRepository.Direction direction, String body) {
        String[] stringArray;
        String[] stringArray2 = new String[]{"from", "to"};
        if (direction == MessageArchiveRepository.Direction.incoming) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = buddy.toString();
            stringArray = stringArray3;
            stringArray3[1] = owner.toString();
        } else {
            String[] stringArray4 = new String[2];
            stringArray4[0] = owner.toString();
            stringArray = stringArray4;
            stringArray4[1] = buddy.toString();
        }
        Element message = new Element("message", stringArray2, stringArray);
        message.setAttribute("type", "groupchat");
        message.addChild((XMLNodeIfc)new Element("body", body));
        return message;
    }
}

