/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.db;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.MethodSorters;
import org.junit.runners.model.Statement;
import tigase.archive.processors.MessageArchivePlugin;
import tigase.archive.unified.QueryCriteria;
import tigase.archive.unified.db.JDBCFlexibleOfflineMessageRetrievalRepository;
import tigase.archive.unified.db.UnifiedArchiveRepository;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataSourceAware;
import tigase.server.xmppsession.SessionManagerHandler;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.impl.AbstractProcessorWithDataSourceAwareTestCase;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.Query;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class JDBCFlexibleOfflineMessageRespositoryTest
extends AbstractProcessorWithDataSourceAwareTestCase<DataRepository, UnifiedArchiveRepository> {
    private static final Logger log = Logger.getLogger(JDBCFlexibleOfflineMessageRespositoryTest.class.getCanonicalName());
    private static final SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final String PROJECT_ID = "unified-archive";
    private static final String VERSION = "3.0.0";
    @ClassRule
    public static TestRule rule = new TestRule(){

        public Statement apply(Statement stmnt, Description d) {
            if (uri == null || !uri.startsWith("jdbc:")) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        Assume.assumeTrue((String)"Ignored due to not passed DB URI!", (boolean)false);
                    }
                };
            }
            return stmnt;
        }
    };
    private JID buddy = null;
    private JID owner = null;
    private JID ownerConnId = JID.jidInstanceNS((String)"c2s@zeus/14ds34d-sersrs");
    private JDBCFlexibleOfflineMessageRetrievalRepository repo;
    private Date testStart = null;

    @BeforeClass
    public static void prepareTest() throws DBInitException {
        JDBCFlexibleOfflineMessageRespositoryTest.loadSchema((String)PROJECT_ID, (String)VERSION, Collections.singleton(PROJECT_ID));
    }

    @Before
    public void setup() throws Exception {
        this.getKernel().registerBean(MessageArchivePlugin.class).setActive(true).exec();
        this.getKernel().registerBean(JDBCFlexibleOfflineMessageRetrievalRepository.class).exportable().setActive(true).exec();
        this.repo = (JDBCFlexibleOfflineMessageRetrievalRepository)this.getKernel().getInstance(JDBCFlexibleOfflineMessageRetrievalRepository.class);
        this.repo.setDataSource((DataRepository)this.dataSource);
        this.owner = JID.jidInstanceNS((String)("ua-" + UUID.randomUUID()), (String)"test", (String)"tigase-1");
        this.buddy = JID.jidInstanceNS((String)("ua-" + UUID.randomUUID()), (String)"test", (String)"tigase-2");
        this.getUserRepository().addUser(this.owner.getBareJID());
        this.getUserRepository().addUser(this.buddy.getBareJID());
    }

    @After
    public void tearDown() throws Exception {
        this.repo = null;
    }

    @Test
    public void testOfflineMessageRetrieval() throws RepositoryException, TigaseStringprepException, NotAuthorizedException, ComponentException {
        XMPPResourceConnection conn = this.getXMPPResourceConnection(this.ownerConnId, this.owner);
        this.repo.deleteMessagesToJID(null, conn);
        Date date = new Date();
        String body = "Test 1";
        Element msg = new Element("message", new String[]{"from", "to", "type"}, new String[]{this.buddy.toString(), this.owner.toString(), StanzaType.chat.name()});
        msg.addChild((XMLNodeIfc)new Element("body", body));
        this.repo.storeMessage(this.buddy, this.owner, date, msg, null);
        body = "Test 2 with #Test123";
        msg = new Element("message", new String[]{"from", "to", "type"}, new String[]{this.buddy.toString(), this.owner.toString(), StanzaType.chat.name()});
        msg.addChild((XMLNodeIfc)new Element("body", body));
        this.repo.storeMessage(this.buddy, this.owner, date, msg, null);
        Element presence = new Element("presence", new String[]{"from", "to", "type"}, new String[]{this.buddy.toString(), this.owner.toString(), StanzaType.subscribe.name()});
        this.repo.storeMessage(this.buddy, this.owner, date, presence, null);
        msg = new Element("message", new String[]{"from", "to"}, new String[]{this.buddy.toString(), this.owner.toString()});
        msg.addChild((XMLNodeIfc)new Element("x", new Element[]{new Element("invite", new String[]{"from"}, new String[]{this.buddy.toString()})}, new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"}));
        Assert.assertTrue((boolean)this.repo.storeMessage(this.buddy, this.owner, new Date(), msg, null));
        Map counts = this.repo.getMessagesCount(this.owner);
        Assert.assertNotNull((Object)counts);
        Assert.assertEquals((long)2L, (long)counts.size());
        Assert.assertEquals((String)("Wrong number of messages for user " + this.owner), (long)3L, (long)((Long)counts.get(JDBCFlexibleOfflineMessageRetrievalRepository.MSG_TYPES.message)));
        Assert.assertEquals((long)1L, (long)((Long)counts.get(JDBCFlexibleOfflineMessageRetrievalRepository.MSG_TYPES.presence)));
        Queue msgs = this.repo.loadMessagesToJID(conn, false);
        Assert.assertEquals((long)4L, (long)msgs.size());
        List items = this.repo.getMessagesList(this.owner);
        Assert.assertEquals((long)4L, (long)items.size());
        String msgId = ((Element)items.get(0)).getAttribute("node");
        msgs = this.repo.loadMessagesToJID(Collections.singletonList(msgId), conn, true, null);
        Assert.assertEquals((long)1L, (long)msgs.size());
        msgs = this.repo.loadMessagesToJID(conn, false);
        Assert.assertEquals((long)3L, (long)msgs.size());
        this.repo.deleteMessagesToJID(null, conn);
        UnifiedArchiveRepository ua_repo = (UnifiedArchiveRepository)this.getInstance(UnifiedArchiveRepository.class);
        QueryCriteria crit = (QueryCriteria)ua_repo.newQuery();
        crit.setQuestionerJID(this.owner);
        ua_repo.queryItems((Query)crit, (query, item) -> Assert.assertNotNull((Object)item.getMessage().getChild("body")));
    }

    protected Class<? extends DataSourceAware> getDataSourceAwareIfc() {
        return UnifiedArchiveRepository.class;
    }

    protected XMPPResourceConnection getXMPPResourceConnection(JID connId, JID owner) throws TigaseStringprepException, NotAuthorizedException {
        return super.getSession(connId, owner);
    }

    static {
        formatter2.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private class SessionManagerHandlerImpl
    implements SessionManagerHandler {
        Map<BareJID, XMPPSession> sessions = new HashMap<BareJID, XMPPSession>();

        public JID getComponentId() {
            return JID.jidInstanceNS((String)"sess-man@localhost");
        }

        public void handleLogin(BareJID userId, XMPPResourceConnection conn) {
            XMPPSession session = this.sessions.get(userId);
            if (session == null) {
                session = new XMPPSession(userId.getLocalpart());
                this.sessions.put(userId, session);
            }
            try {
                session.addResourceConnection(conn);
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.SEVERE, null, ex);
            }
        }

        public void handleLogout(BareJID userId, XMPPResourceConnection conn) {
            XMPPSession session = this.sessions.get(conn);
            if (session != null) {
                session.removeResourceConnection(conn);
                if (session.getActiveResourcesSize() == 0) {
                    this.sessions.remove(userId);
                }
            }
        }

        public void handlePresenceSet(XMPPResourceConnection conn) {
        }

        public void handleResourceBind(XMPPResourceConnection conn) {
        }

        public boolean isLocalDomain(String domain, boolean includeComponents) {
            return !domain.contains("-ext");
        }

        public void handleDomainChange(String domain, XMPPResourceConnection conn) {
        }
    }
}

