/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.modules;

import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import tigase.archive.unified.UnifiedArchiveComponent;
import tigase.archive.unified.db.UnifiedArchiveRepository;
import tigase.component.PacketWriter;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.component.modules.Module;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.db.DataSource;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.VHostManagerIfc;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.rsm.RSM;

@Bean(name="file-query", parent=UnifiedArchiveComponent.class, active=true)
public class FileQueryModule
implements Module {
    private static final String a = "urn:xmpp:tigase:file:metadata";
    private static final Criteria b = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"query", (String)"urn:xmpp:tigase:file:metadata"));
    private static final TimestampHelper c = new TimestampHelper();
    @Inject
    private UnifiedArchiveRepository<DataSource> repository;
    @Inject
    private VHostManagerIfc vHostManager;
    @Inject
    private PacketWriter writer;
    @Inject(bean="service")
    private UnifiedArchiveComponent component;
    @ConfigField(desc="Allow domain querying users data", alias="allow-admin-querying-users-data")
    private boolean allowAdminQueryingUsersData = false;

    public Criteria getModuleCriteria() {
        return b;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        block5: {
            try {
                BareJID bareJID = packet.getStanzaFrom().getBareJID();
                Element element = packet.getElemChild("query", a);
                if (packet.getType() == StanzaType.get) {
                    Element element2 = element.clone();
                    element2.setChildren(List.of(this.prepareForm(bareJID).build()));
                    this.writer.write(packet.okResult(element2, 0));
                    break block5;
                }
                if (packet.getType() == StanzaType.set) {
                    RSM rSM = RSM.parseRootElement((Element)element);
                    FileQuery fileQuery = this.parseForm(element);
                    this.validateQuery(fileQuery, packet.getStanzaFrom().getBareJID());
                    boolean bl = !bareJID.equals((Object)fileQuery.getBuddy());
                    List list = this.repository.queryFiles(fileQuery, rSM).map(fileItem -> this.fileItemToElement((UnifiedArchiveRepository.FileItem)fileItem, bl)).collect(Collectors.toList());
                    Element element3 = element.clone();
                    element3.setName("list");
                    element3.setChildren(Collections.unmodifiableList(list));
                    element3.addChild((XMLNodeIfc)rSM.toElement());
                    this.writer.write(packet.okResult(element3, 0));
                    break block5;
                }
                throw new ComponentException(Authorization.BAD_REQUEST);
            }
            catch (ParseException parseException) {
                throw new ComponentException(Authorization.BAD_REQUEST, null, (Throwable)parseException);
            }
            catch (RepositoryException repositoryException) {
                throw new ComponentException(Authorization.INTERNAL_SERVER_ERROR, null, (Throwable)repositoryException);
            }
        }
    }

    protected Element fileItemToElement(UnifiedArchiveRepository.FileItem item, boolean isAdmin) {
        Element element = new Element("item");
        element.setAttribute("id", item.getId());
        element.setAttribute("with", item.getBuddy().toString());
        element.setAttribute("stamp", c.formatWithMs(item.getTimestamp()));
        element.setAttribute("url", item.getURL());
        element.addChild((XMLNodeIfc)this.fileMetadataToElement(item));
        if (isAdmin) {
            element.setAttribute("owner", item.getOwner().toString());
        }
        return element;
    }

    protected Element fileMetadataToElement(UnifiedArchiveRepository.FileItem item) {
        Element element = new Element("file");
        element.setXMLNS("urn:xmpp:jingle:apps:file-transfer:5");
        Optional.ofNullable(item.getMediaType()).map(string -> new Element("media-type", string)).ifPresent(arg_0 -> ((Element)element).addChild(arg_0));
        Optional.ofNullable(item.getName()).map(string -> new Element("name", string)).ifPresent(arg_0 -> ((Element)element).addChild(arg_0));
        Optional.ofNullable(item.getSize()).map(String::valueOf).map(string -> new Element("size", string)).ifPresent(arg_0 -> ((Element)element).addChild(arg_0));
        Optional.ofNullable(item.getDescription()).map(string -> new Element("desc", string)).ifPresent(arg_0 -> ((Element)element).addChild(arg_0));
        return element;
    }

    protected DataForm.Builder prepareForm(BareJID requestor) {
        DataForm.Builder builder2 = new DataForm.Builder(Command.DataType.form).withField(DataForm.FieldType.Hidden, "FORM_TYPE", builder -> builder.setValue(a));
        List<JID> list = this.getManagerVHosts(requestor);
        if (this.allowAdminQueryingUsersData && !list.isEmpty()) {
            builder2.withField(DataForm.FieldType.ListSingle, "domain", builder -> builder.setLabel("Domain").setOptions((String[])list.stream().map(JID::toString).toArray(String[]::new)));
            builder2.withField(DataForm.FieldType.JidSingle, "owner", builder -> builder.setLabel("Message owner"));
        }
        return builder2.withField(DataForm.FieldType.TextSingle, "after", builder -> builder.setLabel("After timestamp")).withField(DataForm.FieldType.TextSingle, "before", builder -> builder.setLabel("Before timestamp")).withField(DataForm.FieldType.TextSingle, "contains", builder -> builder.setLabel("Text to search for in name, description or url")).withField(DataForm.FieldType.TextSingle, "media-type", builder -> builder.setLabel("Part of media type (MimeType)")).withField(DataForm.FieldType.TextSingle, "smaller-than", builder -> builder.setLabel("Maximal size of a file")).withField(DataForm.FieldType.TextSingle, "bigger-than", builder -> builder.setLabel("Minimal size of a file"));
    }

    protected FileQuery parseForm(Element form) throws ParseException {
        return new FileQuery(BareJID.bareJIDInstanceNS((String)DataForm.getFieldValue((Element)form, (String)"domain")), BareJID.bareJIDInstanceNS((String)DataForm.getFieldValue((Element)form, (String)"owner")), BareJID.bareJIDInstanceNS((String)"buddy"), c.parseTimestamp(DataForm.getFieldValue((Element)form, (String)"after")), c.parseTimestamp(DataForm.getFieldValue((Element)form, (String)"before")), DataForm.getFieldValue((Element)form, (String)"contains"), DataForm.getFieldValue((Element)form, (String)"media-type"), Optional.ofNullable(DataForm.getFieldValue((Element)form, (String)"smaller-than")).map(Long::parseLong).orElse(null), Optional.ofNullable(DataForm.getFieldValue((Element)form, (String)"bigger-than")).map(Long::parseLong).orElse(null));
    }

    protected void validateQuery(FileQuery query, BareJID requestor) throws ComponentException {
        if (query.getDomain() == null) {
            if (query.getOwner() == null) {
                query.setOwner(requestor);
            }
            query.setDomain(BareJID.bareJIDInstanceNS((String)query.getOwner().getDomain()));
        }
        if (query.getOwner() != null && !query.getOwner().getDomain().equals(query.getDomain().getDomain())) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Requested domain to query must match domain of specified owner jid!");
        }
        if (!(requestor.equals((Object)query.getOwner()) || this.allowAdminQueryingUsersData && this.isAdminOrDomainAdmin(query.getDomain().getDomain(), requestor))) {
            throw new ComponentException(Authorization.FORBIDDEN, "You are not authorized to query this repository!");
        }
    }

    protected boolean isAdminOrDomainAdmin(String domain, BareJID jid) {
        return this.component.isAdmin(JID.jidInstanceNS((BareJID)jid)) || Optional.ofNullable(this.vHostManager.getVHostItem(domain)).filter(vHostItem -> vHostItem.isAdmin(jid.toString())).isPresent();
    }

    protected List<JID> getManagerVHosts(BareJID jid) {
        return this.component.isAdmin(JID.jidInstanceNS((BareJID)jid)) ? this.vHostManager.getAllVHosts() : this.vHostManager.getAllVHosts().stream().filter(jID -> Optional.ofNullable(this.vHostManager.getVHostItem(jID.toString())).filter(vHostItem -> vHostItem.isAdmin(jid.toString())).isPresent()).collect(Collectors.toList());
    }

    public static class FileQuery
    implements UnifiedArchiveRepository.FileQuery {
        private BareJID a;
        private BareJID b;
        private final BareJID c;
        private final Date d;
        private final Date e;
        private final String f;
        private final String g;
        private final Long h;
        private final Long i;

        public FileQuery(BareJID domain, BareJID owner, BareJID buddy, Date after, Date before, String contains, String mediaType, Long smallerThan, Long biggerThan) {
            this.a = domain;
            this.b = owner;
            this.c = buddy;
            this.d = after;
            this.e = before;
            this.f = contains;
            this.g = mediaType;
            this.h = smallerThan;
            this.i = biggerThan;
        }

        @Override
        public BareJID getDomain() {
            return this.a;
        }

        @Override
        public BareJID getOwner() {
            return this.b;
        }

        @Override
        public BareJID getBuddy() {
            return this.c;
        }

        @Override
        public Date getAfter() {
            return this.d;
        }

        @Override
        public Date getBefore() {
            return this.e;
        }

        @Override
        public String getContains() {
            return this.f;
        }

        @Override
        public String getMediaType() {
            return this.g;
        }

        @Override
        public Long getSmallerThan() {
            return this.h;
        }

        @Override
        public Long getBiggerThan() {
            return this.i;
        }

        protected void setDomain(BareJID domain) {
            this.a = domain;
        }

        protected void setOwner(BareJID owner) {
            this.b = owner;
        }
    }
}

