/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.db;

import java.security.SecureRandom;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.MethodSorters;
import org.junit.runners.model.Statement;
import tigase.archive.unified.QueryCriteria;
import tigase.archive.unified.db.JDBCUnifiedArchiveRepository;
import tigase.archive.unified.db.UnifiedArchiveRepository;
import tigase.archive.unified.modules.FileQueryModule;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.AbstractDataSourceAwareTestCase;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataSourceAware;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.Query;
import tigase.xmpp.rsm.RSM;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class JDBCUnifiedArchiveRepository_FileMetadataTest
extends AbstractDataSourceAwareTestCase<DataRepository, UnifiedArchiveRepository> {
    private static final SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final String PROJECT_ID = "unified-archive";
    private static final String VERSION = "3.0.0-SNAPSHOT";
    protected static String emoji = "\ud83d\ude97\ud83d\udca9\ud83d\ude21";
    private static JID[] buddies = null;
    private static JID owner = null;
    private static Date testStart = null;
    private static List<TestItem> allFiles = new ArrayList<TestItem>();
    @ClassRule
    public static TestRule rule = new TestRule(){

        public Statement apply(Statement stmnt, Description d) {
            if (uri == null || !uri.startsWith("jdbc:")) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        Assume.assumeTrue((String)"Ignored due to not passed DB URI!", (boolean)false);
                    }
                };
            }
            return stmnt;
        }
    };
    private UnifiedArchiveRepository<DataRepository> repo;
    private static final SecureRandom random;
    private static final Set<String> forbidden;
    private static final String[] filenameExtensions;
    private static final String[] mediaTypes;
    private static int minimalTimestampOffset;

    @BeforeClass
    public static void prepareTest() throws DBInitException {
        JDBCUnifiedArchiveRepository_FileMetadataTest.loadSchema((String)PROJECT_ID, (String)VERSION, Collections.singleton(PROJECT_ID));
        owner = JID.jidInstanceNS((String)("ua-fm-" + UUID.randomUUID()), (String)"test", (String)"tigase-1");
        buddies = (JID[])IntStream.of(0, 1, 2).mapToObj(x -> JID.jidInstanceNS((String)("ua-fm-" + UUID.randomUUID()), (String)"test1", (String)("tigase-" + x))).toArray(JID[]::new);
    }

    @Before
    public void setup() throws RepositoryException, InstantiationException, IllegalAccessException, SQLException, ClassNotFoundException {
        this.repo = (UnifiedArchiveRepository)this.getDataSourceAware();
    }

    protected Class<? extends DataSourceAware> getDataSourceAwareIfc() {
        return UnifiedArchiveRepository.class;
    }

    protected String generateString(int lenght) {
        return random.ints(lenght, 33, 127).mapToObj(x -> String.valueOf((char)x)).filter(x -> !forbidden.contains(x)).collect(Collectors.joining());
    }

    protected String generateFilename(String suffix) {
        return this.generateString(10) + "." + suffix;
    }

    protected String generateFilename() {
        return this.generateFilename(filenameExtensions[random.nextInt(filenameExtensions.length)]);
    }

    protected String generateURL(String filename) {
        return "https://example.com:443/" + UUID.randomUUID().toString() + "/file/" + filename;
    }

    protected String generateURL() {
        return this.generateURL(this.generateFilename());
    }

    protected String generateMediaType() {
        return mediaTypes[random.nextInt(mediaTypes.length)];
    }

    protected UnifiedArchiveRepository.FileMetadata generateFileMetadata() {
        String filename = this.generateFilename();
        if (random.nextBoolean()) {
            return new JDBCUnifiedArchiveRepository.FileMetadata(XMLUtils.escape((String)this.generateURL(filename)), this.generateMediaType(), XMLUtils.escape((String)filename), "Interesting file " + UUID.randomUUID(), Long.valueOf(Math.abs(random.nextLong())));
        }
        return new JDBCUnifiedArchiveRepository.FileMetadata(XMLUtils.escape((String)this.generateURL(filename)));
    }

    protected Date nextTimstamp() {
        int offset = minimalTimestampOffset;
        minimalTimestampOffset += random.nextInt(20);
        if (uri.contains(":sqlserver:")) {
            long tmp = System.currentTimeMillis() / 10L * 10L;
            return new Date(tmp + (long)(offset * 100));
        }
        return new Date(System.currentTimeMillis() + (long)(offset * 100));
    }

    protected TestItem genereteFileItem() {
        return new TestItem(owner.getBareJID(), buddies[random.nextInt(buddies.length)], this.nextTimstamp(), UUID.randomUUID().toString(), this.generateFileMetadata());
    }

    protected Element packetFromItem(TestItem item) {
        Element msg = new Element("message", new String[]{"from", "to", "type"}, new String[]{item.getOwner().toString(), item.getBuddy().toString(), StanzaType.chat.name()});
        msg.withElement("oob", "jabber:iq:oob", oob -> oob.withElement("url", null, item.getMetadata().getURL()));
        msg.withElement("body", null, item.getMetadata().getURL());
        if (item.getMetadata().getName() != null) {
            Element fileEl = new Element("file");
            fileEl.setXMLNS("urn:xmpp:jingle:apps:file-transfer:5");
            fileEl.addChild((XMLNodeIfc)new Element("media-type", item.getMetadata().getMediaType()));
            fileEl.addChild((XMLNodeIfc)new Element("name", item.getMetadata().getName()));
            fileEl.addChild((XMLNodeIfc)new Element("desc", item.getMetadata().getDescription()));
            fileEl.addChild((XMLNodeIfc)new Element("size", String.valueOf(item.getMetadata().getSize())));
            Element referenceEl = new Element("reference");
            referenceEl.setXMLNS("urn:xmpp:reference:0");
            referenceEl.setAttribute("type", "data");
            referenceEl.setAttribute("uri", item.getMetadata().getURL());
            Element mediaSharing = new Element("media-sharing");
            mediaSharing.setXMLNS("urn:xmpp:sims:1");
            referenceEl.addChild((XMLNodeIfc)mediaSharing);
            mediaSharing.addChild((XMLNodeIfc)fileEl);
            msg.addChild((XMLNodeIfc)referenceEl);
        }
        return msg;
    }

    @Test
    public void test1_archiveFiles() throws RepositoryException, ComponentException {
        Date date;
        if (uri == null) {
            return;
        }
        testStart = date = new Date();
        for (int i = 0; i < 20; ++i) {
            TestItem item2 = this.genereteFileItem();
            Element msg = this.packetFromItem(item2);
            this.repo.archiveMessage(item2.getOwner(), item2.getBuddy(), item2.getTimestamp(), msg, item2.getId(), null);
            allFiles.add(item2);
        }
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setStart(date);
        crit.getRsm().setMax(1);
        this.repo.queryItems((Query)crit, (query, item) -> {});
        Assert.assertEquals((String)"Invalid count of archived messages", (long)20L, (long)crit.getRsm().getCount().intValue());
    }

    @Test
    public void test2_queryAllFiles() throws RepositoryException, ComponentException {
        FileQueryModule.FileQuery query = new FileQueryModule.FileQuery(BareJID.bareJIDInstanceNS((String)owner.getDomain()), owner.getBareJID(), null, null, null, null, null, null, null);
        RSM rsm = new RSM(100);
        List expected = allFiles.stream().map(this::mapToFileItem).collect(Collectors.toList());
        List items = this.repo.queryFiles((UnifiedArchiveRepository.FileQuery)query, rsm).collect(Collectors.toList());
        for (int i = 0; i < expected.size(); ++i) {
            UnifiedArchiveRepository.FileItem i1 = (UnifiedArchiveRepository.FileItem)expected.get(i);
            UnifiedArchiveRepository.FileItem i2 = (UnifiedArchiveRepository.FileItem)items.get(i);
            Assert.assertEquals((Object)i1.getId(), (Object)i2.getId());
            Assert.assertEquals((Object)i1.getURL(), (Object)i2.getURL());
            Assert.assertEquals((Object)i1.getName(), (Object)i2.getName());
            Assert.assertEquals((Object)i1.getDescription(), (Object)i2.getDescription());
            Assert.assertEquals((Object)i1.getMediaType(), (Object)i2.getMediaType());
            Assert.assertEquals((Object)i1.getSize(), (Object)i2.getSize());
        }
        Assert.assertEquals((long)20L, (long)rsm.getCount().intValue());
    }

    @Test
    public void test3_queryFirst10Files() throws RepositoryException, ComponentException {
        FileQueryModule.FileQuery query = new FileQueryModule.FileQuery(BareJID.bareJIDInstanceNS((String)owner.getDomain()), owner.getBareJID(), null, null, null, null, null, null, null);
        RSM rsm = new RSM(10);
        List expected = allFiles.stream().limit(10L).map(this::mapToFileItem).collect(Collectors.toList());
        List items = this.repo.queryFiles((UnifiedArchiveRepository.FileQuery)query, rsm).collect(Collectors.toList());
        Assert.assertEquals(expected, items);
        Assert.assertEquals((long)20L, (long)rsm.getCount().intValue());
    }

    @Test
    public void test4_queryAfterFiles() throws RepositoryException, ComponentException {
        FileQueryModule.FileQuery query = new FileQueryModule.FileQuery(BareJID.bareJIDInstanceNS((String)owner.getDomain()), owner.getBareJID(), null, null, null, null, null, null, null);
        RSM rsm = new RSM(10);
        rsm.setAfter(JDBCUnifiedArchiveRepository_FileMetadataTest.allFiles.get((int)9).id);
        List expected = allFiles.stream().skip(10L).map(this::mapToFileItem).collect(Collectors.toList());
        List items = this.repo.queryFiles((UnifiedArchiveRepository.FileQuery)query, rsm).collect(Collectors.toList());
        Assert.assertEquals(expected, items);
        Assert.assertEquals((long)20L, (long)rsm.getCount().intValue());
    }

    @Test
    public void test5_queryBuddy1Files() throws RepositoryException, ComponentException {
        FileQueryModule.FileQuery query = new FileQueryModule.FileQuery(BareJID.bareJIDInstanceNS((String)owner.getDomain()), owner.getBareJID(), buddies[0].getBareJID(), null, null, null, null, null, null);
        RSM rsm = new RSM(100);
        List expected = allFiles.stream().filter(item -> buddies[0].equals((Object)item.getBuddy())).map(this::mapToFileItem).collect(Collectors.toList());
        List items = this.repo.queryFiles((UnifiedArchiveRepository.FileQuery)query, rsm).collect(Collectors.toList());
        Assert.assertEquals(expected, items);
        Assert.assertEquals((long)expected.size(), (long)rsm.getCount().intValue());
    }

    @Test
    public void test5_queryDomainFiles() throws RepositoryException, ComponentException {
        FileQueryModule.FileQuery query = new FileQueryModule.FileQuery(BareJID.bareJIDInstanceNS((String)owner.getDomain()), null, null, testStart, null, null, null, null, null);
        RSM rsm = new RSM(100);
        List expected = allFiles.stream().map(this::mapToFileItem).collect(Collectors.toList());
        List items = this.repo.queryFiles((UnifiedArchiveRepository.FileQuery)query, rsm).collect(Collectors.toList());
        Assert.assertEquals(expected, items);
        Assert.assertEquals((long)expected.size(), (long)rsm.getCount().intValue());
    }

    @Test
    public void test6_queryFilesByMediaType() throws RepositoryException, ComponentException {
        Optional<String> mediaType = allFiles.stream().map(TestItem::getMetadata).map(UnifiedArchiveRepository.FileMetadata::getMediaType).filter(Objects::nonNull).findFirst();
        if (mediaType.isPresent()) {
            FileQueryModule.FileQuery query = new FileQueryModule.FileQuery(BareJID.bareJIDInstanceNS((String)owner.getDomain()), owner.getBareJID(), null, null, null, null, mediaType.get(), null, null);
            RSM rsm = new RSM(100);
            List expected = allFiles.stream().filter(item -> ((String)mediaType.get()).equals(item.getMetadata().getMediaType())).map(this::mapToFileItem).collect(Collectors.toList());
            List items = this.repo.queryFiles((UnifiedArchiveRepository.FileQuery)query, rsm).collect(Collectors.toList());
            Assert.assertEquals(expected, items);
            Assert.assertEquals((long)expected.size(), (long)rsm.getCount().intValue());
        }
    }

    @Test
    public void test7_queryFilesByContains() throws RepositoryException, ComponentException {
        Optional<String> contains = allFiles.stream().map(TestItem::getMetadata).map(UnifiedArchiveRepository.FileMetadata::getName).filter(Objects::nonNull).findFirst();
        if (contains.isPresent()) {
            FileQueryModule.FileQuery query = new FileQueryModule.FileQuery(BareJID.bareJIDInstanceNS((String)owner.getDomain()), owner.getBareJID(), null, null, null, contains.get(), null, null, null);
            RSM rsm = new RSM(100);
            List expected = allFiles.stream().filter(item -> ((String)contains.get()).equals(item.getMetadata().getName())).limit(1L).map(this::mapToFileItem).collect(Collectors.toList());
            List items = this.repo.queryFiles((UnifiedArchiveRepository.FileQuery)query, rsm).collect(Collectors.toList());
            Assert.assertEquals(expected, items);
            Assert.assertEquals((long)expected.size(), (long)rsm.getCount().intValue());
        }
    }

    @Test
    public void test8_removeItems() throws RepositoryException, ComponentException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setStart(testStart);
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((Query)crit, (query, item) -> msgs.add((UnifiedArchiveRepository.Item)item));
        Assert.assertNotEquals((String)"No messages in repository to execute test - we should have some already", (long)0L, (long)msgs.size());
        this.repo.removeItems(owner.getBareJID(), null, testStart, new Date(System.currentTimeMillis() + 1000000L));
        msgs.clear();
        this.repo.queryItems((Query)crit, (query, item) -> msgs.add((UnifiedArchiveRepository.Item)item));
        Assert.assertEquals((String)"Still some messages, while in this duration all should be deleted", (long)0L, (long)msgs.size());
    }

    protected UnifiedArchiveRepository.FileItem mapToFileItem(TestItem item) {
        return new JDBCUnifiedArchiveRepository.FileItem(item.getOwner(), item.getBuddy().getBareJID(), item.getTimestamp(), item.getId(), item.getMetadata().getURL(), item.getMetadata().getMediaType(), item.getMetadata().getName(), item.getMetadata().getDescription(), item.getMetadata().getSize());
    }

    static {
        formatter2.setTimeZone(TimeZone.getTimeZone("UTC"));
        random = new SecureRandom();
        forbidden = Set.of("'", "\"");
        filenameExtensions = new String[]{"jpg", "png", "avi", "mov", "mp4", "doc", "docx", "zip", "7zip", "gz", "hvec"};
        mediaTypes = new String[]{"image/png", "image/jpeg", "video/avi", "video/mpeg", "unknown"};
        minimalTimestampOffset = 1;
    }

    private class TestItem {
        private final BareJID owner;
        private final JID buddy;
        private final Date timestamp;
        private final String id;
        private final UnifiedArchiveRepository.FileMetadata metadata;

        public TestItem(BareJID owner, JID buddy, Date timestamp, String id, UnifiedArchiveRepository.FileMetadata metadata) {
            this.owner = owner;
            this.buddy = buddy;
            this.timestamp = timestamp;
            this.metadata = metadata;
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public BareJID getOwner() {
            return this.owner;
        }

        public JID getBuddy() {
            return this.buddy;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public UnifiedArchiveRepository.FileMetadata getMetadata() {
            return this.metadata;
        }
    }
}

