/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.db;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.unified.db.UnifiedArchiveRepository;
import tigase.component.exceptions.RepositoryException;
import tigase.db.AbstractDataSourceAwareTestCase;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataSourceAware;
import tigase.db.TigaseDBException;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.rsm.RSM;

public class JDBCUnifiedArchiveRepositoryWithRecentsTest
extends AbstractDataSourceAwareTestCase<DataRepository, UnifiedArchiveRepository> {
    private static final String PROJECT_ID = "unified-archive";
    private static final String VERSION = "2.0.0";
    @ClassRule
    public static TestRule rule = new TestRule(){

        public Statement apply(Statement stmnt, Description d) {
            if (uri == null || !uri.startsWith("jdbc:")) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        Assume.assumeTrue((String)"Ignored due to not passed DB URI!", (boolean)false);
                    }
                };
            }
            return stmnt;
        }
    };
    private List<JID> buddies = new ArrayList<JID>();
    private BareJID owner;
    private UnifiedArchiveRepository<DataRepository> repo;
    private Date start;

    @BeforeClass
    public static void prepareTest() throws DBInitException {
        JDBCUnifiedArchiveRepositoryWithRecentsTest.loadSchema((String)PROJECT_ID, (String)VERSION, Collections.singleton(PROJECT_ID));
    }

    @Before
    public void setup() throws RepositoryException, InstantiationException, IllegalAccessException, TigaseStringprepException, InterruptedException, SQLException, ClassNotFoundException {
        this.repo = (UnifiedArchiveRepository)this.getDataSourceAware();
        this.owner = BareJID.bareJIDInstance((String)("owner-" + UUID.randomUUID().toString()), (String)"test.com");
        this.start = new Date();
        Thread.sleep(1000L);
        block7: for (int i = 0; i < 5; ++i) {
            JID buddy = JID.jidInstance((String)("chat-" + UUID.randomUUID().toString()), (String)"test.com", (String)"res-1");
            this.buddies.add(buddy);
            switch (i) {
                case 0: {
                    Element elem = this.createGroupchat(this.owner, buddy, MessageArchiveRepository.Direction.incoming, UUID.randomUUID().toString());
                    this.repo.archiveMessage(this.owner, buddy, MessageArchiveRepository.Direction.incoming, new Date(), elem, null);
                    Thread.sleep(1000L);
                    elem = this.createJingle(this.owner, buddy, MessageArchiveRepository.Direction.incoming, "session-initiate", null);
                    this.repo.archiveMessage(this.owner, buddy, MessageArchiveRepository.Direction.incoming, new Date(), elem, null);
                    Thread.sleep(1000L);
                    elem = this.createChat(this.owner, buddy, MessageArchiveRepository.Direction.outgoing, UUID.randomUUID().toString());
                    this.repo.archiveMessage(this.owner, buddy, MessageArchiveRepository.Direction.outgoing, new Date(), elem, null);
                    Thread.sleep(1000L);
                    continue block7;
                }
                case 1: {
                    Element elem = this.createGroupchat(this.owner, buddy, MessageArchiveRepository.Direction.incoming, UUID.randomUUID().toString());
                    this.repo.archiveMessage(this.owner, buddy, MessageArchiveRepository.Direction.incoming, new Date(), elem, null);
                    Thread.sleep(1000L);
                    elem = this.createChat(this.owner, buddy, MessageArchiveRepository.Direction.outgoing, UUID.randomUUID().toString());
                    this.repo.archiveMessage(this.owner, buddy, MessageArchiveRepository.Direction.outgoing, new Date(), elem, null);
                    Thread.sleep(1000L);
                    elem = this.createJingle(this.owner, buddy, MessageArchiveRepository.Direction.incoming, "session-terminate", "success");
                    this.repo.archiveMessage(this.owner, buddy, MessageArchiveRepository.Direction.incoming, new Date(), elem, null);
                    Thread.sleep(1000L);
                    elem = new Element("message", new String[]{"from", "to"}, new String[]{buddy.toString(), this.owner.toString()});
                    elem.addChild((XMLNodeIfc)new Element("x", new Element[]{new Element("invite", new String[]{"from"}, new String[]{buddy.toString()})}, new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"}));
                    elem.setAttribute("tigase-offline", "true");
                    elem.setAttribute("tigase-offline-only", "true");
                    this.repo.archiveMessage(this.owner, buddy, MessageArchiveRepository.Direction.incoming, new Date(), elem, null);
                    Thread.sleep(1000L);
                    continue block7;
                }
                case 2: {
                    Element elem = this.createChat(this.owner, buddy, MessageArchiveRepository.Direction.outgoing, UUID.randomUUID().toString());
                    this.repo.archiveMessage(this.owner, buddy, MessageArchiveRepository.Direction.outgoing, new Date(), elem, null);
                    Thread.sleep(1000L);
                    elem = this.createJingle(this.owner, buddy, MessageArchiveRepository.Direction.outgoing, "session-terminate", "cancel");
                    this.repo.archiveMessage(this.owner, buddy, MessageArchiveRepository.Direction.outgoing, new Date(), elem, null);
                    Thread.sleep(1000L);
                    continue block7;
                }
                case 3: {
                    Element elem = this.createGroupchat(this.owner, buddy, MessageArchiveRepository.Direction.incoming, UUID.randomUUID().toString());
                    this.repo.archiveMessage(this.owner, buddy, MessageArchiveRepository.Direction.incoming, new Date(), elem, null);
                    Thread.sleep(1000L);
                    elem = this.createJingle(this.owner, buddy, MessageArchiveRepository.Direction.incoming, "session-initiate", null);
                    elem.getChild("jingle").setAttribute("offline", "true");
                    elem.setAttribute("tigase-offline", "true");
                    this.repo.archiveMessage(this.owner, buddy, MessageArchiveRepository.Direction.incoming, new Date(), elem, null);
                    Thread.sleep(1000L);
                    continue block7;
                }
                case 4: {
                    Element elem = this.createChat(this.owner, buddy, MessageArchiveRepository.Direction.outgoing, UUID.randomUUID().toString());
                    this.repo.archiveMessage(this.owner, buddy, MessageArchiveRepository.Direction.outgoing, new Date(), elem, null);
                    Thread.sleep(1000L);
                    elem = this.createGroupchat(this.owner, buddy, MessageArchiveRepository.Direction.incoming, UUID.randomUUID().toString());
                    this.repo.archiveMessage(this.owner, buddy, MessageArchiveRepository.Direction.incoming, new Date(), elem, null);
                    Thread.sleep(1000L);
                    continue block7;
                }
            }
        }
    }

    @After
    public void tearDown() {
        this.buddies.forEach(buddy -> {
            try {
                this.repo.removeItems(this.owner, buddy.getBareJID().toString(), this.start, new Date());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        this.repo.destroy();
    }

    @Test
    public void testQueryRecentsAll() throws TigaseDBException {
        try {
            this.assertRecentsQueryAll(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    @Test
    public void testQueryRecentsAllSince() throws TigaseDBException {
        this.assertRecentsQueryAll(this.start);
    }

    @Test
    public void testQueryRecentsAllPaginated() throws TigaseDBException {
        RSM rsm = new RSM();
        rsm.setMax(2);
        List<Object> results = this.repo.queryRecents(this.owner, this.start, null, EnumSet.allOf(UnifiedArchiveRepository.Type.class), EnumSet.allOf(UnifiedArchiveRepository.CallCondition.class), rsm).collect(Collectors.toList());
        List<Object> expBuddies = this.buddies.stream().map(buddy -> buddy.getBareJID()).collect(Collectors.toList());
        Collections.reverse(expBuddies);
        expBuddies = expBuddies.subList(0, 2);
        this.assertItem(results, expBuddies, 0, "groupchat");
        this.assertItem(results, expBuddies, 1, "call", this::assertCallConditionMissed);
        rsm = new RSM();
        rsm.setMax(2);
        rsm.setIndex(Integer.valueOf(2));
        results = this.repo.queryRecents(this.owner, this.start, null, EnumSet.allOf(UnifiedArchiveRepository.Type.class), EnumSet.allOf(UnifiedArchiveRepository.CallCondition.class), rsm).collect(Collectors.toList());
        expBuddies = this.buddies.stream().map(buddy -> buddy.getBareJID()).collect(Collectors.toList());
        Collections.reverse(expBuddies);
        expBuddies = expBuddies.subList(2, 4);
        this.assertItem(results, expBuddies, 0, "call", this::assertCallConditionCancel);
        this.assertItem(results, expBuddies, 1, "call", this::assertCallConditionSuccess);
    }

    @Test
    public void testQueryRecentChats() throws TigaseDBException {
        List<UnifiedArchiveRepository.Item> results = this.repo.queryRecents(this.owner, this.start, null, EnumSet.of(UnifiedArchiveRepository.Type.chat), EnumSet.allOf(UnifiedArchiveRepository.CallCondition.class), new RSM()).collect(Collectors.toList());
        List<BareJID> expBuddies = this.buddies.stream().map(buddy -> buddy.getBareJID()).collect(Collectors.toList());
        expBuddies.remove(3);
        Collections.reverse(expBuddies);
        this.assertItem(results, expBuddies, 0, "chat");
        this.assertItem(results, expBuddies, 1, "chat");
        this.assertItem(results, expBuddies, 2, "chat");
        this.assertItem(results, expBuddies, 3, "chat");
    }

    @Test
    public void testQueryRecentGroupchats() throws TigaseDBException {
        List<UnifiedArchiveRepository.Item> results = this.repo.queryRecents(this.owner, this.start, null, EnumSet.of(UnifiedArchiveRepository.Type.groupchat), EnumSet.allOf(UnifiedArchiveRepository.CallCondition.class), new RSM()).collect(Collectors.toList());
        List<BareJID> expBuddies = this.buddies.stream().map(buddy -> buddy.getBareJID()).collect(Collectors.toList());
        expBuddies.remove(2);
        Collections.reverse(expBuddies);
        this.assertItem(results, expBuddies, 0, "groupchat");
        this.assertItem(results, expBuddies, 1, "groupchat");
        this.assertItem(results, expBuddies, 2, "groupchat");
        this.assertItem(results, expBuddies, 3, "groupchat");
    }

    @Test
    public void testQueryRecentCalls() throws TigaseDBException {
        List<UnifiedArchiveRepository.Item> results = this.repo.queryRecents(this.owner, this.start, null, EnumSet.of(UnifiedArchiveRepository.Type.call), EnumSet.allOf(UnifiedArchiveRepository.CallCondition.class), new RSM()).collect(Collectors.toList());
        List<BareJID> expBuddies = this.buddies.stream().map(buddy -> buddy.getBareJID()).collect(Collectors.toList());
        expBuddies.remove(4);
        Collections.reverse(expBuddies);
        this.assertItem(results, expBuddies, 0, "call", this::assertCallConditionMissed);
        this.assertItem(results, expBuddies, 1, "call", this::assertCallConditionCancel);
        this.assertItem(results, expBuddies, 2, "call", this::assertCallConditionSuccess);
        this.assertItem(results, expBuddies, 3, "call", this::assertCallConditionCancel);
    }

    @Test
    public void testQueryRecentCallsMissed() throws TigaseDBException {
        List<UnifiedArchiveRepository.Item> results = this.repo.queryRecents(this.owner, this.start, null, EnumSet.of(UnifiedArchiveRepository.Type.call), EnumSet.of(UnifiedArchiveRepository.CallCondition.missed), new RSM()).collect(Collectors.toList());
        List<BareJID> expBuddies = this.buddies.stream().map(buddy -> buddy.getBareJID()).collect(Collectors.toList());
        Collections.reverse(expBuddies);
        expBuddies = Arrays.asList((BareJID)expBuddies.get(1));
        this.assertItem(results, expBuddies, 0, "call", this::assertCallConditionMissed);
    }

    @Test
    public void testQueryRecentCallsSuccessAndMissed() throws TigaseDBException {
        List<UnifiedArchiveRepository.Item> results = this.repo.queryRecents(this.owner, this.start, null, EnumSet.of(UnifiedArchiveRepository.Type.call), EnumSet.of(UnifiedArchiveRepository.CallCondition.success, UnifiedArchiveRepository.CallCondition.missed), new RSM()).collect(Collectors.toList());
        List<BareJID> expBuddies = this.buddies.stream().map(buddy -> buddy.getBareJID()).collect(Collectors.toList());
        Collections.reverse(expBuddies);
        expBuddies = Arrays.asList((BareJID)expBuddies.get(1), (BareJID)expBuddies.get(3));
        this.assertItem(results, expBuddies, 0, "call", this::assertCallConditionMissed);
        this.assertItem(results, expBuddies, 1, "call", this::assertCallConditionSuccess);
    }

    protected Class<? extends DataSourceAware> getDataSourceAwareIfc() {
        return UnifiedArchiveRepository.class;
    }

    private void assertRecentsQueryAll(Date start) throws TigaseDBException {
        List<UnifiedArchiveRepository.Item> results = this.repo.queryRecents(this.owner, start, null, EnumSet.allOf(UnifiedArchiveRepository.Type.class), EnumSet.allOf(UnifiedArchiveRepository.CallCondition.class), new RSM()).collect(Collectors.toList());
        List<BareJID> expBuddies = this.buddies.stream().map(buddy -> buddy.getBareJID()).collect(Collectors.toList());
        Collections.reverse(expBuddies);
        this.assertItem(results, expBuddies, 0, "groupchat");
        this.assertItem(results, expBuddies, 1, "call", this::assertCallConditionMissed);
        this.assertItem(results, expBuddies, 2, "call", this::assertCallConditionCancel);
        this.assertItem(results, expBuddies, 3, "call", this::assertCallConditionSuccess);
        this.assertItem(results, expBuddies, 4, "chat");
    }

    private void assertItem(List<UnifiedArchiveRepository.Item> results, List<BareJID> expBuddies, int pos, String itemType) {
        this.assertItem(results, expBuddies, pos, itemType, null);
    }

    private void assertItem(List<UnifiedArchiveRepository.Item> results, List<BareJID> expBuddies, int pos, String itemType, Predicate<UnifiedArchiveRepository.Item> itemPredicate) {
        UnifiedArchiveRepository.Item item = results.get(pos);
        Assert.assertEquals((Object)expBuddies.get(pos).toString(), (Object)item.getWith());
        Assert.assertEquals((Object)itemType, (Object)item.getItemType());
        if (itemPredicate != null) {
            Assert.assertTrue((boolean)itemPredicate.test(item));
        }
    }

    private boolean assertCallConditionSuccess(UnifiedArchiveRepository.Item item) {
        Element jingle = item.getMessage().getChild("jingle");
        String action = jingle.getAttributeStaticStr("action");
        Assert.assertTrue(("session-accept".equals(action) || "session-terminate".equals(action) ? 1 : 0) != 0);
        Element reason = jingle.getChild("reason");
        Assert.assertTrue((reason == null || reason.getChild("cancel") == null ? 1 : 0) != 0);
        return true;
    }

    private boolean assertCallConditionCancel(UnifiedArchiveRepository.Item item) {
        Element jingle = item.getMessage().getChild("jingle");
        String action = jingle.getAttributeStaticStr("action");
        if ("session-initiate".equals(action)) {
            Assert.assertTrue((jingle.getAttributeStaticStr("offline") == null ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((Object)"session-terminate", (Object)action);
            Element reason = jingle.getChild("reason");
            Assert.assertTrue((reason != null && reason.getChild("cancel") != null ? 1 : 0) != 0);
        }
        return true;
    }

    private boolean assertCallConditionMissed(UnifiedArchiveRepository.Item item) {
        Element jingle = item.getMessage().getChild("jingle");
        String action = jingle.getAttributeStaticStr("action");
        Assert.assertEquals((Object)"session-initiate", (Object)action);
        Assert.assertTrue((jingle.getAttributeStaticStr("offline") != null ? 1 : 0) != 0);
        return true;
    }

    private Element createJingle(BareJID owner, JID buddy, MessageArchiveRepository.Direction direction, String action, String reason) {
        String[] stringArray;
        String[] stringArray2 = new String[]{"from", "to"};
        if (direction == MessageArchiveRepository.Direction.incoming) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = buddy.toString();
            stringArray = stringArray3;
            stringArray3[1] = owner.toString();
        } else {
            String[] stringArray4 = new String[2];
            stringArray4[0] = owner.toString();
            stringArray = stringArray4;
            stringArray4[1] = buddy.toString();
        }
        Element iq = new Element("iq", stringArray2, stringArray);
        iq.setAttribute("id", UUID.randomUUID().toString());
        iq.setAttribute("item-type", "call");
        Element jingle = new Element("jingle", new String[]{"sid", "action"}, new String[]{UUID.randomUUID().toString(), action});
        if (reason != null) {
            Element reasonEl = new Element("reason");
            reasonEl.addChild((XMLNodeIfc)new Element(reason));
            jingle.addChild((XMLNodeIfc)reasonEl);
        }
        iq.addChild((XMLNodeIfc)jingle);
        return iq;
    }

    private Element createChat(BareJID owner, JID buddy, MessageArchiveRepository.Direction direction, String body) {
        String[] stringArray;
        String[] stringArray2 = new String[]{"from", "to"};
        if (direction == MessageArchiveRepository.Direction.incoming) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = buddy.toString();
            stringArray = stringArray3;
            stringArray3[1] = owner.toString();
        } else {
            String[] stringArray4 = new String[2];
            stringArray4[0] = owner.toString();
            stringArray = stringArray4;
            stringArray4[1] = buddy.toString();
        }
        Element message = new Element("message", stringArray2, stringArray);
        message.addChild((XMLNodeIfc)new Element("body", body));
        return message;
    }

    private Element createGroupchat(BareJID owner, JID buddy, MessageArchiveRepository.Direction direction, String body) {
        String[] stringArray;
        String[] stringArray2 = new String[]{"from", "to"};
        if (direction == MessageArchiveRepository.Direction.incoming) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = buddy.toString();
            stringArray = stringArray3;
            stringArray3[1] = owner.toString();
        } else {
            String[] stringArray4 = new String[2];
            stringArray4[0] = owner.toString();
            stringArray = stringArray4;
            stringArray4[1] = buddy.toString();
        }
        Element message = new Element("message", stringArray2, stringArray);
        message.setAttribute("type", "groupchat");
        message.addChild((XMLNodeIfc)new Element("body", body));
        return message;
    }
}

