/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.db;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.MethodSorters;
import org.junit.runners.model.Statement;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.unified.QueryCriteria;
import tigase.archive.unified.db.UnifiedArchiveRepository;
import tigase.archive.xep0136.Query;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.AbstractDataSourceAwareTestCase;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataSourceAware;
import tigase.db.TigaseDBException;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class JDBCUnifiedArchiveRepositoryTest
extends AbstractDataSourceAwareTestCase<DataRepository, UnifiedArchiveRepository> {
    private static final SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final String PROJECT_ID = "unified-archive";
    private static final String VERSION = "2.0.0";
    protected static String emoji = "\ud83d\ude97\ud83d\udca9\ud83d\ude21";
    private static JID buddy = null;
    private static JID owner = null;
    private static Date testStart = null;
    @ClassRule
    public static TestRule rule = new TestRule(){

        public Statement apply(Statement stmnt, Description d) {
            if (uri == null || !uri.startsWith("jdbc:")) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        Assume.assumeTrue((String)"Ignored due to not passed DB URI!", (boolean)false);
                    }
                };
            }
            return stmnt;
        }
    };
    protected boolean checkEmoji = true;
    private UnifiedArchiveRepository<DataRepository> repo;

    @BeforeClass
    public static void prepareTest() throws DBInitException {
        JDBCUnifiedArchiveRepositoryTest.loadSchema((String)PROJECT_ID, (String)VERSION, Collections.singleton(PROJECT_ID));
        owner = JID.jidInstanceNS((String)("ua-" + UUID.randomUUID()), (String)"test", (String)"tigase-1");
        buddy = JID.jidInstanceNS((String)("ua-" + UUID.randomUUID()), (String)"test", (String)"tigase-2");
    }

    @Before
    public void setup() throws RepositoryException, InstantiationException, IllegalAccessException, SQLException, ClassNotFoundException {
        this.repo = (UnifiedArchiveRepository)this.getDataSourceAware();
        if (uri.startsWith("jdbc:derby:") || uri.startsWith("jdbc:jtds:sqlserver") || uri.startsWith("jdbc:sqlserver")) {
            this.checkEmoji = false;
        }
    }

    protected Class<? extends DataSourceAware> getDataSourceAwareIfc() {
        return UnifiedArchiveRepository.class;
    }

    @Test
    public void test1_archiveMessage1() throws RepositoryException, ComponentException {
        Date date;
        if (uri == null) {
            return;
        }
        testStart = date = new Date();
        String body = "Test 1";
        if (this.checkEmoji) {
            body = body + emoji;
        }
        Element msg = new Element("message", new String[]{"from", "to", "type"}, new String[]{owner.toString(), buddy.toString(), StanzaType.chat.name()});
        msg.addChild((XMLNodeIfc)new Element("body", body));
        this.repo.archiveMessage(owner.getBareJID(), buddy, MessageArchiveRepository.Direction.outgoing, date, msg, null);
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setWith(JID.jidInstance((BareJID)buddy.getBareJID()));
        crit.setStart(date);
        crit.getRsm().setMax(1);
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (query, item) -> msgs.add((UnifiedArchiveRepository.Item)item));
        Assert.assertEquals((String)"Incorrect number of message", (long)1L, (long)msgs.size());
        UnifiedArchiveRepository.Item res = (UnifiedArchiveRepository.Item)msgs.get(0);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.outgoing, (Object)res.getDirection());
        Assert.assertEquals((String)"Incorrect message body", (Object)body, (Object)res.getMessage().getChildCData("message/body"));
    }

    @Test
    public void test2_archiveMessage2withTags() throws InterruptedException, RepositoryException, ComponentException {
        Thread.sleep(2000L);
        Date date = new Date();
        String body = "Test 2 with #Test123";
        if (this.checkEmoji) {
            body = body + emoji;
        }
        Element msg = new Element("message", new String[]{"from", "to", "type"}, new String[]{owner.toString(), buddy.toString(), StanzaType.chat.name()});
        msg.addChild((XMLNodeIfc)new Element("body", body));
        HashSet<String> tags = new HashSet<String>();
        if (this.checkEmoji) {
            tags.add("#Test123" + emoji);
        } else {
            tags.add("#Test123");
        }
        this.repo.archiveMessage(owner.getBareJID(), buddy, MessageArchiveRepository.Direction.incoming, date, msg, tags);
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setWith(JID.jidInstance((BareJID)buddy.getBareJID()));
        crit.setStart(date);
        crit.getRsm().setMax(1);
        ArrayList items = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (query, item) -> items.add((UnifiedArchiveRepository.Item)item));
        Assert.assertEquals((String)"Incorrect number of message", (long)1L, (long)items.size());
        UnifiedArchiveRepository.Item res = (UnifiedArchiveRepository.Item)items.get(0);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.incoming, (Object)res.getDirection());
        Assert.assertEquals((String)"Incorrect message body", (Object)body, (Object)res.getMessage().getChildCData("message/body"));
    }

    @Test
    public void test3_getCollections() throws TigaseDBException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setWith(JID.jidInstance((BareJID)buddy.getBareJID()));
        crit.setStart(testStart);
        ArrayList chats = new ArrayList();
        this.repo.queryCollections((Query)crit, (query, with, start, type) -> chats.add(new ColItem(with, start, type)));
        Assert.assertEquals((String)"Incorrect number of collections", (long)1L, (long)chats.size());
        ColItem chat = (ColItem)chats.get(0);
        Assert.assertEquals((String)"Incorrect buddy", (Object)buddy.getBareJID().toString(), (Object)chat.with);
        Assert.assertEquals((String)"Incorrect timestamp", (long)(testStart.getTime() / 1000L), (long)(chat.start.getTime() / 1000L));
    }

    @Test
    public void test3_getCollectionsByTag() throws TigaseDBException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setWith(JID.jidInstance((BareJID)buddy.getBareJID()));
        crit.setStart(testStart);
        if (this.checkEmoji) {
            crit.addTag("#Test123" + emoji);
        } else {
            crit.addTag("#Test123");
        }
        ArrayList chats = new ArrayList();
        this.repo.queryCollections((Query)crit, (query, with, start, type) -> chats.add(new ColItem(with, start, type)));
        Assert.assertEquals((String)"Incorrect number of collections", (long)1L, (long)chats.size());
        ColItem chat = (ColItem)chats.get(0);
        Assert.assertEquals((String)"Incorrect buddy", (Object)buddy.getBareJID().toString(), (Object)chat.with);
    }

    @Test
    public void test4_getItems() throws InterruptedException, RepositoryException, ComponentException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setWith(JID.jidInstance((BareJID)buddy.getBareJID()));
        crit.setStart(testStart);
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (query, item) -> msgs.add((UnifiedArchiveRepository.Item)item));
        Assert.assertEquals((String)"Incorrect number of message", (long)2L, (long)msgs.size());
        UnifiedArchiveRepository.Item res = (UnifiedArchiveRepository.Item)msgs.get(0);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.outgoing, (Object)res.getDirection());
        Assert.assertEquals((String)"Incorrect message body", (Object)("Test 1" + (this.checkEmoji ? emoji : "")), (Object)res.getMessage().getChildCData("message/body"));
        res = (UnifiedArchiveRepository.Item)msgs.get(1);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.incoming, (Object)res.getDirection());
        Assert.assertEquals((String)"Incorrect message body", (Object)("Test 2 with #Test123" + (this.checkEmoji ? emoji : "")), (Object)res.getMessage().getChildCData("message/body"));
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setWith(JID.jidInstance((BareJID)buddy.getBareJID()));
        crit.setStart(testStart);
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (query, item) -> msgs.add((UnifiedArchiveRepository.Item)item));
        Assert.assertTrue((String)"Incorrect number of message", (msgs.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void test4_getItemsWithTag() throws InterruptedException, RepositoryException, ComponentException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setWith(JID.jidInstance((BareJID)buddy.getBareJID()));
        crit.setStart(testStart);
        if (this.checkEmoji) {
            crit.addTag("#Test123" + emoji);
        } else {
            crit.addTag("#Test123");
        }
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (query, item) -> msgs.add((UnifiedArchiveRepository.Item)item));
        Assert.assertEquals((String)"Incorrect number of message", (long)1L, (long)msgs.size());
        UnifiedArchiveRepository.Item res = (UnifiedArchiveRepository.Item)msgs.get(0);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.incoming, (Object)res.getDirection());
        Assert.assertEquals((String)"Incorrect message body", (Object)("Test 2 with #Test123" + (this.checkEmoji ? emoji : "")), (Object)res.getMessage().getChildCData("message/body"));
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setStart(testStart);
        if (this.checkEmoji) {
            crit.addTag("#Test123" + emoji);
        } else {
            crit.addTag("#Test123");
        }
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (query, item) -> msgs.add((UnifiedArchiveRepository.Item)item));
        Assert.assertTrue((String)"Incorrect number of message", (msgs.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void test5_getCollectionsContains() throws TigaseDBException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setWith(JID.jidInstance((BareJID)buddy.getBareJID()));
        crit.setStart(testStart);
        crit.addContains("Test 1");
        ArrayList chats = new ArrayList();
        this.repo.queryCollections((Query)crit, (query, with, start, type) -> chats.add(new ColItem(with, start, type)));
        Assert.assertEquals((String)"Incorrect number of collections", (long)1L, (long)chats.size());
        ColItem chat = (ColItem)chats.get(0);
        Assert.assertEquals((String)"Incorrect buddy", (Object)buddy.getBareJID().toString(), (Object)chat.with);
        Assert.assertEquals((String)"Incorrect timestamp", (long)(testStart.getTime() / 1000L), (long)(chat.start.getTime() / 1000L));
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setWith(JID.jidInstance((BareJID)buddy.getBareJID()));
        crit.setStart(testStart);
        crit.addContains("Test 123");
        chats.clear();
        this.repo.queryCollections((Query)crit, (query, with, start, type) -> chats.add(new ColItem(with, start, type)));
        Assert.assertEquals((String)"Incorrect number of collections", (long)0L, (long)chats.size());
    }

    @Test
    public void test6_getItems() throws InterruptedException, RepositoryException, ComponentException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setWith(JID.jidInstance((BareJID)buddy.getBareJID()));
        crit.setStart(testStart);
        crit.addContains("Test 1");
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (query, item) -> msgs.add((UnifiedArchiveRepository.Item)item));
        Assert.assertEquals((String)"Incorrect number of message", (long)1L, (long)msgs.size());
        UnifiedArchiveRepository.Item res = (UnifiedArchiveRepository.Item)msgs.get(0);
        Assert.assertEquals((String)"Incorrect direction", (Object)MessageArchiveRepository.Direction.outgoing, (Object)res.getDirection());
        Assert.assertEquals((String)"Incorrect message body", (Object)("Test 1" + (this.checkEmoji ? emoji : "")), (Object)res.getMessage().getChildCData("message/body"));
    }

    @Test
    public void test7_removeItems() throws RepositoryException, ComponentException {
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setWith(JID.jidInstance((BareJID)buddy.getBareJID()));
        crit.setStart(testStart);
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (query, item) -> msgs.add((UnifiedArchiveRepository.Item)item));
        Assert.assertNotEquals((String)"No messages in repository to execute test - we should have some already", (long)0L, (long)msgs.size());
        this.repo.removeItems(owner.getBareJID(), buddy.getBareJID().toString(), testStart, new Date());
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (query, item) -> msgs.add((UnifiedArchiveRepository.Item)item));
        Assert.assertEquals((String)"Still some messages, while in this duration all should be deleted", (long)0L, (long)msgs.size());
    }

    @Test
    public void test8_removeExpiredItems() throws RepositoryException, TigaseStringprepException, ComponentException {
        Date date = new Date();
        String uuid = UUID.randomUUID().toString();
        testStart = date;
        String body = "Test 1 " + uuid;
        if (this.checkEmoji) {
            body = body + emoji;
        }
        Element msg = new Element("message", new String[]{"from", "to", "type"}, new String[]{owner.toString(), buddy.toString(), StanzaType.chat.name()});
        msg.addChild((XMLNodeIfc)new Element("body", body));
        Element delay = new Element("delay");
        LocalDateTime time = LocalDateTime.now().minusDays(1L).minusHours(1L);
        Date originalTime = new Date(time.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        delay.setAttribute("stamp", formatter2.format(originalTime));
        msg.addChild((XMLNodeIfc)delay);
        this.repo.archiveMessage(owner.getBareJID(), buddy, MessageArchiveRepository.Direction.outgoing, originalTime, msg, null);
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setWith(JID.jidInstance((BareJID)buddy.getBareJID()));
        crit.addContains(uuid);
        crit.getRsm().setMax(1);
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (query, item) -> msgs.add((UnifiedArchiveRepository.Item)item));
        Assert.assertEquals((String)"Incorrect number of messages", (long)1L, (long)msgs.size());
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setWith(JID.jidInstance((BareJID)buddy.getBareJID()));
        crit.setStart(date);
        crit.addContains(uuid);
        crit.getRsm().setMax(1);
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (query, item) -> msgs.add((UnifiedArchiveRepository.Item)item));
        Assert.assertEquals((String)"Incorrect number of messages", (long)0L, (long)msgs.size());
        LocalDateTime before = LocalDateTime.now().minusDays(1L);
        this.repo.deleteExpiredMessages(BareJID.bareJIDInstance((String)owner.getDomain()), before);
        crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setWith(JID.jidInstance((BareJID)buddy.getBareJID()));
        crit.addContains(uuid);
        crit.getRsm().setMax(1);
        msgs.clear();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (query, item) -> msgs.add((UnifiedArchiveRepository.Item)item));
        Assert.assertEquals((String)"Incorrect number of messages", (long)0L, (long)msgs.size());
    }

    @Test
    public void testOfflineMessagesExcludedFromArchive() throws ComponentException, RepositoryException {
        Element elem = new Element("message", new String[]{"from", "to"}, new String[]{buddy.toString(), owner.toString()});
        elem.addChild((XMLNodeIfc)new Element("x", new Element[]{new Element("invite", new String[]{"from"}, new String[]{buddy.toString()})}, new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"}));
        elem.setAttribute("tigase-offline", "true");
        elem.setAttribute("tigase-offline-only", "true");
        this.repo.archiveMessage(owner.getBareJID(), buddy, MessageArchiveRepository.Direction.incoming, new Date(), elem, null);
        QueryCriteria crit = (QueryCriteria)this.repo.newQuery();
        crit.setQuestionerJID(owner);
        crit.setWith(JID.jidInstance((BareJID)buddy.getBareJID()));
        ArrayList msgs = new ArrayList();
        this.repo.queryItems((tigase.xmpp.mam.Query)crit, (query, item) -> msgs.add((UnifiedArchiveRepository.Item)item));
        Assert.assertEquals((String)"Messages which should not be availble, are available!", (long)0L, (long)msgs.size());
    }

    static {
        formatter2.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    class ColItem {
        Date start;
        String type;
        String with;

        public ColItem(String with, Date start, String type) {
            this.with = with;
            this.start = start;
            this.type = type;
        }
    }
}

