/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.db;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.AbstractCriteria;
import tigase.archive.db.JDBCMessageArchiveRepository;
import tigase.archive.db.MessageArchiveRepository;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class JDBCUnifiedArchiveRepository
extends JDBCMessageArchiveRepository {
    private static final Logger a = Logger.getLogger(JDBCUnifiedArchiveRepository.class.getCanonicalName());
    protected static final String MSGS_ITEM_TYPE = "item_type";
    protected static final String MSGS_OFFLINE = "offline";
    protected static final String OFFLINE_STORE_KEY = "offline-store";
    private String[] b;
    private String[][] c;
    private boolean d = false;

    public void initRepository(String conn_str, Map<String, String> params) throws DBInitException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(super.getCollectionsCombinations()));
        for (String string2 : super.getCollectionsCombinations()) {
            if (string2.isEmpty()) {
                arrayList.add("ITEMTYPE");
                continue;
            }
            arrayList.add("ITEMTYPE_" + string2);
        }
        this.b = (String[])arrayList.stream().map(string -> {
            if (string.isEmpty()) {
                return "WITHOUTOFFLINEONLY";
            }
            return "WITHOUTOFFLINEONLY_" + string;
        }).toArray(String[]::new);
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(Arrays.asList(super.getCollectionsWheres()));
        arrayList2.add(new String[]{"ITEMTYPE", " and m.item_type = ? "});
        arrayList2.add(new String[]{"WITHOUTOFFLINEONLY", " and m.offline <> 2 "});
        this.c = (String[][])arrayList2.toArray((T[])new String[0][]);
        if (params.containsKey(OFFLINE_STORE_KEY)) {
            this.d = Boolean.parseBoolean(params.get(OFFLINE_STORE_KEY));
        }
        super.initRepository(conn_str, params);
    }

    protected String[] getCollectionsCombinations() {
        return this.b;
    }

    protected String[][] getCollectionsWheres() {
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initRepositoryDbSchema() throws SQLException {
        String string;
        super.initRepositoryDbSchema();
        Statement statement = null;
        try {
            statement = this.data_repo.createStatement(null);
            statement.executeQuery("select item_type from tig_ma_msgs where owner_id = 0");
        }
        catch (SQLException sQLException) {
            string = null;
            try {
                string = "alter table tig_ma_msgs add item_type varchar(50)";
                statement.execute(string);
                string = "create index tig_ma_msgs_owner_id_item_type_index on tig_ma_msgs (owner_id, item_type)";
                statement.execute(string);
                string = "update tig_ma_msgs set item_type = 'chat' where item_type is null";
                statement.execute(string);
            }
            catch (SQLException sQLException2) {
                a.log(Level.SEVERE, "could not alter table tig_ma_msgs to add missing column by SQL:\n" + string, sQLException2);
            }
        }
        finally {
            this.data_repo.release(statement, null);
        }
        try {
            statement = this.data_repo.createStatement(null);
            statement.executeQuery("select offline from tig_ma_msgs where owner_id = 0");
        }
        catch (SQLException sQLException) {
            string = "alter table tig_ma_msgs add offline smallint";
            try {
                statement.execute(string);
                string = "create index tig_ma_msgs_owner_id_offline_index on tig_ma_msgs (owner_id,offline)";
                statement.execute(string);
            }
            catch (SQLException sQLException3) {
                a.log(Level.SEVERE, "could not alter table tig_ma_msgs to add missing column by SQL:\n" + string, sQLException3);
            }
        }
        finally {
            this.data_repo.release(statement, null);
        }
    }

    protected void initPreparedStatements(Map<String, String> params) throws SQLException {
        String string = this.ADD_MESSAGE;
        string = string.replaceAll("\\)\\s+select", ", item_type, offline\\) select ");
        switch (this.data_repo.getDatabaseType()) {
            case mysql: {
                string = string.replaceAll(",\\s+stanza_hash\\)", ", stanza_hash, item_type, offline\\)");
                string = string.replaceAll("\\)\\s+on\\s+duplicate", ",?,?\\) on duplicate");
                break;
            }
            case postgresql: {
                string = string.replaceAll("\\?\\s+where", "\\?, \\?, \\? where");
                break;
            }
            default: {
                string = string.replaceAll("\\s+from \\(select \\?", ", tmp.item_type, tmp.offline from \\(select \\?");
                string = string.replaceAll("\\) as tmp", ", \\? as item_type, \\? as offline\\) as tmp");
            }
        }
        if (a.isLoggable(Level.CONFIG)) {
            a.log(Level.CONFIG, "modified ADD_MESSAGE query from = " + this.ADD_MESSAGE + " to = " + string);
        }
        this.ADD_MESSAGE = string;
        super.initPreparedStatements(params);
    }

    public void archiveMessage(BareJID owner, JID buddy, MessageArchiveRepository.Direction direction, Date timestamp, Element msg, Set<String> tags) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = msg.getAttributeStaticStr("item-type");
        if (string == null) {
            string = msg.getName() == "presence" ? "presence" : "chat";
        }
        msg.removeAttribute("item-type");
        hashMap.put("item-type", string);
        if ("call".equals(string)) {
            msg.setName("iq");
        }
        boolean bl = false;
        String string2 = msg.getAttributeStaticStr("tigase-offline");
        if (string2 != null) {
            bl = Boolean.parseBoolean(string2);
        }
        msg.removeAttribute("tigase-offline");
        hashMap.put("tigase-offline", bl);
        boolean bl2 = false;
        String string3 = msg.getAttributeStaticStr("tigase-offline-only");
        if (string3 != null) {
            bl2 = Boolean.parseBoolean(string3);
        }
        msg.removeAttribute("tigase-offline-only");
        hashMap.put("tigase-offline-only", bl2);
        this.archiveMessage(owner, buddy, direction, timestamp, msg, tags, hashMap);
    }

    protected int addMessageAdditionalInfo(PreparedStatement stmt, int i, Map<String, Object> additionalData) throws SQLException {
        stmt.setString(i++, (String)additionalData.get("item-type"));
        if (((Boolean)additionalData.get("tigase-offline")).booleanValue()) {
            stmt.setShort(i++, (short)((Boolean)additionalData.get("tigase-offline-only") != false ? 2 : 1));
        } else {
            stmt.setShort(i++, (short)0);
        }
        return i;
    }

    public AbstractCriteria newCriteriaInstance() {
        return new Criteria();
    }

    protected Item newItemInstance() {
        return new Item();
    }

    protected List<String> getMessageFields(String combination) {
        List list = super.getMessageFields(combination);
        if (!combination.contains("ITEMTYPE")) {
            list.add(MSGS_ITEM_TYPE);
        }
        return list;
    }

    protected Element addCollectionToResults(List<Element> results, JDBCMessageArchiveRepository.Criteria criteria_, String with, Date start, String type) {
        Criteria criteria = (Criteria)criteria_;
        Element element = super.addCollectionToResults(results, (AbstractCriteria)criteria, with, start, type);
        if (!criteria.forItemType("chat")) {
            element.setName("events");
        }
        return element;
    }

    protected Element addMessageToResults(List<Element> msgs, JDBCMessageArchiveRepository.Criteria crit, Date startTimestamp, JDBCMessageArchiveRepository.Item item_, Element msg) {
        Item item = (Item)item_;
        Element element = super.addMessageToResults(msgs, crit, startTimestamp, (JDBCMessageArchiveRepository.Item)item, msg);
        if (item.a != null) {
            element.setAttribute("item-type", item.a);
        }
        return element;
    }

    protected DataRepository getDataRepository() {
        return this.data_repo;
    }

    protected byte[] generateHashOfMessage(MessageArchiveRepository.Direction direction, Element msg, Date ts, Map<String, Object> additionalData) {
        try {
            String string;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            String string2 = string = direction == MessageArchiveRepository.Direction.incoming ? msg.getAttributeStaticStr("from") : msg.getAttributeStaticStr("to");
            if (string != null) {
                messageDigest.update(string.getBytes());
            }
            String string3 = msg.getAttributeStaticStr("type");
            Element element = msg.getChild("subject");
            String string4 = msg.getChildCData(MSG_SUBJECT_PATH);
            String string5 = msg.getAttributeStaticStr("id");
            if (string5 != null) {
                if (!"groupchat".equals(string3) || element == null) {
                    messageDigest.update(string5.getBytes());
                } else {
                    messageDigest.update(":".getBytes());
                    messageDigest.update(new Long(ts.getTime() / 60000L).toString().getBytes());
                    if (string4 != null) {
                        messageDigest.update(string4.getBytes());
                    }
                    messageDigest.update(":".getBytes());
                }
            }
            if (string3 == null || !"groupchat".equals(string3)) {
                messageDigest.update(":".getBytes());
                messageDigest.update(new Long(ts.getTime() / 1000L).toString().getBytes());
            }
            messageDigest.update(":".getBytes());
            messageDigest.update(((String)additionalData.get("item-type")).getBytes());
            messageDigest.update(":".getBytes());
            String string6 = msg.getChildCData(MSG_BODY_PATH);
            if (string6 != null) {
                messageDigest.update(string6.getBytes());
            }
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static class Criteria
    extends JDBCMessageArchiveRepository.Criteria {
        private static final String a = "any";
        private String b = null;

        public AbstractCriteria fromElement(Element el, boolean tagsSupport) throws IllegalArgumentException, ParseException {
            super.fromElement(el, tagsSupport);
            this.setItemType(el.getAttributeStaticStr("item-type"));
            return this;
        }

        public String updateQueryName() {
            this.queryName = super.updateQueryName();
            if (this.b != null) {
                this.queryName = this.queryName.isEmpty() ? "ITEMTYPE" : "ITEMTYPE_" + this.queryName;
            }
            this.queryName = this.queryName.isEmpty() ? "WITHOUTOFFLINEONLY" : "WITHOUTOFFLINEONLY_" + this.queryName;
            return this.queryName;
        }

        public int setCountQueryParams(PreparedStatement stmt, DataRepository.dbTypes dbType, int i) throws SQLException {
            if (this.b != null) {
                stmt.setString(i++, this.b);
            }
            return super.setCountQueryParams(stmt, dbType, i);
        }

        public boolean hasItemType() {
            return this.b != null;
        }

        public boolean forItemType(String type) {
            return type.equals(this.b);
        }

        public void setItemType(String type) {
            this.b = type;
            if (this.b == null) {
                this.b = "chat";
            } else if (a.equals(this.b)) {
                this.b = null;
            }
        }

        public void prepareResult(Element retList) {
            super.prepareResult(retList);
            if (!this.forItemType("chat")) {
                if ("chat".equals(retList.getName())) {
                    retList.setName("events");
                }
                retList.setAttribute("item-type", this.b == null ? a : this.b);
            }
        }
    }

    protected static class Item
    extends JDBCMessageArchiveRepository.Item<Criteria> {
        private String a = null;

        protected Item() {
        }

        protected int read(ResultSet rs, Criteria crit, boolean containsWith) throws SQLException {
            int n = super.read(rs, (JDBCMessageArchiveRepository.Criteria)crit, containsWith);
            if (!crit.hasItemType()) {
                this.a = rs.getString(n++);
            }
            return n;
        }
    }
}

