-- QUERY START:
drop procedure if exists TigExecuteIfNot;
-- QUERY END:

-- QUERY START:
drop procedure if exists TigAddColumnIfNotExists;
-- QUERY END:

delimiter //

-- QUERY START:
create procedure TigExecuteIfNot(cond int, query text)
begin
set @s = (select if (
        cond > 0,
'select 1',
query
));
prepare stmt from @s;
execute stmt;
deallocate prepare stmt;
end //
-- QUERY END:

-- QUERY START:
create procedure TigAddColumnIfNotExists(tab varchar(255), col varchar(255), def varchar(255))
begin
call TigExecuteIfNot((select count(1) from information_schema.COLUMNS where TABLE_SCHEMA = DATABASE() AND TABLE_NAME = tab AND COLUMN_NAME = col),
        CONCAT('alter table ', tab, ' add `', col, '` ', def)
);
end //
-- QUERY END:

delimiter ;

-- QUERY START:
call TigAddColumnIfNotExists('tig_ma_msgs',  'jingle_sid', 'varchar(128)');
-- QUERY END:
-- QUERY START:
call TigAddColumnIfNotExists('tig_ma_msgs',  'jingle_reason', 'varchar(50)');
-- QUERY END:
-- QUERY START:
call TigAddColumnIfNotExists('tig_ma_msgs',  'jingle_action', 'varchar(50)');
-- QUERY END:
-- QUERY START:
call TigAddColumnIfNotExists('tig_ma_msgs',  'jingle_offline', 'smallint default 0');
-- QUERY END: