/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.db;

import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.unified.UnifiedArchiveRepositoryWithTigaseQuery;
import tigase.archive.unified.db.JDBCUnifiedArchiveRepository;
import tigase.db.DataRepository;
import tigase.db.TigaseDBException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.RSM;

public class JDBCUnifiedArchiveRepositoryWithRecents
extends JDBCUnifiedArchiveRepository
implements UnifiedArchiveRepositoryWithTigaseQuery {
    private static final Logger a = Logger.getLogger(JDBCUnifiedArchiveRepositoryWithRecents.class.getCanonicalName());
    private static final String b = "jingle_sid";
    private static final String c = "jingle_reason";
    private static final String d = "jingle_action";
    private static final String e = "jingle_offline";
    private String f;
    private String g;

    @Override
    protected void initPreparedStatements(Map<String, String> params) throws SQLException {
        String string = this.ADD_MESSAGE;
        string = string.replaceAll("\\)\\s+select", ", jingle_sid, jingle_action, jingle_reason, jingle_offline\\) select ");
        switch (this.data_repo.getDatabaseType()) {
            case mysql: {
                string = string.replaceAll(",\\s+stanza_hash\\)", ", stanza_hash, jingle_sid, jingle_action, jingle_reason, jingle_offline, item_type, offline\\)");
                string = string.replaceAll("\\)\\s+on\\s+duplicate", ",?,?,?,?\\) on duplicate");
                break;
            }
            case postgresql: {
                string = string.replaceAll("\\?\\s+where", "\\?, \\?, \\?, \\?, \\? where");
                break;
            }
            default: {
                string = string.replaceAll("\\s+from \\(select \\?", ", tmp.jingle_sid, tmp.jingle_action, tmp.jingle_reason, tmp.jingle_offline from \\(select \\?");
                string = string.replaceAll("\\) as tmp", ", \\? as jingle_sid, \\? as jingle_action, \\? as jingle_reason, \\? as jingle_offline\\) as tmp");
            }
        }
        if (a.isLoggable(Level.CONFIG)) {
            a.log(Level.CONFIG, "modified ADD_MESSAGE query from = " + this.ADD_MESSAGE + " to = " + string);
        }
        this.ADD_MESSAGE = string;
        super.initPreparedStatements(params);
        DataRepository.dbTypes dbTypes2 = this.getDataRepository().getDatabaseType();
        this.g = this.a(dbTypes2, "query-recent");
        this.f = this.a(dbTypes2, "query-recent-count");
        this.getDataRepository().initPreparedStatement(this.g, this.g);
        this.getDataRepository().initPreparedStatement(this.f, this.f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initRepositoryDbSchema() throws SQLException {
        super.initRepositoryDbSchema();
        DataRepository.dbTypes dbTypes2 = this.getDataRepository().getDatabaseType();
        String string = this.a(dbTypes2, "recent-schema");
        Statement statement = null;
        try {
            statement = this.data_repo.createStatement(null);
            StringBuilder stringBuilder = null;
            for (String string2 : string.split("\n")) {
                if (string2.startsWith("-- QUERY START:")) {
                    stringBuilder = new StringBuilder();
                    continue;
                }
                if (string2.startsWith("-- QUERY END:")) {
                    String string3 = stringBuilder.toString().trim();
                    if (string3.endsWith(";")) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    if (string3.endsWith("//")) {
                        string3 = string3.substring(0, string3.length() - 2);
                    }
                    stringBuilder = null;
                    System.out.println("executing query: " + string3);
                    statement.execute(string3);
                    continue;
                }
                if (stringBuilder == null) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(string2);
            }
        }
        finally {
            this.data_repo.release(statement, null);
        }
    }

    @Override
    protected int addMessageAdditionalInfo(PreparedStatement stmt, int i, Map<String, Object> additionalData) throws SQLException {
        stmt.setString(i++, (String)additionalData.get("jingle-sid"));
        stmt.setString(i++, (String)additionalData.get("jingle-action"));
        stmt.setString(i++, (String)additionalData.get("jingle-reason"));
        stmt.setShort(i++, (short)((Boolean)additionalData.get("tigase-offline") != false ? 1 : 0));
        return super.addMessageAdditionalInfo(stmt, i, additionalData);
    }

    protected void archiveMessage(BareJID owner, JID buddy, MessageArchiveRepository.Direction direction, Date timestamp, Element msg, Set<String> tags, Map<String, Object> additionalData) {
        Element element2;
        if (msg.getName() == "iq" && (element2 = msg.getChild("jingle")) != null) {
            Element element3;
            additionalData.put("jingle-sid", element2.getAttributeStaticStr("sid"));
            additionalData.put("jingle-action", element2.getAttributeStaticStr("action"));
            Element element4 = element2.getChild("reason");
            String string = null;
            if (element4 != null && (element3 = element4.findChild(element -> element.getName() != "text")) != null) {
                string = element3.getName();
            }
            additionalData.put("jingle-reason", string);
        }
        super.archiveMessage(owner, buddy, direction, timestamp, msg, tags, additionalData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<? extends UnifiedArchiveRepositoryWithTigaseQuery.Item> queryRecents(BareJID ownerJid, Date start, Date end, Set<UnifiedArchiveRepositoryWithTigaseQuery.Type> types, Set<UnifiedArchiveRepositoryWithTigaseQuery.CallCondition> callConditions, RSM rsm) throws TigaseDBException {
        PreparedStatement preparedStatement;
        rsm.setCount(Integer.valueOf(this.countItems(ownerJid, start, end, types, callConditions)));
        int n = 0;
        if (rsm.getIndex() != null) {
            n = rsm.getIndex();
        }
        ResultSet resultSet = null;
        PreparedStatement preparedStatement2 = preparedStatement = this.getDataRepository().getPreparedStatement(ownerJid, this.g);
        synchronized (preparedStatement2) {
            Object object;
            try {
                int n2 = 1;
                preparedStatement.setString(n2++, ownerJid.toString());
                switch (this.getDataRepository().getDatabaseType()) {
                    case jtds: 
                    case sqlserver: {
                        preparedStatement.setString(n2++, ownerJid.toString());
                        break;
                    }
                }
                if (start != null) {
                    preparedStatement.setTimestamp(n2++, new Timestamp(start.getTime()));
                    preparedStatement.setTimestamp(n2++, new Timestamp(start.getTime()));
                } else {
                    preparedStatement.setNull(n2++, 93);
                    preparedStatement.setNull(n2++, 93);
                }
                if (end != null) {
                    preparedStatement.setTimestamp(n2++, new Timestamp(end.getTime()));
                    preparedStatement.setTimestamp(n2++, new Timestamp(end.getTime()));
                } else {
                    preparedStatement.setNull(n2++, 93);
                    preparedStatement.setNull(n2++, 93);
                }
                preparedStatement.setInt(n2++, types.contains((Object)UnifiedArchiveRepositoryWithTigaseQuery.Type.chat) ? 1 : 0);
                preparedStatement.setInt(n2++, types.contains((Object)UnifiedArchiveRepositoryWithTigaseQuery.Type.groupchat) ? 1 : 0);
                preparedStatement.setInt(n2++, types.contains((Object)UnifiedArchiveRepositoryWithTigaseQuery.Type.call) ? 1 : 0);
                preparedStatement.setInt(n2++, callConditions.contains((Object)UnifiedArchiveRepositoryWithTigaseQuery.CallCondition.success) ? 1 : 0);
                preparedStatement.setInt(n2++, callConditions.contains((Object)UnifiedArchiveRepositoryWithTigaseQuery.CallCondition.missed) ? 1 : 0);
                preparedStatement.setInt(n2++, callConditions.contains((Object)UnifiedArchiveRepositoryWithTigaseQuery.CallCondition.canceled) ? 1 : 0);
                switch (this.getDataRepository().getDatabaseType()) {
                    case jtds: 
                    case sqlserver: {
                        preparedStatement.setInt(n2++, n);
                        preparedStatement.setInt(n2++, n + rsm.getMax());
                        break;
                    }
                    case derby: {
                        preparedStatement.setInt(n2++, n);
                        preparedStatement.setInt(n2++, rsm.getMax());
                        break;
                    }
                    default: {
                        preparedStatement.setInt(n2++, rsm.getMax());
                        preparedStatement.setInt(n2++, n);
                    }
                }
                resultSet = preparedStatement.executeQuery();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (resultSet.next()) {
                    object = new Item(resultSet);
                    arrayList.add(object);
                }
                if (!arrayList.isEmpty()) {
                    rsm.setResults(rsm.getCount(), ((Item)arrayList.get(0)).getId(), ((Item)arrayList.get(arrayList.size() - 1)).getId());
                    rsm.setIndex(Integer.valueOf(n));
                }
                object = arrayList.stream();
            }
            catch (Throwable throwable) {
                try {
                    this.getDataRepository().release(null, resultSet);
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    throw new TigaseDBException("Failed to retrieve list of recent items", (Throwable)sQLException);
                }
            }
            this.getDataRepository().release(null, resultSet);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int countItems(BareJID ownerJid, Date start, Date end, Set<UnifiedArchiveRepositoryWithTigaseQuery.Type> types, Set<UnifiedArchiveRepositoryWithTigaseQuery.CallCondition> callConditions) throws SQLException {
        PreparedStatement preparedStatement;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement2 = preparedStatement = this.getDataRepository().getPreparedStatement(ownerJid, this.f);
        synchronized (preparedStatement2) {
            block12: {
                int n2;
                try {
                    int n = 1;
                    preparedStatement.setString(n++, ownerJid.toString());
                    switch (this.getDataRepository().getDatabaseType()) {
                        case jtds: 
                        case sqlserver: {
                            preparedStatement.setString(n++, ownerJid.toString());
                            break;
                        }
                    }
                    if (start != null) {
                        preparedStatement.setTimestamp(n++, new Timestamp(start.getTime()));
                        preparedStatement.setTimestamp(n++, new Timestamp(start.getTime()));
                    } else {
                        preparedStatement.setNull(n++, 93);
                        preparedStatement.setNull(n++, 93);
                    }
                    if (end != null) {
                        preparedStatement.setTimestamp(n++, new Timestamp(end.getTime()));
                        preparedStatement.setTimestamp(n++, new Timestamp(end.getTime()));
                    } else {
                        preparedStatement.setNull(n++, 93);
                        preparedStatement.setNull(n++, 93);
                    }
                    preparedStatement.setInt(n++, types.contains((Object)UnifiedArchiveRepositoryWithTigaseQuery.Type.chat) ? 1 : 0);
                    preparedStatement.setInt(n++, types.contains((Object)UnifiedArchiveRepositoryWithTigaseQuery.Type.groupchat) ? 1 : 0);
                    preparedStatement.setInt(n++, types.contains((Object)UnifiedArchiveRepositoryWithTigaseQuery.Type.call) ? 1 : 0);
                    preparedStatement.setInt(n++, callConditions.contains((Object)UnifiedArchiveRepositoryWithTigaseQuery.CallCondition.success) ? 1 : 0);
                    preparedStatement.setInt(n++, callConditions.contains((Object)UnifiedArchiveRepositoryWithTigaseQuery.CallCondition.missed) ? 1 : 0);
                    preparedStatement.setInt(n++, callConditions.contains((Object)UnifiedArchiveRepositoryWithTigaseQuery.CallCondition.canceled) ? 1 : 0);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block12;
                    n2 = resultSet.getInt(1);
                }
                catch (Throwable throwable) {
                    this.getDataRepository().release(null, resultSet);
                    throw throwable;
                }
                this.getDataRepository().release(null, resultSet);
                return n2;
            }
            int n = 0;
            this.getDataRepository().release(null, resultSet);
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String a(DataRepository.dbTypes dbTypes2, String string) {
        if (dbTypes2 == DataRepository.dbTypes.jtds) {
            dbTypes2 = DataRepository.dbTypes.sqlserver;
        }
        try (InputStreamReader inputStreamReader = new InputStreamReader(this.getClass().getResourceAsStream("/queries/" + dbTypes2.name() + "-" + string + ".sql"));){
            int n;
            char[] cArray = new char[1024];
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = inputStreamReader.read(cArray)) > -1) {
                stringBuilder.append(cArray, 0, n);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        catch (Exception exception) {
            throw new RuntimeException("failed to load query " + string + " for database " + dbTypes2, exception);
        }
    }

    public static class Item
    implements UnifiedArchiveRepositoryWithTigaseQuery.Item {
        private static final SimpleParser a = SingletonFactory.getParserInstance();
        private final String b;
        private final Timestamp c;
        private final MessageArchiveRepository.Direction d;
        private final String e;
        private final String f;
        private final Element g;
        private final String h;
        private final Long i;

        protected Item(ResultSet rs) throws SQLException {
            this.b = rs.getString(1);
            this.c = rs.getTimestamp(2);
            this.d = MessageArchiveRepository.Direction.getDirection((short)rs.getShort(3));
            String string = rs.getString(4);
            this.e = rs.getString(5);
            this.f = rs.getString(6);
            DomBuilderHandler domBuilderHandler = new DomBuilderHandler();
            a.parse((SimpleHandler)domBuilderHandler, string.toCharArray(), 0, string.length());
            this.g = (Element)domBuilderHandler.getParsedElements().poll();
            this.h = rs.getString(7);
            this.i = rs.getLong(8);
        }

        @Override
        public String getId() {
            return this.h;
        }

        @Override
        public Element getMessage() {
            return this.g;
        }

        @Override
        public Date getTimestamp() {
            return this.c;
        }

        @Override
        public MessageArchiveRepository.Direction getDirection() {
            return this.d;
        }

        @Override
        public String getWith() {
            return this.b;
        }

        @Override
        public String getItemType() {
            return this.e;
        }

        @Override
        public Long getDuration() {
            return this.i;
        }

        @Override
        public String getCondition() {
            return this.f;
        }
    }
}

