/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class ScriptFileLoader {
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private final String file;
    private final Map<String, String> replace;
    private final Queue<StanzaEntry> stanzas_buff;
    private static final Pattern pattern = Pattern.compile("(^(.+)\\((.*)\\):.*)|(^(.+):.*)");

    public ScriptFileLoader(String source_file, Queue<StanzaEntry> stanzas_buff2, Map<String, String> replaces) {
        this.file = source_file;
        this.stanzas_buff = stanzas_buff2;
        this.replace = replaces;
    }

    public void loadSourceFile() {
        try {
            ParserState state = ParserState.start;
            String description = null;
            StringBuilder buff = null;
            BufferedReader buffr = new BufferedReader(new FileReader(this.file));
            String line = buffr.readLine();
            while (line != null) {
                line = line.trim();
                switch (state) {
                    case start: {
                        String keyword = "";
                        String param = null;
                        Matcher m = pattern.matcher(line);
                        boolean b = m.matches();
                        if (b) {
                            keyword = m.group(2) == null ? m.group(5) : m.group(2);
                            String string = param = m.group(3) == null ? null : m.group(3);
                        }
                        if ("send".equals(keyword)) {
                            state = ParserState.send_stanza;
                            description = param;
                            buff = new StringBuilder();
                        }
                        if ("expect".equals(keyword)) {
                            state = ParserState.expect_stanza;
                            description = param;
                            buff = new StringBuilder();
                        }
                        if ("expect all".equals(keyword)) {
                            state = ParserState.expect_all_stanza;
                            description = param;
                            buff = new StringBuilder();
                        }
                        if (!"expect strict".equals(keyword)) break;
                        state = ParserState.expect_strict_stanza;
                        description = param;
                        buff = new StringBuilder();
                        break;
                    }
                    case send_stanza: 
                    case expect_stanza: 
                    case expect_all_stanza: 
                    case expect_strict_stanza: {
                        if (!(line.equals("{") || line.equals("}") || line.startsWith("#"))) {
                            buff.append(line + '\n');
                        }
                        if (!line.equals("}")) break;
                        Element[] elems = this.parseXMLData(buff.toString());
                        switch (state) {
                            case send_stanza: {
                                this.stanzas_buff.offer(new StanzaEntry(Action.send, elems, description));
                                break;
                            }
                            case expect_stanza: {
                                this.stanzas_buff.offer(new StanzaEntry(Action.expect, elems, description));
                                break;
                            }
                            case expect_all_stanza: {
                                this.stanzas_buff.offer(new StanzaEntry(Action.expect_all, elems, description));
                                break;
                            }
                            case expect_strict_stanza: {
                                this.stanzas_buff.offer(new StanzaEntry(Action.expect_strict, elems, description));
                                break;
                            }
                        }
                        state = ParserState.start;
                        break;
                    }
                }
                line = buffr.readLine();
            }
            buffr.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read source file: " + this.file + " due to exception: " + e.getMessage(), e);
        }
    }

    private Element[] parseXMLData(String data) throws IOException {
        if (this.replace != null) {
            for (Map.Entry<String, String> entry : this.replace.entrySet()) {
                data = data.replace(entry.getKey(), entry.getValue());
            }
        }
        final StringBuilder sb = new StringBuilder();
        DomBuilderHandler domHandler = new DomBuilderHandler(){

            public void error(String errorMessage) {
                super.error(errorMessage);
                sb.append(errorMessage);
            }
        };
        parser.parse((SimpleHandler)domHandler, data.toCharArray(), 0, data.length());
        if (sb.length() > 0) {
            throw new IOException(sb.toString());
        }
        Queue elems = domHandler.getParsedElements();
        if (elems != null && elems.size() > 0) {
            return elems.toArray(new Element[elems.size()]);
        }
        return null;
    }

    public static class StanzaEntry {
        private Action action = null;
        private Element[] stanza = null;
        private String description;
        private final Set<String> params;

        public StanzaEntry(Action action, Element[] stanza, String description) {
            String[] k;
            this.action = action;
            this.stanza = stanza;
            this.description = description;
            HashSet<String> ppp = new HashSet<String>();
            if (description != null && (k = description.split(" ")) != null) {
                for (String string : k) {
                    if (string == null || !string.trim().startsWith("#") || string.length() <= 1) continue;
                    ppp.add(string.substring(1));
                }
            }
            this.params = Collections.unmodifiableSet(ppp);
        }

        public Action getAction() {
            return this.action;
        }

        public Element[] getStanza() {
            return this.stanza;
        }

        public String getDescription() {
            return this.description;
        }

        public Set<String> getParams() {
            return this.params;
        }
    }

    private static enum ParserState {
        expect_stanza,
        send_stanza,
        start,
        expect_all_stanza,
        expect_strict_stanza;

    }

    public static enum Action {
        expect,
        expect_all,
        expect_strict,
        send;

    }
}

