/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.impl;

import java.net.Socket;
import java.util.Map;
import javax.management.Attribute;
import tigase.test.TestAbstract;
import tigase.test.util.Params;
import tigase.test.util.TestUtil;
import tigase.util.Algorithms;
import tigase.xml.Element;

public class TestAuth
extends TestAbstract {
    private String user_name = "test_user@localhost";
    private String user_pass = "test_pass";
    private String user_resr = "xmpp-test";
    private String hostname = "localhost";
    private boolean digest = true;
    private String pass_elem = null;
    private String[] elems = new String[]{"iq", "iq"};
    private int counter = 0;

    public TestAuth() {
        super(new String[]{"jabber:client"}, new String[]{"auth-plain", "auth-digest"}, new String[]{"stream-open"}, new String[]{"ssl-init", "tls-init", "user-register"});
    }

    @Override
    public String nextElementName(Element reply) throws Exception {
        if (this.counter < this.elems.length) {
            return this.elems[this.counter++];
        }
        this.params.put("authorized", (Object)true);
        if (this.params.containsKey("-active-connection")) {
            TestUtil.addActiveConnection((Socket)this.params.get("socket"));
        }
        return null;
    }

    @Override
    public String getElementData(String element) throws Exception {
        switch (this.counter) {
            case 1: {
                return "<iq type='get' id='" + this.user_name + "_1' to='" + this.hostname + "'><query xmlns='jabber:iq:auth'><username>" + this.user_name + "</username></query></iq>";
            }
            case 2: {
                return "<iq type='set' id='" + this.user_name + "_2'><query xmlns='jabber:iq:auth'><username>" + this.user_name + "</username>" + this.getPassElem() + "<resource>" + this.user_resr + "</resource></query></iq>";
            }
        }
        return null;
    }

    private String getPassElem() throws Exception {
        if (this.digest) {
            return "<digest>" + Algorithms.digest((String)((String)this.params.get("session-id")), (String)this.user_pass, (String)"SHA") + "</digest>";
        }
        return "<password>" + this.user_pass + "</password>";
    }

    @Override
    public String[] getRespElementNames(String element) {
        return new String[]{"iq"};
    }

    @Override
    public Attribute[] getRespElementAttributes(String element) {
        switch (this.counter) {
            case 1: {
                return new Attribute[]{new Attribute("type", "result"), new Attribute("id", this.user_name + "_1")};
            }
            case 2: {
                return new Attribute[]{new Attribute("type", "result"), new Attribute("id", this.user_name + "_2")};
            }
        }
        return null;
    }

    @Override
    public String[] getRespOptionalNames(String element) {
        return null;
    }

    @Override
    public void init(Params map, Map<String, String> vars) {
        super.init(map, vars);
        this.user_name = this.params.get("-user-name", this.user_name);
        this.user_pass = this.params.get("-user-pass", this.user_pass);
        this.user_resr = this.params.get("-user-resr", this.user_resr);
        this.hostname = this.params.get("-host", this.hostname);
        String test_ns = (String)this.params.get("-test-ns");
        boolean found = false;
        if (test_ns != null) {
            if (test_ns.contains("auth-digest")) {
                this.digest = true;
                found = true;
            }
            if (test_ns.contains("auth-plain")) {
                this.digest = false;
                found = true;
            }
        }
        if (!found) {
            String auth = (String)this.params.get("-def-auth");
            if (auth.contains("auth-digest")) {
                this.digest = true;
            }
            if (auth.contains("auth-plain")) {
                this.digest = false;
            }
        }
    }
}

