/*
 * Decompiled with CFR 0.152.
 */
package tigase.test;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import tigase.test.HistoryCollectorIfc;
import tigase.test.HistoryEntry;
import tigase.test.TestIfc;
import tigase.test.parser.TestNode;
import tigase.test.util.Params;
import tigase.test.util.TestUtil;
import tigase.test.util.XMLIO;
import tigase.xml.Element;

public class Test {
    public static final String NS_SEP = ";";
    private String testName = null;
    private Map<String, String> pars = null;
    private Params main_params = null;
    private String description = null;
    private String[] test_ns = null;
    private boolean result = false;
    private String errorMsg = null;
    private Exception exception = null;
    private HistoryCollectorIfc historyColl = null;
    private int tests_ok = 0;
    private int tests_er = 0;
    private long total_time = 0L;
    private long total_successful = 0L;
    private boolean collectHistory = false;
    private LinkedList<HistoryEntry> history = new LinkedList();
    private boolean on_one_socket = false;
    private boolean active_connection = false;
    private Element lastResult = null;
    private Test onError = null;
    private TestNode node = null;
    private boolean debug = false;
    private CountDownLatch latch = null;
    protected boolean debug_on_error = false;
    protected boolean last_result = false;
    private boolean stop_on_fail = false;
    private static TimerThread[] backroundTasks = new TimerThread[10000];
    private static int timer_idx = 0;

    public Test(TestNode node) {
        String ldescr;
        this.node = node;
        this.testName = node.getName();
        this.test_ns = node.getId() != null ? node.getId().split(NS_SEP) : null;
        this.pars = node.getPars();
        this.main_params = new Params(this.pars);
        this.description = node.getShortDescr();
        if ((this.description == null || this.description.trim().equals("")) && (ldescr = node.getLongDescr()) != null) {
            this.description = ldescr.substring(2, ldescr.length() - 2);
        }
        if (node.getOnError() != null) {
            this.onError = new Test(node.getOnError());
        }
        if (!(this.main_params.isFalse("-output-history") || this.main_params.containsKey("-daemon") || this.main_params.containsKey("-background"))) {
            this.collectHistory = true;
        }
    }

    private void initParams() {
        this.on_one_socket = this.main_params.containsKey("-on-one-socket");
        this.active_connection = this.main_params.containsKey("-active-connection") || this.main_params.containsKey("-background");
    }

    public void runTest(HistoryCollectorIfc historyColl) {
        if (this.debug) {
            TestUtil.debug("\n\n\n===========================", this.debug);
        }
        this.historyColl = historyColl;
        this.initParams();
        this.debug = this.main_params.containsKey("-debug");
        this.debug_on_error = this.main_params.containsKey("-debug-on-error") && !this.main_params.containsKey("-no-record");
        this.stop_on_fail = this.main_params.get("-stop-on-fail", false);
        int loop = this.main_params.get("-loop", 1);
        String deb_name = "" + (this.node.getParent() != null ? this.node.getParent().getName() : "null") + "/" + this.getName();
        this.latch = new CountDownLatch(loop);
        if (this.node.getParent() != null && this.node.getParent().getPars().get("$(outer-loop)") != null && !this.node.getParent().getPars().containsKey("-multi-thread")) {
            this.node.addVar("$(outer-loop)", this.node.getParent().getPars().get("$(outer-loop)"));
        }
        int loop_start = 1;
        if (this.main_params.get("-loop-start") != null && this.node.getParent() != null && this.node.getParent().getPars().get("$(outer-loop)") != null && !this.node.getParent().getPars().containsKey("-multi-thread")) {
            try {
                loop_start = Integer.parseInt(this.node.getParent().getPars().get("$(outer-loop)")) + 1;
            }
            catch (Exception e) {
                loop_start = 1;
            }
        } else {
            loop_start = this.main_params.get("-loop-start", 0);
        }
        boolean loop_user_name = true;
        long loop_delay = 0L;
        if (this.main_params.containsKey("-loop-delay")) {
            loop_delay = this.main_params.get("-loop-delay", 10);
        }
        LinkedList<Object> suite = new LinkedList();
        Params test_params = null;
        long all_tests_start_time = System.currentTimeMillis();
        for (int cnt = loop_start; cnt < loop + loop_start; ++cnt) {
            try {
                this.node.addPar("$(outer-loop)", "" + cnt);
                this.node.addVar("$(loop)", "" + cnt);
                if (this.on_one_socket && cnt > 0 && this.last_result) {
                    LinkedList<TestIfc> suite_tmp = TestUtil.getDependsTree(this.test_ns, test_params);
                    suite.clear();
                    suite.addAll(suite_tmp.subList(suite_tmp.size() - 1, suite_tmp.size()));
                } else {
                    test_params = new Params();
                    test_params.putAll((Map)this.main_params);
                    suite = TestUtil.getDependsTree(this.test_ns, test_params);
                }
                if (suite.size() == 0) {
                    this.errorMsg = "No tests implementation found for given name space: " + this.node.getId();
                    this.result = false;
                    return;
                }
                if (loop_user_name) {
                    for (Map.Entry entry : this.main_params.entrySet()) {
                        if (entry.getValue() == null || !entry.getValue().toString().contains("$(loop)")) continue;
                        test_params.put((String)entry.getKey(), (Object)entry.getValue().toString().replace("$(loop)", "" + cnt));
                    }
                }
                this.runTest(suite, test_params, this.node.getVars());
                if ((this.stop_on_fail || cnt > 10) && this.tests_ok < this.tests_er) {
                    TestUtil.debug("Too many errors, stopping test...\n", this.debug);
                    this.result = false;
                    this.errorMsg = "Too many errors, stopping test: " + this.tests_ok + " OK, " + this.tests_er + " ER";
                    return;
                }
            }
            catch (Exception e) {
                this.result = false;
                this.errorMsg = e.getMessage();
                this.exception = e;
                return;
            }
            if (loop_delay <= 0L) continue;
            try {
                Thread.sleep(loop_delay);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            this.latch.await();
        }
        catch (InterruptedException cnt) {
            // empty catch block
        }
        this.main_params = test_params;
        boolean bl = this.result = this.tests_ok > this.tests_er;
        if (this.main_params.containsKey("-delay")) {
            long delay = this.main_params.get("-delay", 1000);
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.total_time = System.currentTimeMillis() - all_tests_start_time;
    }

    private void runTest(LinkedList<TestIfc> suite, Params test_params, Map<String, String> vars) {
        boolean daemon = test_params.containsKey("-daemon");
        boolean background = test_params.containsKey("-background");
        long socket_wait = test_params.get("-socket-wait", 5000);
        DaemonTest dt = new DaemonTest(suite, test_params, this, vars);
        if (daemon) {
            this.runThread(dt, true);
            ++this.tests_ok;
            this.latch.countDown();
        } else if (background) {
            this.runTimerTask(dt);
        } else {
            dt.run();
            this.latch.countDown();
        }
    }

    private void runThread(DaemonTest task, boolean daemon) {
        Thread t = new Thread(task);
        t.setDaemon(daemon);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTimerTask(DaemonTest task) {
        TimerThread timer = null;
        TimerThread[] timerThreadArray = backroundTasks;
        synchronized (backroundTasks) {
            timer = backroundTasks[timer_idx];
            if (timer == null) {
                Test.backroundTasks[Test.timer_idx] = timer = new TimerThread(timer_idx, false);
            }
            if (++timer_idx >= backroundTasks.length) {
                timer_idx = 0;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            TimerTest tt = new TimerTest(task, timer);
            timer.schedule((TimerTask)tt, tt.repeat_wait, tt.repeat_wait);
            return;
        }
    }

    public void handleResult(DaemonTest dt, boolean result) {
        if (result) {
            ++this.tests_ok;
        } else {
            ++this.tests_er;
            String on_error = (String)dt.params.get("-on-error");
            if (this.onError != null) {
                this.onError.runTest(this.historyColl);
            }
        }
    }

    public int getTestsOK() {
        return this.tests_ok;
    }

    public void addTestsOK(int tests) {
        this.tests_ok += tests;
    }

    public int getTestsErr() {
        return this.tests_er;
    }

    public void addTestsErr(int tests) {
        this.tests_er += tests;
    }

    public long getTestsTotalTime() {
        return this.total_time;
    }

    public void addTestsTotalTime(long time) {
        this.total_time += time;
    }

    public long getSuccessfulTotalTime() {
        return this.total_successful;
    }

    public void addSuccessfulTotalTime(long time) {
        this.total_successful += time;
    }

    public List<HistoryEntry> getHistory() {
        return this.history;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Element getLastResult() {
        return this.lastResult;
    }

    public boolean getResult() {
        return this.result;
    }

    public void setResult(boolean res) {
        this.result = res;
    }

    public void setName(String name) {
        this.testName = name;
    }

    public String getName() {
        return this.testName;
    }

    public Params getParams() {
        return this.main_params;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public String getDescription() {
        return this.description;
    }

    class DaemonTest
    implements Runnable,
    HistoryCollectorIfc {
        private List<TestIfc> suite = null;
        private Params params = null;
        private Map<String, String> vars = null;
        private boolean authorized = false;
        private Test resultsHandler = null;

        public DaemonTest(LinkedList<TestIfc> suite, Params params, Test resultsHandler, Map<String, String> vars) {
            this.suite = suite;
            this.params = params;
            this.vars = vars;
            this.resultsHandler = resultsHandler;
        }

        @Override
        public void handleHistoryEntry(HistoryEntry historyEntry) {
            if (Test.this.collectHistory) {
                Test.this.historyColl.handleHistoryEntry(historyEntry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            long test_start_time = System.currentTimeMillis();
            TestIfc tmptest = null;
            try {
                for (TestIfc test : this.suite) {
                    DaemonTest daemonTest;
                    if (Test.this.debug) {
                        TestUtil.debug("\n", Test.this.debug);
                    }
                    test.setHistoryCollector(this);
                    TestUtil.debug("Testing: " + TestUtil.toStringArrayNS(test.implemented(), "..."), Test.this.debug);
                    tmptest = test;
                    test.setName(Test.this.getName());
                    test.init(this.params, this.vars);
                    boolean res = test.run();
                    if (res) {
                        Test.this.lastResult = test.getLastResult();
                        this.authorized = this.params.get("authorized", false);
                        if (this.authorized) {
                            daemonTest = this;
                            synchronized (daemonTest) {
                                this.notifyAll();
                            }
                        }
                        TestUtil.debug("     success!\n", Test.this.debug);
                        Test.this.last_result = true;
                        continue;
                    }
                    Test.this.errorMsg = test.getResultMessage();
                    TestUtil.debug("       failure!\n", Test.this.debug || Test.this.debug_on_error);
                    TestUtil.debug("Error code: " + (Object)((Object)test.getResultCode()) + ", error message: " + test.getResultMessage() + "\n", Test.this.debug || Test.this.debug_on_error);
                    Test.this.last_result = false;
                    daemonTest = this;
                    synchronized (daemonTest) {
                        this.notifyAll();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Test.this.exception = e;
                Test.this.errorMsg = e.toString();
                Test.this.last_result = false;
                this.params.put("authorized", (Object)false);
                DaemonTest daemonTest = this;
                synchronized (daemonTest) {
                    this.notifyAll();
                }
            }
            if (!Test.this.on_one_socket && !Test.this.active_connection) {
                try {
                    ((XMLIO)this.params.get("socketxmlio")).close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            DaemonTest e = this;
            synchronized (e) {
                this.notifyAll();
            }
            this.resultsHandler.handleResult(this, Test.this.last_result);
            long this_test = System.currentTimeMillis() - test_start_time;
            Test.this.total_time = Test.this.total_time + this_test;
            Test.this.total_successful = Test.this.total_successful + this_test;
        }

        public boolean getResult() {
            return Test.this.result;
        }

        public boolean isAuthorized() {
            return this.authorized;
        }
    }

    class TimerTest
    extends TimerTask {
        private DaemonTest dt = null;
        private TimerThread tt = null;
        private long repeat_max = 1L;
        private long repeat_wait = 1L;
        private long counter = 0L;
        private boolean failure = false;

        public TimerTest(DaemonTest dt, TimerThread tt) {
            this.dt = dt;
            this.tt = tt;
            this.repeat_max = dt.params.get("-repeat-script", 1);
            this.repeat_wait = dt.params.get("-repeat-wait", 1);
        }

        @Override
        public void run() {
            ++this.counter;
            if (this.counter == 2L && this.dt.suite.size() > 1) {
                this.dt.suite.subList(0, this.dt.suite.size() - 1).clear();
            }
            if (this.counter >= 2L) {
                boolean bl = this.failure = !this.dt.params.get("authorized", false);
            }
            if (!this.failure) {
                this.dt.run();
            } else {
                System.out.println("Test run " + this.counter + " failed for user: " + this.dt.params.get("-user-name", "uknown"));
                this.counter = this.repeat_max;
            }
            if (this.counter >= this.repeat_max) {
                this.cancel();
                this.tt.stopped();
                ((TestIfc)this.dt.suite.get(0)).release();
                Test.this.latch.countDown();
            }
        }
    }

    class TimerThread
    extends Timer {
        private int idx;
        private int counter;

        public TimerThread(int idx, boolean daemon) {
            super("Background Timer " + idx, daemon);
            this.idx = 0;
            this.counter = 0;
            this.idx = idx;
        }

        @Override
        public void schedule(TimerTask task, long delay, long period) {
            ++this.counter;
            super.schedule(task, delay, period);
        }

        public void stopped() {
            --this.counter;
            if (this.counter <= 0) {
                backroundTasks[this.idx] = null;
                this.cancel();
            }
        }
    }
}

