/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Iterator;
import java.util.Queue;
import tigase.test.util.DomBuilderHandler;
import tigase.test.util.XMLIO;
import tigase.xml.DefaultElementFactory;
import tigase.xml.Element;
import tigase.xml.ElementFactory;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;

public class SocketXMLIO
implements XMLIO {
    private static final int BUFF_SIZE = 2048;
    protected Socket socket = null;
    private DomBuilderHandler dom = null;
    private InputStreamReader inp = null;
    private OutputStream out = null;
    private SimpleParser parser = null;
    private char[] in_data = new char[2048];
    protected boolean ignore_presence = false;

    public SocketXMLIO(Socket sock) throws IOException {
        this.setSocket(sock);
    }

    public void setSocket(Socket sock) throws IOException {
        this.socket = sock;
        this.out = sock.getOutputStream();
        this.inp = new InputStreamReader(sock.getInputStream());
        this.dom = new DomBuilderHandler((ElementFactory)new DefaultElementFactory());
        this.parser = new SimpleParser();
    }

    @Override
    public void close() {
        try {
            this.write("</stream:stream>");
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    @Override
    public void write(Element data) throws IOException {
        this.write(data.toString());
    }

    @Override
    public void write(String data) throws IOException {
        if (!this.socket.isConnected()) {
            throw new ConnectException("Socket is not connected.");
        }
        this.out.write(data.getBytes());
        this.out.flush();
    }

    @Override
    public Queue<Element> read() throws IOException {
        if (!this.socket.isConnected()) {
            throw new ConnectException("Socket is not connected.");
        }
        int res = this.inp.read(this.in_data);
        if (res < 0) {
            throw new EOFException("End of stream on network socket detected.");
        }
        if (res > 0) {
            this.parser.parse((SimpleHandler)this.dom, this.in_data, 0, res);
        }
        Queue<Element> results = this.dom.getParsedElements();
        if (this.ignore_presence && results != null) {
            Iterator it = results.iterator();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                if (el.getName() != "presence") continue;
                it.remove();
            }
        }
        return results;
    }

    @Override
    public void setIgnorePresence(boolean ignore) {
        this.ignore_presence = ignore;
    }
}

