/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Params
implements Map<String, Object> {
    private Map<String, Object> map = null;

    public Params() {
        this.map = new TreeMap<String, Object>();
    }

    public Params(Map map) {
        this.map = new TreeMap<String, Object>(map);
    }

    public Params(String pars) {
        this.map = Params.parseParams(pars.split("[ \n]"));
    }

    public Params(String[] pars) {
        this.map = Params.parseParams(pars);
    }

    protected static Map<String, Object> parseParams(String[] args) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (!arg.startsWith("-")) continue;
                if (i + 1 >= args.length || args[i + 1].trim().startsWith("-")) {
                    map.put(arg, null);
                    continue;
                }
                map.put(arg, args[++i].trim());
            }
        }
        return map;
    }

    public Map<String, String> getMap() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            result.put(entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    public String get(String key, String def) {
        String val = (String)this.map.get(key);
        if (val != null) {
            if (val.startsWith("\"") && val.endsWith("\"")) {
                return val.substring(1, val.length() - 1);
            }
            return val;
        }
        return def;
    }

    public int get(String key, int def) {
        return this.map.containsKey(key) ? Integer.decode(this.map.get(key).toString()) : def;
    }

    public long get(String key, long def) {
        return this.map.containsKey(key) ? Long.decode(this.map.get(key).toString()) : def;
    }

    public static boolean decodeBoolean(String val) {
        if (val == null) {
            return false;
        }
        return val.equals("1") || val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("on") || val.equalsIgnoreCase("tak");
    }

    public boolean isFalse(String key) {
        if (!this.containsKey(key)) {
            return true;
        }
        String val = ((String)this.get(key)).toLowerCase();
        return val.equals("false") || val.equals("0") || val.equals("no") || val.equals("off");
    }

    public boolean get(String key, boolean def) {
        return this.map.containsKey(key) ? Params.decodeBoolean(this.map.get(key).toString()) : def;
    }

    @Override
    public void putAll(Map map) {
        if (map != null) {
            this.map.putAll(map);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    public String toString() {
        return this.map.toString();
    }
}

