/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import tigase.test.util.OutputFilter;

public class HTMLFilter
implements OutputFilter {
    private BufferedWriter bw = null;
    private long start = 0L;

    @Override
    public void init(BufferedWriter out, String title, String description) throws IOException {
        this.bw = out;
        this.bw.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n");
        this.bw.write("<html>\n");
        this.bw.write(" <head>\n");
        this.bw.write("  <title>" + title + "</title>\n");
        this.bw.write(" </head>\n");
        this.bw.write(" <body>\n");
        this.bw.write("  <h2>" + title + "</h2>\n");
        this.bw.write("  " + description + "\n");
        this.bw.write("  <p>Test start time: <b>" + DateFormat.getDateTimeInstance().format(new Date()) + "</b></p>\n");
        this.bw.flush();
        this.start = System.currentTimeMillis();
    }

    @Override
    public void addContent(String content) throws IOException {
        this.bw.write(content);
        this.bw.flush();
    }

    @Override
    public void close(String closingInfo) throws IOException {
        this.bw.write("  </table>\n");
        this.bw.write("  </p>\n");
        this.bw.write("  <p>Test end time: <b>" + DateFormat.getDateTimeInstance().format(new Date()) + "</b></p>\n");
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(System.currentTimeMillis() - this.start);
        this.bw.write("  <p>Total test time:");
        this.bw.write(" " + cal.get(11) + " hours");
        this.bw.write(", " + cal.get(12) + " minutes");
        this.bw.write(", " + cal.get(13) + " seconds");
        this.bw.write(", " + cal.get(14) + " ms.</p>");
        this.bw.write(closingInfo);
        this.bw.write(" </body>\n");
        this.bw.write("</html>\n");
        this.bw.flush();
        this.bw.close();
    }

    @Override
    public void setColumnHeaders(String ... hd) throws IOException {
        this.bw.write("  <p>\n");
        this.bw.write("  <table border='1' style='min-width: 800px;'>\n");
        this.bw.write("   <thead valign='middle'>\n");
        this.bw.write("    <tr>\n");
        for (String header : hd) {
            if (header.equals("Test name") || header.equals("History")) {
                this.bw.write("     <th width='225px'>" + header + "</th>\n");
                continue;
            }
            this.bw.write("     <th>" + header + "</th>\n");
        }
        this.bw.write("    </tr>\n");
        this.bw.write("   </thead>\n");
        this.bw.flush();
    }

    @Override
    public void addRow(String ... cols) throws IOException {
        this.bw.write("   <tr valign=\"top\">");
        for (String col : cols) {
            if (col.equals("<b>success</b>")) {
                this.bw.write("    <td bgcolor=\"#90FF90\">" + col + "</td>");
                continue;
            }
            if (col.equals("<b>FAILURE</b>")) {
                this.bw.write("    <td bgcolor=\"#FF9090\">" + col + "</td>");
                continue;
            }
            this.bw.write("    <td>" + col + "</td>");
        }
        this.bw.write("   </tr>\n");
        this.bw.flush();
    }
}

