/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.util;

import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.xml.Element;
import tigase.xml.ElementFactory;
import tigase.xml.SimpleHandler;
import tigase.xml.XMLNodeIfc;

public class DomBuilderHandler
implements SimpleHandler {
    private static Logger log = Logger.getLogger("tigase.protocols.xmpp.DomBuilderHandler");
    private static final String ELEM_STREAM_STREAM = "stream:stream";
    private ElementFactory customFactory = null;
    private Object parserState = null;
    private String top_xmlns = null;
    private String def_xmlns = null;
    private LinkedList<Element> all_roots = new LinkedList();
    private Stack<Element> el_stack = new Stack();

    public DomBuilderHandler(ElementFactory factory) {
        this.customFactory = factory;
    }

    public Queue<Element> getParsedElements() {
        return this.all_roots;
    }

    public void error(String msg) {
        log.warning("XML content parse error.");
        log.warning(msg);
    }

    private Element newElement(String name, String cdata, StringBuilder[] attnames, StringBuilder[] attvals) {
        return this.customFactory.elementInstance(name, cdata, attnames, attvals);
    }

    public void startElement(StringBuilder name, StringBuilder[] attr_names, StringBuilder[] attr_values) {
        log.finest("Start element name: " + name);
        log.finest("Element attributes names: " + Arrays.toString(attr_names));
        log.finest("Element attributes values: " + Arrays.toString(attr_values));
        String tmp_name = name.toString();
        Element elem = this.newElement(tmp_name, null, attr_names, attr_values);
        String ns = elem.getXMLNS();
        if (ns == null) {
            elem.setDefXMLNS(this.def_xmlns);
        } else {
            this.def_xmlns = ns;
        }
        this.el_stack.push(elem);
        if (tmp_name.equals(ELEM_STREAM_STREAM)) {
            this.top_xmlns = elem.getXMLNS();
            this.endElement(name);
        }
    }

    public void elementCData(StringBuilder cdata) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Element CDATA: " + cdata);
        }
        try {
            this.el_stack.peek().setCData(cdata.toString());
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public void endElement(StringBuilder name) {
        log.finest("End element name: " + name);
        if (this.el_stack.isEmpty()) {
            this.el_stack.push(this.newElement(name.toString(), null, null, null));
        }
        Element elem = this.el_stack.pop();
        if (this.el_stack.isEmpty()) {
            this.all_roots.offer(elem);
            this.def_xmlns = this.top_xmlns;
            log.finest("Adding new request: " + elem.toString());
        } else {
            this.el_stack.peek().addChild((XMLNodeIfc)elem);
        }
    }

    public void otherXML(StringBuilder other) {
        log.finest("Other XML content: " + other);
    }

    public void saveParserState(Object state) {
        this.parserState = state;
    }

    public Object restoreParserState() {
        return this.parserState;
    }
}

