/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.impl;

import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.test.ResultCode;
import tigase.test.TestEmpty;
import tigase.test.util.ElementUtil;
import tigase.test.util.EqualError;
import tigase.test.util.Params;
import tigase.test.util.ScriptFileLoader;
import tigase.test.util.TestUtil;
import tigase.test.util.XMLIO;
import tigase.util.JIDUtils;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class TestCommon
extends TestEmpty {
    private static final Logger log = Logger.getLogger(TestCommon.class.getName());
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    protected Exception exception = null;
    protected Params params = null;
    protected Map<String, String> vars = null;
    private String cdata = "";
    private String error_message = "";
    private String hostname = "localhost";
    private String id = null;
    private String jid = null;
    private long repeat = 0L;
    private String source_file = "tests/data/sample-file.cot";
    private Queue<ScriptFileLoader.StanzaEntry> stanzas_buff = null;
    private String to = "test_user@localhost";
    private String user_emil = "test_user@localhost";
    private String user_name = "test_user@localhost";
    private String user_resr = "xmpp-test";
    private Pattern p = Pattern.compile(".*@\\{([^}]+)\\}.*");
    private boolean initial_presence = false;
    private boolean fullExceptionStack = false;
    private List<Element> all_results = new ArrayList<Element>();
    protected boolean timeoutOk = false;
    protected ResultCode resultCode = ResultCode.TEST_OK;
    private ScriptFileLoader scriptFileLoader;

    public TestCommon() {
        super(new String[]{"jabber:client"}, new String[]{"common"}, new String[]{"stream-open", "auth", "xmpp-bind"}, new String[]{"tls-init"});
    }

    public TestCommon(String[] ns, String[] imp, String[] depend, String[] opt) {
        super(ns, imp, depend, opt);
    }

    private static Element[] parseXMLData(String data) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        parser.parse((SimpleHandler)domHandler, data.toCharArray(), 0, data.length());
        Queue elems = domHandler.getParsedElements();
        if (elems != null && elems.size() > 0) {
            return elems.toArray(new Element[elems.size()]);
        }
        return null;
    }

    @Override
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    public String getResultMessage() {
        switch (this.resultCode) {
            case PROCESSING_EXCEPTION: {
                if (this.fullExceptionStack) {
                    return this.getClass().getName() + ", " + this.resultCode.getMessage() + this.exception.toString() + "\n" + TestUtil.stack2String(this.exception) + this.error_message;
                }
                return this.getClass().getName() + ", " + this.exception.getMessage() + this.error_message;
            }
        }
        return this.resultCode.getMessage() + ", " + this.error_message;
    }

    @Override
    public void init(Params params, Map<String, String> vars) {
        super.init(params, vars);
        this.params = params;
        this.vars = vars;
        if (this.stanzas_buff == null) {
            this.user_name = params.get("-user-name", this.user_name);
            this.user_resr = params.get("-user-resr", this.user_resr);
            this.user_emil = params.get("-user-emil", this.user_emil);
            this.hostname = params.get("-host", this.hostname);
            this.cdata = params.get("-cdata", this.cdata);
            this.initial_presence = params.get("-initial-presence", this.initial_presence);
            String name = JIDUtils.getNodeNick((String)this.user_name);
            if (name == null || name.equals("")) {
                this.jid = this.user_name + "@" + this.hostname + "/" + this.user_resr;
                this.id = this.user_name + "@" + this.hostname;
            } else {
                this.jid = this.user_name + "/" + this.user_resr;
                this.id = this.user_name;
            }
            this.to = params.get("-to-jid", this.to);
            this.timeoutOk = params.containsKey("-time-out-ok");
            this.fullExceptionStack = params.containsKey("-full-stack-trace");
            this.source_file = params.get("-source-file", this.source_file);
            this.stanzas_buff = new LinkedList<ScriptFileLoader.StanzaEntry>();
            String number = params.get("-number", "");
            HashMap<String, String> replaces = new HashMap<String, String>();
            replaces.put("$(from-jid)", this.jid);
            replaces.put("$(from-id)", this.id);
            replaces.put("$(to-jid)", this.to);
            replaces.put("$(to-id)", JIDUtils.getNodeID((String)this.to));
            replaces.put("$(to-hostname)", JIDUtils.getNodeHost((String)this.to));
            replaces.put("$(hostname)", this.hostname);
            replaces.put("$(number)", number);
            replaces.put("$(cdata)", this.cdata);
            this.scriptFileLoader = new ScriptFileLoader(this.source_file, this.stanzas_buff, replaces);
            this.scriptFileLoader.loadSourceFile();
        }
    }

    @Override
    public void release() {
        try {
            XMLIO io = (XMLIO)this.params.get("socketxmlio");
            io.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean run() {
        try {
            if (this.repeat == 0L && this.initial_presence) {
                XMLIO io = (XMLIO)this.params.get("socketxmlio");
                String toWrite = "<presence/>";
                this.debug("\nSending: " + toWrite);
                this.addOutput(toWrite);
                io.write(toWrite);
            }
            ++this.repeat;
            LinkedList<ScriptFileLoader.StanzaEntry> stanzas = new LinkedList<ScriptFileLoader.StanzaEntry>(this.stanzas_buff);
            ScriptFileLoader.StanzaEntry entry = null;
            block7: while ((entry = (ScriptFileLoader.StanzaEntry)stanzas.poll()) != null) {
                XMLIO io = (XMLIO)this.params.get("socketxmlio");
                if (io == null) {
                    this.resultCode = ResultCode.SOCKET_NOT_INITALIZED;
                    return false;
                }
                switch (entry.getAction()) {
                    case send: {
                        for (Element elem : entry.getStanza()) {
                            if (elem.getAttributeStaticStr("id") == null) {
                                elem.setAttribute("id", "" + this.repeat);
                            }
                            String toWrite = this.applyParams(elem.toString());
                            this.debug("\nSending: " + toWrite);
                            this.addOutput(toWrite);
                            io.write(toWrite);
                        }
                        continue block7;
                    }
                    case expect: {
                        boolean found = false;
                        Queue<Element> results = null;
                        this.error_message = "\n" + this.repeat + ": Expected: " + Arrays.toString(entry.getStanza());
                        while (this.all_results.size() == 0 && (results == null || results.size() == 0)) {
                            results = io.read();
                        }
                        if (results != null) {
                            for (Element el : results) {
                                this.debug("\nReceived: " + el.toString());
                                this.addInput(el.toString());
                            }
                            this.all_results.addAll(results);
                            results.clear();
                        }
                        String eq_msg = "";
                        block11: for (int exp = 0; exp < entry.getStanza().length && !found; ++exp) {
                            for (int idx = 0; idx < this.all_results.size(); ++idx) {
                                Element lastReceived = this.all_results.get(idx);
                                EqualError res = ElementUtil.equalElemsDeep(entry.getStanza()[exp], lastReceived, stanza_variables);
                                found = res.equals;
                                eq_msg = eq_msg + (found ? "" : res.message + "\n");
                                if (!found) continue;
                                this.all_results.remove(idx);
                                continue block11;
                            }
                        }
                        if (found) break;
                        this.resultCode = ResultCode.RESULT_DOESNT_MATCH;
                        this.error_message = "\n" + this.repeat + ": Expected one of: " + Arrays.toString(entry.getStanza()) + ", received: " + Arrays.toString(this.all_results.toArray(new Element[0])) + "\n equals error message: " + eq_msg;
                        return false;
                    }
                }
            }
        }
        catch (SocketTimeoutException e) {
            if (this.timeoutOk) {
                return true;
            }
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            this.addInput("" + this.repeat + ": " + this.getClass().getName() + ", " + e.getMessage() + this.error_message);
            return false;
        }
        catch (Exception e) {
            this.addInput("" + this.repeat + ": " + this.getClass().getName() + ", " + e + "\n" + TestUtil.stack2String(e) + this.error_message);
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String applyParams(String input) {
        String newVal;
        String result = input;
        for (String key : this.vars.keySet()) {
            while (result.contains(key)) {
                newVal = this.vars.get(key);
                if (newVal != null && newVal.startsWith("\"") && newVal.endsWith("\"")) {
                    newVal = newVal.substring(1, newVal.length() - 1);
                }
                result = result.replace(key, newVal);
            }
        }
        block2: for (String key : stanza_variables.keySet()) {
            while (result.contains(key)) {
                newVal = (String)stanza_variables.get(key);
                if (newVal != null && newVal.startsWith("\"") && newVal.endsWith("\"")) {
                    newVal = newVal.substring(1, newVal.length() - 1);
                }
                if (newVal == null) continue block2;
                result = result.replace(key, newVal);
            }
        }
        return result;
    }
}

