/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.impl;

import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.management.Attribute;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import tigase.test.TestAbstract;
import tigase.test.util.Params;
import tigase.test.util.SocketXMLIO;
import tigase.xml.Element;

public class TestTLS
extends TestAbstract {
    private int counter = 0;
    private String[] elems = new String[]{"starttls", "stream:stream"};
    private String hostname = "localhost";
    private String keys_file = "certs/keystore";
    private String keys_password = "keystore";
    private int socket_wait = 5000;
    private String trusts_file = "certs/truststore";
    private String trusts_password = "truststore";

    public TestTLS() {
        super(new String[]{"jabber:client", "jabber:server", "jabber:component:accept"}, new String[]{"tls-init"}, new String[]{"socket", "stream-open"}, null);
        try {
            this.getSSLSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private SSLSocketFactory getSSLSocketFactory() throws Exception {
        SecureRandom sr = new SecureRandom();
        sr.nextInt();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new X509TrustManager[]{new FakeTrustManager()}, sr);
        return sslContext.getSocketFactory();
    }

    private Socket initSSLSocket(Socket socket) throws Exception {
        SSLSocketFactory factory = this.getSSLSocketFactory();
        socket.setSoTimeout(this.socket_wait);
        SSLSocket tlsClient = (SSLSocket)factory.createSocket(socket, socket.getInetAddress().getHostAddress(), socket.getPort(), true);
        tlsClient.setUseClientMode(true);
        tlsClient.startHandshake();
        return tlsClient;
    }

    @Override
    public void init(Params params, Map<String, String> vars) {
        super.init(params, vars);
        this.hostname = params.get("-host", this.hostname);
        this.keys_password = params.get("-keys-file-password", this.keys_password);
        this.trusts_password = params.get("-trusts-file-password", this.trusts_password);
        this.keys_file = params.get("-keys-file", this.keys_file);
        this.trusts_file = params.get("-trusts-file", this.trusts_file);
        this.socket_wait = params.get("-socket-wait", this.socket_wait);
    }

    @Override
    public String nextElementName(Element reply) throws Exception {
        if (this.counter < this.elems.length) {
            String elem;
            if ((elem = this.elems[this.counter++]).equals("stream:stream")) {
                Socket sock = this.initSSLSocket((Socket)this.params.get("socket"));
                this.params.put("socket", (Object)sock);
                this.params.put("socketxmlio", (Object)new SocketXMLIO(sock));
            }
            return elem;
        }
        return null;
    }

    @Override
    public String getElementData(String element) {
        if (element.equals("starttls")) {
            return "<starttls xmlns='urn:ietf:params:xml:ns:xmpp-tls'/>";
        }
        if (element.equals("stream:stream")) {
            return "<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' to='" + this.hostname + "' " + "version='1.0'>";
        }
        return null;
    }

    @Override
    public String[] getRespElementNames(String element) {
        if (element.equals("starttls")) {
            return new String[]{"proceed"};
        }
        if (element.equals("stream:stream")) {
            return new String[]{"stream:stream", "stream:features"};
        }
        return null;
    }

    @Override
    public Attribute[] getRespElementAttributes(String element) {
        if (element.equals("proceed")) {
            return new Attribute[]{new Attribute("xmlns", "urn:ietf:params:xml:ns:xmpp-tls")};
        }
        if (element.equals("stream:stream")) {
            return new Attribute[]{new Attribute("xmlns", "jabber:client"), new Attribute("xmlns:stream", "http://etherx.jabber.org/streams"), new Attribute("from", this.hostname), new Attribute("version", "1.0")};
        }
        if (element.equals("stream:features")) {
            return new Attribute[0];
        }
        return null;
    }

    @Override
    public String[] getRespOptionalNames(String element) {
        return null;
    }

    class FakeTrustManager
    implements X509TrustManager {
        private X509Certificate[] acceptedIssuers = null;

        public FakeTrustManager() {
        }

        public FakeTrustManager(X509Certificate[] ai) {
            this.acceptedIssuers = ai;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.acceptedIssuers;
        }
    }
}

