/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.util;

import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import tigase.test.util.SocketXMLIO;
import tigase.xml.Element;

public class SocketBosh
extends SocketXMLIO {
    private static final int BUFF_SIZE = 2048;
    private static long new_socket = 0L;
    private String authId = null;
    private long rid = 1216L;
    private String sid = null;
    private boolean restart = false;
    private boolean terminate = false;
    private boolean reinitialized = false;
    private boolean keep_alive = false;

    public SocketBosh(Socket sock) throws IOException {
        super(sock);
    }

    public void setKeepAlive(boolean keep_alive) {
        this.keep_alive = keep_alive;
    }

    @Override
    public void write(String data) throws IOException {
        if (data != null && data.startsWith("<stream:stream")) {
            this.restart = true;
            this.initSocket(null);
        } else {
            this.initSocket(data);
        }
    }

    @Override
    public Queue<Element> read() throws IOException {
        if (!this.reinitialized) {
            this.initSocket(null);
        }
        LinkedList<Element> results = new LinkedList<Element>();
        try {
            Queue<Element> elements = super.read();
            if (elements != null) {
                results = new LinkedList();
                Element body = null;
                while ((body = elements.poll()) != null) {
                    if (body.getName() == "body") {
                        this.reinitialized = false;
                        String temp = body.getAttributeStaticStr("sid");
                        if (temp != null) {
                            this.sid = temp;
                        }
                        if ((temp = body.getAttributeStaticStr("authid")) != null) {
                            this.authId = temp;
                        }
                        if (body.getChildren() == null) continue;
                        results.addAll(body.getChildren());
                        continue;
                    }
                    results.offer(body);
                }
            }
        }
        catch (EOFException e) {
            this.initSocket(null);
        }
        catch (SocketException e) {
            this.initSocket(null);
        }
        if (this.ignore_presence) {
            Iterator it = results.iterator();
            int counter = 0;
            while (it.hasNext()) {
                Element el = (Element)it.next();
                if (el.getName() != "presence") continue;
                it.remove();
                ++counter;
            }
            if (counter > 0) {
                // empty if block
            }
        }
        return results;
    }

    @Override
    public void close() {
        this.terminate = true;
        try {
            this.initSocket(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initSocket(String data) throws IOException {
        if (!this.keep_alive || !this.isConnected()) {
            Socket client = new Socket();
            client.setReuseAddress(true);
            client.setSoTimeout(this.socket.getSoTimeout());
            client.setReceiveBufferSize(2048);
            client.connect(this.socket.getRemoteSocketAddress(), this.socket.getSoTimeout());
            this.setSocket(client);
            this.reinitialized = true;
        }
        if (data != null && data.startsWith("<body")) {
            super.write(data);
        } else {
            if (this.sid != null) {
                Element body = new Element("body", data, new String[]{"xmlns", "sid", "rid"}, new String[]{"http://jabber.org/protocol/httpbind", this.sid, "" + ++this.rid});
                if (this.restart) {
                    body.setAttribute("xmpp:restart", "true");
                    this.restart = false;
                }
                if (this.terminate) {
                    body.setAttribute("type", "terminate");
                }
                super.write(body.toString());
            }
            if (this.terminate) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                super.close();
            }
        }
    }
}

