/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import tigase.test.util.Params;
import tigase.test.util.ParserHandler;

public class ScriptParser {
    private static final int BUFF_SIZE = 65536;
    private static final String[] KEYWORDS = new String[]{"$(loop)", "$(self)", "$(daemons)"};
    private String scriptName = null;
    private ParserHandler hand = null;
    private StringBuilder test_name = null;
    private StringBuilder params = null;
    private StringBuilder descr = null;
    private Map<String, String> vars = new TreeMap<String, String>();
    private StringBuilder var_name = null;
    private StringBuilder var_value = null;
    private StringBuilder var_sep = null;
    private boolean keyword_error = false;
    private boolean equals_found = false;

    protected void error(int line, int pos, String msg) {
        System.err.println("Test script syntax error:\nLine: " + line + ", position: " + pos + ", " + msg);
    }

    public ScriptParser(String script, ParserHandler handler) {
        this.scriptName = script;
        this.hand = handler;
    }

    public void parseScript() throws IOException {
        State state = State.TEST_NAME;
        State tmp_state = State.TEST_NAME;
        this.test_name = new StringBuilder();
        BufferedReader script = new BufferedReader(new FileReader(this.scriptName));
        char[] buff = new char[65536];
        int res = 0;
        int line = 0;
        int line_pos = 0;
        while ((res = script.read(buff)) != -1) {
            block35: for (int i = 0; i < res; ++i) {
                if (buff[i] == '\r') continue;
                if (buff[i] == '\n') {
                    ++line;
                    line_pos = 0;
                }
                ++line_pos;
                switch (state) {
                    case TEST_NAME: {
                        switch (buff[i]) {
                            case ':': {
                                this.hand.handleTestName(this.replaceAll(this.test_name).trim());
                                this.test_name = new StringBuilder();
                                continue block35;
                            }
                            case '{': {
                                state = State.PARAMS;
                                this.params = new StringBuilder();
                                continue block35;
                            }
                            case '}': {
                                this.error(line, line_pos, "found '}' before '{'");
                                continue block35;
                            }
                            case '#': {
                                tmp_state = state;
                                state = State.COMMENT;
                                continue block35;
                            }
                            case '>': {
                                state = State.DESCR_START;
                                continue block35;
                            }
                            case '<': {
                                this.error(line, line_pos, "found '<' before '>>'");
                                continue block35;
                            }
                            case '\n': {
                                continue block35;
                            }
                        }
                        this.test_name.append(buff[i]);
                        continue block35;
                    }
                    case COMMENT: {
                        if (buff[i] != '\n') continue block35;
                        state = tmp_state;
                        continue block35;
                    }
                    case DESCR_START: {
                        if (buff[i] == '>') {
                            state = State.DESCRIPTION;
                            this.descr = new StringBuilder();
                            continue block35;
                        }
                        this.error(line, line_pos, "second '>' must follow first '>' to start test description.");
                        state = State.TEST_NAME;
                        continue block35;
                    }
                    case DESCRIPTION: {
                        if (buff[i] == '<') {
                            this.hand.handleTestDescription(this.replaceAll(this.descr).trim());
                            state = State.DESCR_END;
                            continue block35;
                        }
                        this.descr.append(buff[i]);
                        continue block35;
                    }
                    case DESCR_END: {
                        if (buff[i] != '<') {
                            this.error(line, line_pos, "second '<' must follow first '<' to end test description.");
                        }
                        state = State.TEST_NAME;
                        continue block35;
                    }
                    case PARAMS: {
                        switch (buff[i]) {
                            case '}': {
                                this.hand.handleTestParams(new Params(this.replaceAll(this.params).trim()));
                                state = State.TEST_NAME;
                                continue block35;
                            }
                            case '#': {
                                tmp_state = state;
                                state = State.COMMENT;
                                continue block35;
                            }
                            case '$': {
                                state = State.VAR_NAME;
                                this.var_name = new StringBuilder();
                                this.var_name.append('$');
                                continue block35;
                            }
                        }
                        this.params.append(buff[i]);
                        continue block35;
                    }
                    case VAR_NAME: {
                        switch (buff[i]) {
                            case ')': {
                                this.var_name.append(buff[i]);
                                this.keyword_error = false;
                                for (String key : KEYWORDS) {
                                    if (!key.equals(this.var_name.toString())) continue;
                                    this.keyword_error = true;
                                    break;
                                }
                                state = State.VAR_SEPARATORS;
                                this.var_sep = new StringBuilder();
                                this.var_value = new StringBuilder();
                                this.equals_found = false;
                                continue block35;
                            }
                        }
                        this.var_name.append(buff[i]);
                        continue block35;
                    }
                    case VAR_SEPARATORS: {
                        switch (buff[i]) {
                            case '=': {
                                this.equals_found = true;
                                if (!this.keyword_error) continue block35;
                                this.error(line, line_pos, "KEY_WORD: " + this.var_name.toString() + ", used as variable name, ignored.");
                                continue block35;
                            }
                            case '}': {
                                state = State.TEST_NAME;
                                this.params.append((CharSequence)this.var_name);
                                this.hand.handleTestParams(new Params(this.replaceAll(this.params).trim()));
                                continue block35;
                            }
                            case '$': {
                                state = State.VAR_NAME;
                                this.params.append((CharSequence)this.var_name);
                                this.params.append((CharSequence)this.var_sep);
                                this.var_name = new StringBuilder();
                                this.var_name.append('$');
                                continue block35;
                            }
                            case '#': {
                                this.params.append((CharSequence)this.var_name);
                                this.params.append((CharSequence)this.var_sep);
                                tmp_state = State.PARAMS;
                                state = State.COMMENT;
                                continue block35;
                            }
                        }
                        if (Character.isWhitespace(buff[i])) {
                            this.var_sep.append(buff[i]);
                            continue block35;
                        }
                        if (this.equals_found) {
                            state = State.VAR_VALUE;
                            this.var_value.append(buff[i]);
                            continue block35;
                        }
                        state = State.PARAMS;
                        this.params.append((CharSequence)this.var_name);
                        this.params.append((CharSequence)this.var_sep);
                        this.params.append(buff[i]);
                        continue block35;
                    }
                    case VAR_VALUE: {
                        if (Character.isWhitespace(buff[i])) {
                            state = State.PARAMS;
                            this.vars.put(this.var_name.toString(), this.var_value.toString());
                            continue block35;
                        }
                        this.var_value.append(buff[i]);
                        continue block35;
                    }
                }
            }
        }
        this.hand.handleScriptEnd();
    }

    private String replaceAll(StringBuilder source) {
        String result = source.toString();
        for (String key : this.vars.keySet()) {
            while (result.contains(key)) {
                result = result.replace(key, this.vars.get(key));
            }
        }
        return result;
    }

    public static enum State {
        START,
        COMMENT,
        DESCR_START,
        DESCR_END,
        DESCRIPTION,
        PARAMS,
        VAR_NAME,
        VAR_VALUE,
        VAR_SEPARATORS,
        TEST_NAME;

    }
}

