/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.impl;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import tigase.test.TestAbstract;
import tigase.test.util.Params;
import tigase.util.Base64;
import tigase.xml.Element;

public class TestSASL
extends TestAbstract {
    private String data = null;
    private String hostname = "localhost";
    private String response = null;
    private SaslClient sasl = null;
    private String user_name = "test_user@localhost";
    private String user_pass = "test_pass";
    private String user_resr = "xmpp-test";
    private boolean bosh_mode = false;

    public TestSASL() {
        super(new String[]{"jabber:client", "jabber:server", "jabber:component:accept"}, new String[]{"auth-sasl"}, new String[]{"stream-open"}, new String[]{"tls-init", "user-register"});
    }

    @Override
    public String nextElementName(Element reply) throws Exception {
        if (reply == null) {
            this.response = "challenge";
            Set mechs = (Set)this.params.get("features");
            if (mechs == null) {
                this.data = "<auth xmlns='urn:ietf:params:xml:ns:xmpp-sasl' mechanism='CRAP-NO-MECHS-IN-FEATURES'/>";
            } else if (mechs.contains("DIGEST-MD5")) {
                this.data = "<auth xmlns='urn:ietf:params:xml:ns:xmpp-sasl' mechanism='DIGEST-MD5'/>";
            } else if (mechs.contains("PLAIN")) {
                this.data = "<auth xmlns='urn:ietf:params:xml:ns:xmpp-sasl' mechanism='PLAIN'>";
                this.data = this.data + Base64.encode((byte[])new String("\u0000" + this.user_name + "\u0000" + this.user_pass).getBytes());
                this.data = this.data + "</auth>";
                this.response = "success";
            } else {
                this.data = "<auth xmlns='urn:ietf:params:xml:ns:xmpp-sasl' mechanism='CRAP-NO-KNOWN-MECHS'/>";
            }
            return "auth";
        }
        String rname = reply.getName();
        if (rname.equals("challenge")) {
            if (this.sasl == null) {
                TreeMap<String, String> props = new TreeMap<String, String>();
                props.put("javax.security.sasl.qop", "auth");
                this.sasl = Sasl.createSaslClient(new String[]{"DIGEST-MD5", "CRAM-MD5", "GSSAPI", "PLAIN"}, this.user_name, "xmpp", this.hostname, props, new AuthCallbackHandler());
            }
            byte[] chall = Base64.decode((String)reply.getChildCDataStaticStr(CHALLENGE_PATH));
            byte[] resp = this.sasl.evaluateChallenge(chall);
            if (this.sasl.isComplete()) {
                this.data = "<response xmlns='urn:ietf:params:xml:ns:xmpp-sasl'/>";
                this.response = "success";
            } else {
                this.data = "<response xmlns='urn:ietf:params:xml:ns:xmpp-sasl'>" + Base64.encode((byte[])resp) + "</response>";
                this.response = "challenge";
            }
            return "response";
        }
        if (reply.getName().equals("success")) {
            this.params.put("authorized", (Object)true);
            this.data = "<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' to='" + this.hostname + "' " + "version='1.0'>";
            return "stream:stream";
        }
        return null;
    }

    @Override
    public String[] getRespOptionalNames(String element) {
        if (element.equals("response")) {
            return new String[]{"success", "challenge"};
        }
        return null;
    }

    @Override
    public String getElementData(String element) {
        return this.data;
    }

    @Override
    public String[] getRespElementNames(String element) {
        if (element.equals("stream:stream")) {
            if (this.bosh_mode) {
                return new String[]{"stream:features"};
            }
            return new String[]{"stream:stream", "stream:features"};
        }
        return new String[]{this.response};
    }

    @Override
    public Attribute[] getRespElementAttributes(String element) {
        if (element.equals("stream:stream")) {
            return new Attribute[]{new Attribute("xmlns", "jabber:client"), new Attribute("xmlns:stream", "http://etherx.jabber.org/streams"), new Attribute("from", this.hostname), new Attribute("version", "1.0")};
        }
        if (element.equals("stream:features")) {
            return new Attribute[0];
        }
        return new Attribute[]{new Attribute("xmlns", "urn:ietf:params:xml:ns:xmpp-sasl")};
    }

    @Override
    public void init(Params map, Map<String, String> vars) {
        super.init(map, vars);
        this.user_name = this.params.get("-user-name", this.user_name);
        this.user_pass = this.params.get("-user-pass", this.user_pass);
        this.user_resr = this.params.get("-user-resr", this.user_resr);
        this.hostname = this.params.get("-host", this.hostname);
        this.bosh_mode = this.params.get("bosh-mode") != null;
    }

    private class AuthCallbackHandler
    implements CallbackHandler {
        private AuthCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            Object realm = null;
            Object name = null;
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof RealmCallback) {
                    ((RealmCallback)callbacks[i]).setText(TestSASL.this.hostname);
                    continue;
                }
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName(TestSASL.this.user_name);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).setPassword(TestSASL.this.user_pass.toCharArray());
                    continue;
                }
                if (callbacks[i] instanceof AuthorizeCallback) {
                    String authorId;
                    AuthorizeCallback authCallback = (AuthorizeCallback)callbacks[i];
                    String authenId = authCallback.getAuthenticationID();
                    if (!authenId.equals(authorId = authCallback.getAuthorizationID())) continue;
                    authCallback.setAuthorized(true);
                    authCallback.setAuthorizedID(authorId);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }
}

