/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.impl;

import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.Queue;
import javax.management.Attribute;
import tigase.test.ResultCode;
import tigase.test.TestAbstract;
import tigase.test.util.Params;
import tigase.test.util.TestUtil;
import tigase.test.util.XMLIO;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public class TestReceiveMessage
extends TestAbstract {
    private String data = null;
    private String hostname = "localhost";
    private String jid = null;
    private String msg_1 = null;
    private String msg_2 = null;
    private long repeat = 0L;
    private Attribute[] resp_attribs = null;
    private String user_name = "test_user@localhost";
    private String user_resr = "xmpp-test";

    public TestReceiveMessage() {
        super(new String[]{"jabber:client"}, new String[]{"msg-listen"}, new String[]{"stream-open", "auth", "xmpp-bind"}, new String[]{"tls-init", "privacy-block-msg", "privacy-long-list"});
    }

    @Override
    public String nextElementName(Element element) throws Exception {
        if (element == null || element.getAttributeStaticStr("type").equals("error") && element.getAttributeStaticStr("code").equals("503")) {
            TestUtil.addDaemonJID(this.jid, (Socket)this.params.get("socket"));
            this.data = null;
            return "";
        }
        this.data = "<message type='chat' from='" + this.jid + "' to='" + element.getAttributeStaticStr("from") + "'><body>Message OK</body>" + "</message>";
        return "message";
    }

    @Override
    public String getElementData(String string) throws Exception {
        return this.data;
    }

    @Override
    public String[] getRespElementNames(String string) throws Exception {
        return new String[]{"message"};
    }

    @Override
    public String[] getRespOptionalNames(String string) throws Exception {
        return null;
    }

    @Override
    public Attribute[] getRespElementAttributes(String string) throws Exception {
        return this.resp_attribs;
    }

    @Override
    public void init(Params params, Map<String, String> vars) {
        super.init(params, vars);
        this.user_name = params.get("-user-name", this.user_name);
        this.hostname = params.get("-host", this.hostname);
        this.user_resr = params.get("-user-resr", this.user_resr);
        this.repeat = params.get("-messages", -1);
        String name = JIDUtils.getNodeNick((String)this.user_name);
        this.jid = name == null || name.equals("") ? this.user_name + "@" + this.hostname + "/" + this.user_resr : this.user_name + "/" + this.user_resr;
        this.msg_1 = "<message type='chat' from='" + this.jid + "' to='";
        this.msg_2 = "'><body>Message OK</body></message>";
    }

    @Override
    public boolean run() {
        try {
            String elem = null;
            XMLIO io = (XMLIO)this.params.get("socketxmlio");
            if (io == null) {
                TestUtil.removeDaemonJID(this.jid);
                this.resultCode = ResultCode.SOCKET_NOT_INITALIZED;
                System.out.println("Message listener FINISHED 1");
                return false;
            }
            elem = this.nextElementName(this.reply);
            while (elem != null && this.repeat-- != 0L) {
                this.debug("Processing element: " + elem + "\n");
                Queue<Element> results = io.read();
                Element rep = null;
                while ((rep = results.poll()) != null) {
                    this.reply = rep;
                    this.debug("Received data: " + this.reply.toString() + "\n");
                    elem = this.nextElementName(this.reply);
                    String data = this.getElementData(elem);
                    if (data == null || data.equals("")) continue;
                    io.write(data);
                    this.debug("Sent data: " + data + "\n");
                }
            }
            Thread.sleep(100L);
            TestUtil.removeDaemonJID(this.jid);
            return true;
        }
        catch (SocketTimeoutException e) {
            TestUtil.removeDaemonJID(this.jid);
            this.addInput("" + e + "\n" + TestUtil.stack2String(e));
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            return false;
        }
        catch (Exception e) {
            TestUtil.removeDaemonJID(this.jid);
            this.addInput("" + e + "\n" + TestUtil.stack2String(e));
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            return false;
        }
    }
}

