/*
 * Decompiled with CFR 0.152.
 */
package tigase.test;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tigase.test.Direction;
import tigase.test.HistoryCollectorIfc;
import tigase.test.HistoryEntry;
import tigase.test.ResultCode;
import tigase.test.TestIfc;
import tigase.test.util.Params;
import tigase.xml.Element;

public abstract class TestEmpty
implements TestIfc {
    protected static final Map<String, String> stanza_variables = new ConcurrentHashMap<String, String>(10, 0.25f, 2);
    private String[] BASE_XMLNS = null;
    private String[] DEPENDS = null;
    private String[] IMPLEMENTED = null;
    private String[] OPTIONAL = null;
    private boolean collectHistory = true;
    private boolean deb = false;
    private HistoryCollectorIfc historyColl = null;
    private String testName = null;

    public TestEmpty(String[] base_xmlns, String[] implemented, String[] depends, String[] optional) {
        this.BASE_XMLNS = base_xmlns;
        this.IMPLEMENTED = implemented;
        this.DEPENDS = depends;
        this.OPTIONAL = optional;
    }

    public void addInput(String input) {
        if (this.collectHistory) {
            this.historyColl.handleHistoryEntry(new HistoryEntry(Direction.INPUT, input, this.testName));
        }
    }

    public void addOutput(String output) {
        if (this.collectHistory) {
            this.historyColl.handleHistoryEntry(new HistoryEntry(Direction.OUTPUT, output, this.testName));
        }
    }

    @Override
    public String[] baseXMLNS() {
        return this.BASE_XMLNS;
    }

    public void debug(String msg) {
        if (this.deb) {
            System.out.print(msg);
            System.out.flush();
        }
    }

    @Override
    public String[] depends() {
        return this.DEPENDS;
    }

    @Override
    public Element getLastResult() {
        return null;
    }

    @Override
    public String getName() {
        return this.testName;
    }

    @Override
    public ResultCode getResultCode() {
        return ResultCode.TEST_OK;
    }

    @Override
    public String getResultMessage() {
        return null;
    }

    @Override
    public String[] implemented() {
        return this.IMPLEMENTED;
    }

    @Override
    public void init(Params params, Map<String, String> vars) {
        this.collectHistory = params.get("-output-history", true) && !params.containsKey("-daemon") && !params.containsKey("-background");
        this.deb = params.containsKey("-debug");
        String reset_stanza_vars = (String)params.get("-reset-stanza-vars");
        if (reset_stanza_vars != null) {
            String[] stanza_vars;
            for (String var : stanza_vars = reset_stanza_vars.split(",")) {
                stanza_variables.remove(var);
            }
        }
        for (Map.Entry<String, Object> param : params.entrySet()) {
            for (Map.Entry<String, String> stanza_var : stanza_variables.entrySet()) {
                if (param.getValue() == null || !param.getValue().toString().contains(stanza_var.getKey())) continue;
                String new_param_val = param.getValue().toString().replace(stanza_var.getKey(), stanza_var.getValue());
                param.setValue(new_param_val);
            }
        }
    }

    @Override
    public String[] optional() {
        return this.OPTIONAL;
    }

    @Override
    public boolean run() {
        return false;
    }

    @Override
    public void setHistoryCollector(HistoryCollectorIfc histColl) {
        this.historyColl = histColl;
    }

    @Override
    public void setName(String testName) {
        this.testName = testName;
    }
}

