/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.junit;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Attribute;
import org.junit.Assert;
import tigase.test.junit.JUnitXMLIO;
import tigase.test.util.EqualError;
import tigase.test.util.ScriptFileLoader;
import tigase.xml.Element;

public abstract class XMPPTestCase {
    private String configFile;

    public static EqualError equalElems(Element el1, Element el2) {
        String cdata1;
        if (!el1.getName().equals(el2.getName())) {
            return new EqualError(false, "Element names are different: " + el1.getName() + " and " + el2.getName());
        }
        Map attrs = el1.getAttributes();
        if (attrs != null) {
            for (String key : attrs.keySet()) {
                String atval2 = el2.getAttribute(key);
                if (atval2 == null) {
                    return new EqualError(false, "Element: " + el2.getName() + " missing attribute: " + key);
                }
                if (((String)attrs.get(key)).equals("*") || atval2.equals("*") || ((String)attrs.get(key)).equals(atval2)) continue;
                return new EqualError(false, "Element: " + el2.getName() + " different value for attribute: " + key + ", " + (String)attrs.get(key) + " != " + atval2);
            }
        }
        if ((cdata1 = el1.getCData()) != null && !cdata1.trim().isEmpty()) {
            String cdata2 = el2.getCData();
            if (cdata2 == null) {
                return new EqualError(false, "Missing CData for element: " + el2.getName() + ", expected: " + cdata1);
            }
            if (!cdata1.trim().equals(cdata2.trim())) {
                return new EqualError(false, "Different CData for element: " + el2.getName() + ", expected: " + cdata1 + ", found: " + cdata2);
            }
        }
        return new EqualError(true, null);
    }

    public static EqualError equalElemsDeep(Element el1, Element el2) {
        EqualError result = XMPPTestCase.equalElems(el1, el2);
        if (!result.equals) {
            return result;
        }
        List children = el1.getChildren();
        if (children == null) {
            return result;
        }
        for (Element child1 : children) {
            List children2 = el2.getChildren();
            if (children2 == null || children2.size() == 0) {
                return new EqualError(false, "Missing children for element: " + el1.getName());
            }
            boolean found_child = false;
            for (Element child2 : children2) {
                found_child |= XMPPTestCase.equalElemsDeep((Element)child1, (Element)child2).equals;
            }
            if (found_child) continue;
            return new EqualError(false, "Element: " + el2.getName() + ", missing child: " + child1.toString());
        }
        return result;
    }

    private static boolean equalsAll(Element[] expect, Set<String> params, Collection<Element> data) {
        if (!(expect != null && expect.length != 0 || data != null && data.size() != 0)) {
            return true;
        }
        if (expect == null || data == null) {
            return false;
        }
        boolean result = true;
        for (Element e : expect) {
            boolean found = false;
            for (Element d : data) {
                EqualError error = XMPPTestCase.equalElemsDeep(e, d);
                boolean tmpRes = error.equals;
                if (tmpRes && params.contains("equals")) {
                    EqualError error1 = XMPPTestCase.equalElemsDeep(d, e);
                    tmpRes &= error1.equals;
                }
                found |= tmpRes;
            }
            result &= found;
            if (found) continue;
            System.out.println("EQ :: not found  " + e);
        }
        return result;
    }

    private static EqualError equalsOneOf(Element[] expect, Set<String> params, Collection<Element> data) {
        EqualError rs = null;
        if (expect == null && data == null) {
            return new EqualError(false, "Null expected");
        }
        if (expect == null || data == null) {
            return new EqualError(false, "Result or expect data is null");
        }
        boolean result = false;
        for (Element d : data) {
            for (Element e : expect) {
                EqualError error = XMPPTestCase.equalElemsDeep(e, d);
                boolean tmpRes = error.equals;
                if (tmpRes && params.contains("equals")) {
                    EqualError error1 = XMPPTestCase.equalElemsDeep(d, e);
                    tmpRes &= error1.equals;
                }
                result |= tmpRes;
                if (tmpRes || rs != null) continue;
                rs = error;
            }
        }
        return result ? null : rs;
    }

    private static boolean equalsStrict(Element[] expect, Set<String> params, Collection<Element> data) {
        if (!(expect != null && expect.length != 0 || data != null && data.size() != 0)) {
            return true;
        }
        if (expect == null || data == null) {
            return false;
        }
        if (expect.length != data.size()) {
            return false;
        }
        boolean result = true;
        Iterator<Element> dataI = data.iterator();
        int c = 0;
        while (dataI.hasNext()) {
            Element e = expect[c++];
            Element d = dataI.next();
            EqualError error = XMPPTestCase.equalElemsDeep(e, d);
            if (params.contains("equals")) {
                EqualError error1 = XMPPTestCase.equalElemsDeep(d, e);
                result &= error1.equals;
            }
            result &= error.equals;
        }
        return result;
    }

    public static boolean hasAttributes(Element elem, Attribute[] attrs) {
        for (Attribute attr : attrs) {
            String val = elem.getAttribute(attr.getName());
            if (val == null) {
                return false;
            }
            if (val.equals(attr.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean isScriptValid(Collection<ScriptFileLoader.StanzaEntry> entries) {
        ScriptFileLoader.Action wantKind = ScriptFileLoader.Action.send;
        block3: for (ScriptFileLoader.StanzaEntry scriptEntry : entries) {
            if (wantKind != null && scriptEntry.getAction() != wantKind) {
                throw new RuntimeException("Invalid script for JUnit test! Expected " + (Object)((Object)wantKind));
            }
            if (wantKind == null && scriptEntry.getAction() == ScriptFileLoader.Action.send) {
                throw new RuntimeException("Invalid script for JUnit test! Expected not send element!");
            }
            if (scriptEntry.getAction() == ScriptFileLoader.Action.send && (scriptEntry.getStanza() == null || scriptEntry.getStanza().length != 1)) {
                throw new RuntimeException("Invalid script for JUnit test! send may have only one element!");
            }
            switch (scriptEntry.getAction()) {
                case send: {
                    wantKind = null;
                    continue block3;
                }
            }
            wantKind = ScriptFileLoader.Action.send;
        }
        return true;
    }

    public static void main(String[] args) {
        Pattern pattern = Pattern.compile("(^(.+)\\((.*)\\):.*)|(^(.+):.*)");
        Matcher m = pattern.matcher("send:{");
        boolean b = m.matches();
        if (b) {
            for (int i = 0; i <= m.groupCount(); ++i) {
                System.out.println(i + ": " + m.group(i));
            }
        }
        String keyword = m.group(2) == null ? m.group(5) : m.group(2);
        String param = m.group(3) == null ? null : m.group(3);
        System.out.println(keyword + "(" + param + ")");
    }

    public static void test(String configFile, JUnitXMLIO xmlio) {
        XMPPTestCase.test(configFile, xmlio, null);
    }

    public static void test(String configFile, JUnitXMLIO xmlio, Long wait) {
        try {
            if (configFile == null) {
                throw new RuntimeException("Script file must be specified.");
            }
            System.out.println("Loading script " + configFile);
            LinkedList<ScriptFileLoader.StanzaEntry> script = new LinkedList<ScriptFileLoader.StanzaEntry>();
            ScriptFileLoader scriptFileLoader = new ScriptFileLoader(configFile, script, null);
            scriptFileLoader.loadSourceFile();
            for (ScriptFileLoader.StanzaEntry scriptEntry : script) {
                Boolean ok = null;
                switch (scriptEntry.getAction()) {
                    case send: {
                        Element stanza = scriptEntry.getStanza()[0];
                        xmlio.read().clear();
                        System.out.print("Sending stanza" + (scriptEntry.getDescription() == null ? " <" + stanza.getName() + (stanza.getAttribute("id") == null ? "" : " id='" + stanza.getAttribute("id") + "'") + ">" : " (" + scriptEntry.getDescription() + ")") + "...  ");
                        xmlio.write(stanza);
                        if (wait == null) break;
                        Thread.sleep(wait);
                        break;
                    }
                    case expect: {
                        EqualError ee;
                        Queue<Element> read = xmlio.read();
                        System.out.print(" checking response... (" + read.size() + "/" + scriptEntry.getStanza().length + ") ");
                        if (scriptEntry.getParams().contains("stop")) {
                            System.out.println("!!!");
                        }
                        System.out.println((ee = XMPPTestCase.equalsOneOf(scriptEntry.getStanza(), scriptEntry.getParams(), read)) == null ? "OK" : "FAIL");
                        if (ee == null) break;
                        String error_message = (scriptEntry.getDescription() != null ? scriptEntry.getDescription() + " :: " : "") + "expected:\n" + Arrays.toString(scriptEntry.getStanza()) + "\nreceived: " + Arrays.toString(xmlio.read().toArray(new Element[0])) + "\nDescription: " + ee.message;
                        Assert.fail((String)error_message);
                        break;
                    }
                    case expect_all: {
                        Queue<Element> read = xmlio.read();
                        System.out.print(" checking response... (" + read.size() + "/" + scriptEntry.getStanza().length + ") ");
                        ok = XMPPTestCase.equalsAll(scriptEntry.getStanza(), scriptEntry.getParams(), read);
                        System.out.println(ok != false ? "OK" : "FAIL");
                        if (ok.booleanValue()) break;
                        String error_message = "Expected all of: " + Arrays.toString(scriptEntry.getStanza()) + ", received: " + Arrays.toString(xmlio.read().toArray(new Element[0]));
                        Assert.fail((String)error_message);
                        break;
                    }
                    case expect_strict: {
                        Queue<Element> read = xmlio.read();
                        System.out.print(" checking response... (" + read.size() + "/" + (scriptEntry.getStanza() == null ? 0 : scriptEntry.getStanza().length) + ") ");
                        ok = XMPPTestCase.equalsStrict(scriptEntry.getStanza(), scriptEntry.getParams(), read);
                        System.out.println(ok != false ? "OK" : "FAIL");
                        if (ok.booleanValue()) break;
                        String error_message = "Expected sequence: " + Arrays.toString(scriptEntry.getStanza()) + ", received: " + Arrays.toString(xmlio.read().toArray(new Element[0]));
                        Assert.fail((String)error_message);
                        break;
                    }
                }
                if (ok == null || ok.booleanValue()) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public XMPPTestCase() {
        this.configFile = null;
    }

    public XMPPTestCase(String sourceFile) {
        this.configFile = sourceFile;
    }

    public void test(JUnitXMLIO xmlio) {
        this.test(xmlio, null);
    }

    public void test(JUnitXMLIO xmlio, Long wait) {
        XMPPTestCase.test(this.configFile, xmlio, wait);
    }
}

