/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.impl;

import java.net.Socket;
import java.util.Map;
import java.util.TreeMap;
import javax.management.Attribute;
import tigase.test.TestAbstract;
import tigase.test.util.Params;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public class TestIQVersion
extends TestAbstract {
    private String hostname = "localhost";
    private String from = null;
    private String[] elems = new String[]{"iq"};
    private int counter = 0;

    public TestIQVersion() {
        super(new String[]{"jabber:client"}, new String[]{"iq-version"}, new String[]{"stream-open"}, new String[]{"stream-open", "auth", "user-register", "tls-init"});
    }

    @Override
    public String nextElementName(Element element) throws Exception {
        if (this.counter < this.elems.length) {
            return this.elems[this.counter++];
        }
        TreeMap<String, String> ver = new TreeMap<String, String>();
        ver.put("Name", element.getCData("/iq/query/name"));
        ver.put("Version", element.getCData("/iq/query/version"));
        ver.put("OS", element.getCData("/iq/query/os"));
        Socket socket = (Socket)this.params.get("socket");
        String remote = socket.getInetAddress().getHostAddress();
        String local = socket.getLocalAddress().getHostAddress();
        ver.put("Local IP", local);
        ver.put("Remote IP", remote);
        this.params.put("Version", (Object)ver);
        return null;
    }

    @Override
    public String getElementData(String string) throws Exception {
        switch (this.counter) {
            case 1: {
                return "<iq type='get' to='" + this.hostname + "' from='" + this.from + "' id='version_1'>" + "<query xmlns='jabber:iq:version'/>" + "</iq>";
            }
        }
        return null;
    }

    @Override
    public String[] getRespElementNames(String string) throws Exception {
        return new String[]{"iq"};
    }

    @Override
    public String[] getRespOptionalNames(String string) throws Exception {
        return null;
    }

    @Override
    public Attribute[] getRespElementAttributes(String string) throws Exception {
        switch (this.counter) {
            case 1: {
                return new Attribute[]{new Attribute("type", "result"), new Attribute("id", "version_1")};
            }
        }
        return null;
    }

    @Override
    public void init(Params map, Map<String, String> vars) {
        super.init(map, vars);
        this.hostname = this.params.get("-host", this.hostname);
        String user_name = this.params.get("-user-name", "test_user@localhost");
        String user_resr = this.params.get("-user-resr", "xmpp-test");
        String name = JIDUtils.getNodeNick((String)user_name);
        this.from = name == null || name.equals("") ? user_name + "@" + this.hostname + "/" + user_resr : user_name + "/" + user_resr;
    }
}

