/*
 * Decompiled with CFR 0.152.
 */
package tigase.test;

import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.management.Attribute;
import tigase.test.ResultCode;
import tigase.test.ResultsDontMatchException;
import tigase.test.TestEmpty;
import tigase.test.util.Params;
import tigase.test.util.TestUtil;
import tigase.test.util.XMLIO;
import tigase.xml.Element;

public abstract class TestAbstract
extends TestEmpty {
    private String error_message = "";
    protected Exception exception = null;
    protected Params params = null;
    protected Element reply = null;
    protected Map<String, String> vars = null;
    protected boolean timeoutOk = false;
    protected ResultCode resultCode = ResultCode.TEST_OK;
    private boolean fullExceptionStack = false;

    public TestAbstract(String[] base_xmlns, String[] implemented, String[] depends, String[] optional) {
        super(base_xmlns, implemented, depends, optional);
    }

    public abstract String getElementData(String var1) throws Exception;

    public abstract Attribute[] getRespElementAttributes(String var1) throws Exception;

    public abstract String[] getRespElementNames(String var1) throws Exception;

    public abstract String[] getRespOptionalNames(String var1) throws Exception;

    public abstract String nextElementName(Element var1) throws Exception;

    public static String substituteVars(String data, String[] vars, String[] vals) {
        String result = data;
        for (int i = 0; i < vars.length; ++i) {
            result = result.replace(vars[i], vals[i]);
        }
        return result;
    }

    @Override
    public Element getLastResult() {
        return this.reply;
    }

    @Override
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    public String getResultMessage() {
        switch (this.resultCode) {
            case PROCESSING_EXCEPTION: {
                if (this.fullExceptionStack) {
                    return this.getClass().getName() + ", " + this.getUserPasswordResource() + ", " + this.resultCode.getMessage() + this.exception.toString() + "\n" + TestUtil.stack2String(this.exception);
                }
                return this.getClass().getName() + ", " + this.getUserPasswordResource() + ", " + this.exception.getMessage();
            }
        }
        return this.getClass().getName() + ", " + this.getUserPasswordResource() + ", " + this.resultCode.getMessage() + ", " + this.error_message;
    }

    public boolean hasAttributes(Element elem, Attribute[] attrs) {
        this.debug("Checking elem: " + elem + " for attributes: " + Arrays.toString(attrs) + "\n");
        if (attrs != null) {
            for (Attribute attr : attrs) {
                String val = elem.getAttribute(attr.getName());
                if (val == null) {
                    this.debug("Value null for attribute: " + attr.getName());
                    return false;
                }
                if (val.equals(attr.getValue())) continue;
                this.debug("Values are not equal for attribute: " + attr.getName() + ", elem: " + val + ", attr.getValue(): " + attr.getValue());
                return false;
            }
        }
        return true;
    }

    @Override
    public void init(Params params, Map<String, String> vars) {
        super.init(params, vars);
        this.params = params;
        this.vars = vars;
        this.timeoutOk = params.containsKey("-time-out-ok");
        this.fullExceptionStack = params.containsKey("-full-stack-trace");
    }

    @Override
    public void release() {
        try {
            XMLIO io = (XMLIO)this.params.get("socketxmlio");
            io.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void replyElement(Element reply) throws Exception {
    }

    @Override
    public boolean run() {
        try {
            String elem = null;
            while ((elem = this.nextElementName(this.reply)) != null) {
                this.debug("Processing element: " + elem + "\n");
                XMLIO io = (XMLIO)this.params.get("socketxmlio");
                if (io == null) {
                    this.resultCode = ResultCode.SOCKET_NOT_INITALIZED;
                    return false;
                }
                String data = this.getElementData(elem);
                if (data != null && !data.equals("")) {
                    this.debug("Element data: " + data + "\n");
                    this.addOutput(data);
                    io.write(data);
                }
                String[] responses = this.getRespElementNames(elem);
                boolean[] resp_found = new boolean[responses.length];
                String[] optional_resp = this.getRespOptionalNames(elem);
                Arrays.fill(resp_found, false);
                int index = 0;
                while (!resp_found[resp_found.length - 1]) {
                    Queue<Element> results = io.read();
                    Element rep = null;
                    while (index < resp_found.length && (rep = results.poll()) != null) {
                        this.reply = rep;
                        if (this.reply.getName().equals("stream:features")) {
                            this.processStreamFeatures(this.reply);
                        }
                        this.replyElement(this.reply);
                        this.debug("Received: " + this.reply.toString() + "\n");
                        this.addInput(this.reply.toString());
                        resp_found[index] = this.checkResponse(this.reply, responses[index], optional_resp);
                        if (resp_found[index++]) continue;
                        this.resultCode = ResultCode.RESULT_DOESNT_MATCH;
                        return false;
                    }
                    if (results.size() <= 0) continue;
                    this.reply = results.poll();
                    if (this.reply.getName() == "stream:stream") continue;
                    this.debug("Too many results: " + this.reply);
                    this.resultCode = ResultCode.RESULT_DOESNT_MATCH;
                    return false;
                }
            }
            return true;
        }
        catch (SocketTimeoutException e) {
            if (this.timeoutOk) {
                return true;
            }
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            this.addInput(this.getClass().getName() + ", " + this.getUserPasswordResource() + ", " + e.getMessage());
            return false;
        }
        catch (ResultsDontMatchException e) {
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            this.addInput(this.getClass().getName() + ", " + this.getUserPasswordResource() + ", " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            this.addInput(this.getClass().getName() + ", " + this.getUserPasswordResource() + ", " + e + "\n" + TestUtil.stack2String(e));
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            System.out.println(Arrays.toString(this.implemented()));
            System.out.println(this.params.toString());
            return false;
        }
    }

    private boolean checkResponse(Element reply, String response, String[] optional_resp) throws Exception {
        this.debug("checking reply: " + reply + " with expected: " + response + "\n");
        if (reply.getName().equals(response) && this.hasAttributes(reply, this.getRespElementAttributes(response))) {
            return true;
        }
        if (optional_resp != null) {
            for (String opt : optional_resp) {
                if (!reply.getName().equals(opt) || !this.hasAttributes(reply, this.getRespElementAttributes(opt))) continue;
                return true;
            }
        }
        this.error_message = this.getClass().getName() + ", expected: '" + response + "', Received: '" + reply.toString() + "'";
        return false;
    }

    private String getUserPasswordResource() {
        String user_name = this.params.get("-user-name", null);
        String hostname = this.params.get("-host", null);
        String user_resr = this.params.get("-user-resr", null);
        String user_pass = this.params.get("-user-pass", null);
        String result = "";
        if (user_name != null) {
            result = result + user_name + "@";
        }
        if (hostname != null) {
            result = result + hostname;
        }
        if (user_resr != null) {
            result = result + "/" + user_resr;
        }
        if (user_pass != null) {
            result = result + "(" + user_pass + ")";
        }
        return result;
    }

    private void processStreamFeatures(Element features) {
        List children = features.getChildren("/stream:features/mechanisms");
        if (children != null && children.size() > 0) {
            HashSet<String> mechs = new HashSet<String>();
            for (Element child : children) {
                mechs.add(child.getCData());
            }
            this.params.put("features", (Object)mechs);
        }
    }
}

