/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.util;

import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import tigase.test.TestIfc;
import tigase.test.util.DependsComparator;
import tigase.test.util.Params;
import tigase.util.ClassUtil;

public class TestUtil {
    private static Set<TestIfc> all_tests = null;
    private static List<String> daemons_jids = new CopyOnWriteArrayList<String>();
    private static Map<String, Socket> daemons = new ConcurrentSkipListMap<String, Socket>();
    private static Queue<Socket> active_connections = new ConcurrentLinkedQueue<Socket>();
    private static Random rand = new Random(System.currentTimeMillis());
    private static int seq = 0;

    private TestUtil() {
    }

    public static void addActiveConnection(Socket conn) {
        active_connections.add(conn);
    }

    public static void addDaemonJID(String jid, Socket sock) {
        daemons_jids.add(jid);
        daemons.put(jid, sock);
    }

    public static boolean removeDaemonJID(String jid) {
        Socket soc = daemons.remove(jid);
        try {
            soc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return daemons_jids.remove(jid);
    }

    public static String getRandomJID() {
        String jid = null;
        while (jid == null && daemons_jids.size() > 0) {
            jid = daemons_jids.get(rand.nextInt(daemons_jids.size()));
            Socket sock = daemons.get(jid);
            if (sock.isConnected()) continue;
            TestUtil.removeDaemonJID(jid);
            jid = null;
        }
        return jid;
    }

    public static String getSeqJID() {
        String jid = null;
        if (seq + 1 >= daemons_jids.size()) {
            seq = 0;
            jid = daemons_jids.get(daemons_jids.size() - 1);
        } else {
            jid = daemons_jids.get(seq++);
        }
        Socket sock = daemons.get(jid);
        if (!sock.isConnected()) {
            TestUtil.removeDaemonJID(jid);
            jid = TestUtil.getSeqJID();
        }
        return jid;
    }

    public static Set<TestIfc> getTests() throws Exception {
        if (all_tests == null) {
            all_tests = ClassUtil.getImplementations(TestIfc.class);
        }
        return all_tests;
    }

    private static LinkedList<TestIfc> calculateDependsTree(String[] test_ns, List<TestIfc> tests, Params params) throws Exception {
        for (int i = 0; i < test_ns.length; ++i) {
            if (test_ns[i].equals("auth")) {
                test_ns[i] = params.get("-def-auth", "auth-sasl");
            }
            if (!test_ns[i].equals("stream-open")) continue;
            test_ns[i] = params.get("-def-stream", "stream-client");
        }
        LinkedList<TestIfc> result = new LinkedList<TestIfc>();
        ListIterator<TestIfc> it = tests.listIterator();
        block1: while (it.hasNext()) {
            TestIfc test = it.next();
            Object[] impl_ns = test.implemented();
            Arrays.sort(impl_ns);
            for (String ns : test_ns) {
                if (Arrays.binarySearch(impl_ns, ns) < 0) continue;
                result.add((TestIfc)test.getClass().newInstance());
                it.remove();
                continue block1;
            }
        }
        LinkedList<TestIfc> tmp = new LinkedList<TestIfc>();
        for (TestIfc test : result) {
            LinkedList<TestIfc> deps;
            if (test.depends() == null || (deps = TestUtil.calculateDependsTree(test.depends(), tests, params)) == null) continue;
            tmp.addAll(0, deps);
        }
        result.addAll(0, tmp);
        Collections.sort(result, DependsComparator.getInstance());
        return result;
    }

    public static LinkedList<TestIfc> getDependsTree(String[] test_ns, Params params) throws Exception {
        if (all_tests == null) {
            all_tests = ClassUtil.getImplementations(TestIfc.class);
        }
        LinkedList<TestIfc> result = TestUtil.calculateDependsTree(test_ns, new LinkedList<TestIfc>(all_tests), params);
        return result;
    }

    public static String toStringArrayNS(String[] arr, String delim) {
        StringBuilder sb = new StringBuilder();
        if (arr != null) {
            for (String ns : arr) {
                sb.append(" xmlns='" + ns + "'" + delim);
            }
        }
        return sb.toString();
    }

    public static String toStringCollNS(Collection<TestIfc> list) {
        LinkedList<String> elems = new LinkedList<String>();
        for (TestIfc test : list) {
            String[] xmlns = test.implemented();
            if (xmlns == null) continue;
            for (String ns : xmlns) {
                elems.add(ns);
            }
        }
        String[] arr = elems.toArray(new String[elems.size()]);
        return TestUtil.toStringArrayNS(arr, "\n");
    }

    public static void debug(String msg, boolean deb) {
        if (deb) {
            System.out.print(msg);
            System.out.flush();
        }
    }

    public static void debug(Exception exc, boolean deb) {
        if (deb && exc != null) {
            exc.printStackTrace();
        }
    }

    public static String stack2String(Exception exc) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement ste : exc.getStackTrace()) {
            sb.append(ste.toString() + "\n");
        }
        return sb.toString();
    }

    public static void displayStats(String user_name, long tests_ok, long tests_er, long total_time, long total_successful) {
        TestUtil.debug(user_name + ": Successful tests             : " + tests_ok + ", errors: " + tests_er + ".\n", true);
        TestUtil.debug(user_name + ": Total tests time             : " + total_time / 1000L + "sec.\n", true);
        TestUtil.debug(user_name + ": All successful tests time    : " + total_successful / 1000L + "sec.\n", true);
        if (tests_ok > 0L) {
            TestUtil.debug(user_name + ": Average successful test time : " + total_successful / tests_ok + "ms.\n\n", true);
        }
    }
}

