/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.util;

import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.Queue;
import tigase.test.util.SocketXMLIO;
import tigase.xml.Element;

public class SocketBosh
extends SocketXMLIO {
    private static final int BUFF_SIZE = 2048;
    private long rid = 1216L;
    private String sid = null;
    private String authId = null;
    private boolean restart = false;
    private boolean terminate = false;

    public SocketBosh(Socket sock) throws IOException {
        super(sock);
    }

    @Override
    public void write(String data) throws IOException {
        if (data != null && data.startsWith("<stream:stream")) {
            this.restart = true;
            this.initSocket(null);
        } else {
            this.initSocket(data);
        }
    }

    @Override
    public Queue<Element> read() throws IOException {
        LinkedList<Object> results = new LinkedList<Element>();
        try {
            Queue<Element> elements = super.read();
            if (elements != null) {
                results = new LinkedList();
                for (Element body : elements) {
                    if (body.getName() == "body") {
                        String temp = body.getAttribute("sid");
                        if (temp != null) {
                            this.sid = temp;
                        }
                        if ((temp = body.getAttribute("authid")) != null) {
                            this.authId = temp;
                        }
                        if (body.getChildren() == null) continue;
                        results.addAll(body.getChildren());
                        continue;
                    }
                    results.offer(body);
                }
            }
        }
        catch (EOFException e) {
            this.initSocket(null);
        }
        catch (SocketException e) {
            this.initSocket(null);
        }
        return results;
    }

    @Override
    public void close() {
        this.terminate = true;
        try {
            this.initSocket(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initSocket(String data) throws IOException {
        Socket client = new Socket();
        client.setReuseAddress(true);
        client.setSoTimeout(this.socket.getSoTimeout());
        client.setReceiveBufferSize(2048);
        client.connect(this.socket.getRemoteSocketAddress(), this.socket.getSoTimeout());
        this.setSocket(client);
        if (data != null && data.startsWith("<body")) {
            super.write(data);
        } else {
            Element body = new Element("body", data, new String[]{"xmlns", "sid", "rid"}, new String[]{"http://jabber.org/protocol/httpbind", this.sid, "" + ++this.rid});
            if (this.restart) {
                body.setAttribute("xmpp:restart", "true");
                this.restart = false;
            }
            if (this.terminate) {
                body.setAttribute("type", "terminate");
            }
            super.write(body.toString());
            if (this.terminate) {
                super.close();
            }
        }
    }
}

