/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.util;

import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import tigase.test.util.EqualError;
import tigase.xml.Element;

public class ElementUtil {
    public static boolean hasAttributes(Element elem, Attribute[] attrs) {
        for (Attribute attr : attrs) {
            String val = elem.getAttribute(attr.getName());
            if (val == null) {
                return false;
            }
            if (val.equals(attr.getValue())) continue;
            return false;
        }
        return true;
    }

    public static EqualError equalElems(Element el1, Element el2) {
        String cdata1;
        if (!el1.getName().equals(el2.getName())) {
            return new EqualError(false, "Element names are different: " + el1.getName() + " and " + el2.getName());
        }
        Map attrs = el1.getAttributes();
        if (attrs != null) {
            for (String key : attrs.keySet()) {
                String atval2 = el2.getAttribute(key);
                if (atval2 == null) {
                    return new EqualError(false, "Element: " + el2.getName() + " missing attribute: " + key);
                }
                if (((String)attrs.get(key)).equals(atval2)) continue;
                return new EqualError(false, "Element: " + el2.getName() + " different value for attribute: " + key + ", " + (String)attrs.get(key) + " != " + atval2);
            }
        }
        if ((cdata1 = el1.getCData()) != null && !cdata1.trim().isEmpty()) {
            String cdata2 = el2.getCData();
            if (cdata2 == null) {
                return new EqualError(false, "Missing CData for element: " + el2.getName() + ", expected: " + cdata1);
            }
            if (!cdata1.trim().equals(cdata2.trim())) {
                return new EqualError(false, "Different CData for element: " + el2.getName() + ", expected: " + cdata1 + ", found: " + cdata2);
            }
        }
        return new EqualError(true, null);
    }

    public static EqualError equalElemsDeep(Element el1, Element el2) {
        EqualError result = ElementUtil.equalElems(el1, el2);
        if (!result.equals) {
            return result;
        }
        List children = el1.getChildren();
        if (children == null) {
            return result;
        }
        for (Element child1 : children) {
            List children2 = el2.getChildren();
            if (children2 == null || children2.size() == 0) {
                return new EqualError(false, "Missing children for element: " + el1.getName());
            }
            boolean found_child = false;
            for (Element child2 : children2) {
                found_child |= ElementUtil.equalElemsDeep((Element)child1, (Element)child2).equals;
            }
            if (found_child) continue;
            return new EqualError(false, "Element: " + el2.getName() + ", missing child: " + child1.toString());
        }
        return result;
    }
}

