/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TestNode {
    private TestNode parent;
    private TestNode onError = null;
    private String name = null;
    private String id = null;
    private String shortDescr = null;
    private String longDescr = null;
    private List<TestNode> children = new LinkedList<TestNode>();
    private Map<String, String> vars = new TreeMap<String, String>();
    private Map<String, String> pars = new TreeMap<String, String>();

    public void setVars(Map<String, String> vars) {
        this.vars = new TreeMap<String, String>(vars);
    }

    public void addVars(Map<String, String> vars) {
        this.vars.putAll(vars);
    }

    public void addGlobalVars(Map<String, String> vars) {
        TreeMap<String, String> tmp = new TreeMap<String, String>(vars);
        tmp.putAll(this.vars);
        this.vars = tmp;
    }

    public Map<String, String> getVars() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (this.parent != null) {
            result.putAll(this.parent.getVars());
        }
        result.putAll(this.vars);
        return result;
    }

    public void setPars(Map<String, String> pars) {
        this.pars = new TreeMap<String, String>(pars);
    }

    public void addPars(Map<String, String> pars) {
        this.pars.putAll(pars);
    }

    public void addGlobalPars(Map<String, String> pars) {
        TreeMap<String, String> tmp = new TreeMap<String, String>(pars);
        tmp.putAll(this.pars);
        this.pars = tmp;
    }

    public Map<String, String> getPurePars() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (this.parent != null) {
            result.putAll(this.parent.getPurePars());
        }
        result.putAll(this.pars);
        return result;
    }

    public Map<String, String> getPars() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (this.parent != null) {
            result.putAll(this.parent.getPurePars());
        }
        result.putAll(this.pars);
        for (String key : result.keySet()) {
            String newVal = this.replaceAll((String)result.get(key));
            if (newVal != null && newVal.startsWith("\"") && newVal.endsWith("\"")) {
                newVal = newVal.substring(1, newVal.length() - 1);
            }
            result.put(key, newVal);
        }
        return result;
    }

    public TestNode getOnError() {
        return this.onError;
    }

    public void setOnError(TestNode argOnError) {
        this.onError = argOnError;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String argName) {
        this.name = argName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String argId) {
        this.id = argId;
    }

    public String getShortDescr() {
        return this.replaceAll(this.shortDescr);
    }

    public void setShortDescr(String argShortDescr) {
        this.shortDescr = argShortDescr;
    }

    public String getLongDescr() {
        return this.replaceAll(this.longDescr);
    }

    public void setLongDescr(String argLongDescr) {
        this.longDescr = argLongDescr;
    }

    public List<TestNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<TestNode> newChildren) {
        this.children = new LinkedList<TestNode>(newChildren);
    }

    public void addChild(TestNode child) {
        this.children.add(child);
    }

    public TestNode getParent() {
        return this.parent;
    }

    public void setParent(TestNode newParent) {
        this.parent = newParent;
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent + this.name + "\n");
        for (TestNode child : this.children) {
            sb.append(child.toString(indent + "  "));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.name);
        sb.append('@');
        sb.append(this.id);
        sb.append('\n');
        sb.append('\"');
        sb.append(this.shortDescr);
        sb.append('\"');
        sb.append('\n');
        sb.append('\"');
        sb.append(this.longDescr);
        sb.append('\"');
        sb.append('\n');
        sb.append(this.getVars().toString());
        sb.append('\n');
        sb.append(this.getPars().toString());
        sb.append('\n');
        if (this.onError != null) {
            sb.append("!!");
            sb.append(this.onError.toString());
            sb.append("!!");
        }
        for (TestNode child : this.children) {
            sb.append('\n');
            sb.append(child.toString());
        }
        sb.append(']');
        return sb.toString();
    }

    private String replaceAll(String source) {
        String result = source;
        if (result == null) {
            return null;
        }
        Map<String, String> allVars = this.getVars();
        for (String key : allVars.keySet()) {
            while (result.contains(key)) {
                String newVal = allVars.get(key);
                if (newVal != null && newVal.startsWith("\"") && newVal.endsWith("\"")) {
                    newVal = newVal.substring(1, newVal.length() - 1);
                }
                result = result.replace(key, newVal);
            }
        }
        return result;
    }
}

