/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.junit;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import tigase.test.junit.JUnitXMLIO;
import tigase.test.util.ElementUtil;
import tigase.test.util.EqualError;
import tigase.test.util.ScriptFileLoader;
import tigase.xml.Element;

public abstract class XMPPTestCase {
    private String configFile;

    public static boolean isScriptValid(Collection<ScriptFileLoader.StanzaEntry> entries) {
        ScriptFileLoader.Action wantKind = ScriptFileLoader.Action.send;
        block3: for (ScriptFileLoader.StanzaEntry scriptEntry : entries) {
            if (wantKind != null && scriptEntry.getAction() != wantKind) {
                throw new RuntimeException("Invalid script for JUnit test! Expected " + (Object)((Object)wantKind));
            }
            if (wantKind == null && scriptEntry.getAction() == ScriptFileLoader.Action.send) {
                throw new RuntimeException("Invalid script for JUnit test! Expected not send element!");
            }
            if (scriptEntry.getAction() == ScriptFileLoader.Action.send && (scriptEntry.getStanza() == null || scriptEntry.getStanza().length != 1)) {
                throw new RuntimeException("Invalid script for JUnit test! send may have only one element!");
            }
            switch (scriptEntry.getAction()) {
                case send: {
                    wantKind = null;
                    continue block3;
                }
            }
            wantKind = ScriptFileLoader.Action.send;
        }
        return true;
    }

    private static EqualError equalsOneOf(Element[] expect, Collection<Element> data) {
        EqualError rs = null;
        if (expect == null && data == null) {
            return new EqualError(false, "Null expected");
        }
        if (expect == null || data == null) {
            return new EqualError(false, "Result or expect data is null");
        }
        boolean result = false;
        for (Element d : data) {
            for (Element e : expect) {
                EqualError error = ElementUtil.equalElemsDeep(e, d);
                result |= error.equals;
                if (error.equals) continue;
                rs = error;
            }
        }
        return result ? null : rs;
    }

    private static boolean equalsAll(Element[] expect, Collection<Element> data) {
        if (expect == null && data == null) {
            return true;
        }
        if (expect == null || data == null) {
            return false;
        }
        boolean result = true;
        for (Element e : expect) {
            boolean found = false;
            for (Element d : data) {
                EqualError error = ElementUtil.equalElemsDeep(e, d);
                found |= error.equals;
            }
            result &= found;
        }
        return result;
    }

    private static boolean equalsStrict(Element[] expect, Collection<Element> data) {
        if (expect == null && data == null) {
            return true;
        }
        if (expect == null || data == null) {
            return false;
        }
        if (expect.length != data.size()) {
            return false;
        }
        boolean result = true;
        Iterator<Element> dataI = data.iterator();
        int c = 0;
        while (dataI.hasNext()) {
            Element e = expect[c++];
            Element d = dataI.next();
            EqualError error = ElementUtil.equalElemsDeep(e, d);
            result &= error.equals;
        }
        return result;
    }

    public static void test(String configFile, JUnitXMLIO xmlio) {
        try {
            if (configFile == null) {
                throw new RuntimeException("Script file must be specified.");
            }
            LinkedList<ScriptFileLoader.StanzaEntry> script = new LinkedList<ScriptFileLoader.StanzaEntry>();
            ScriptFileLoader scriptFileLoader = new ScriptFileLoader(configFile, script, null);
            scriptFileLoader.loadSourceFile();
            for (ScriptFileLoader.StanzaEntry scriptEntry : script) {
                Boolean ok = null;
                switch (scriptEntry.getAction()) {
                    case send: {
                        xmlio.read().clear();
                        xmlio.write(scriptEntry.getStanza()[0]);
                        break;
                    }
                    case expect: {
                        EqualError ee = XMPPTestCase.equalsOneOf(scriptEntry.getStanza(), xmlio.read());
                        if (ee == null) break;
                        String error_message = (scriptEntry.getDescription() != null ? scriptEntry.getDescription() + " :: " : "") + "expected:\n" + Arrays.toString(scriptEntry.getStanza()) + "\nreceived: " + Arrays.toString(xmlio.read().toArray(new Element[0])) + "\nDescription: " + ee.message;
                        Assert.fail((String)error_message);
                    }
                }
                if (ok == null || ok.booleanValue()) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static void main(String[] args) {
        Pattern pattern = Pattern.compile("(^(.+)\\((.*)\\):.*)|(^(.+):.*)");
        Matcher m = pattern.matcher("send:{");
        boolean b = m.matches();
        if (b) {
            for (int i = 0; i <= m.groupCount(); ++i) {
                System.out.println(i + ": " + m.group(i));
            }
        }
        String keyword = m.group(2) == null ? m.group(5) : m.group(2);
        String param = m.group(3) == null ? null : m.group(3);
        System.out.println(keyword + "(" + param + ")");
    }

    public XMPPTestCase() {
        this.configFile = null;
    }

    public XMPPTestCase(String sourceFile) {
        this.configFile = sourceFile;
    }

    public void test(JUnitXMLIO xmlio) {
        XMPPTestCase.test(this.configFile, xmlio);
    }
}

