/*
 * Decompiled with CFR 0.152.
 */
package tigase.test.impl;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.management.Attribute;
import tigase.test.ResultCode;
import tigase.test.TestAbstract;
import tigase.test.util.Params;
import tigase.test.util.SocketBosh;
import tigase.xml.Element;

public class TestSocketBosh
extends TestAbstract {
    private static final int RECEIVE_BUFFER_SIZE = 2048;
    private String hostname = null;
    private String serverip = null;
    private int port = 5280;
    private int socket_wait = 5000;
    static long connectCounter = 0L;
    static long connectAverTime = 0L;

    public TestSocketBosh() {
        super(new String[]{"jabber:client", "jabber:server", "jabber:component:accept"}, new String[]{"socket-bosh"}, null, null);
    }

    @Override
    public String nextElementName(Element reply) {
        return null;
    }

    @Override
    public String getElementData(String element) {
        return null;
    }

    @Override
    public String[] getRespElementNames(String element) {
        return null;
    }

    @Override
    public Attribute[] getRespElementAttributes(String element) {
        return null;
    }

    @Override
    public String[] getRespOptionalNames(String element) {
        return null;
    }

    @Override
    public boolean run() {
        try {
            Socket client = new Socket();
            client.setReuseAddress(true);
            client.setSoTimeout(this.socket_wait);
            client.setReceiveBufferSize(2048);
            long timeStart = System.currentTimeMillis();
            client.connect(new InetSocketAddress(this.serverip, this.port), this.socket_wait);
            long timeEnd = System.currentTimeMillis();
            long connectTime = timeEnd - timeStart;
            connectAverTime = (connectAverTime + connectTime) / 2L;
            if (++connectCounter % 10L == 0L) {
                this.debug("Socket connect aver time: " + connectAverTime + " ms\n");
            }
            this.params.put("socket", (Object)client);
            this.params.put("socketxmlio", (Object)new SocketBosh(client));
            this.params.put("bosh-mode", (Object)"true");
            return true;
        }
        catch (SocketTimeoutException e) {
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            return false;
        }
        catch (Exception e) {
            this.resultCode = ResultCode.PROCESSING_EXCEPTION;
            this.exception = e;
            e.printStackTrace();
            System.out.println("IP: " + this.serverip + ", PORT:" + this.port);
            return false;
        }
    }

    @Override
    public void init(Params map) {
        super.init(map);
        this.serverip = map.get("-serverip", "127.0.0.1");
        this.hostname = map.get("-host", "localhost");
        this.port = map.get("-port", this.port);
        this.socket_wait = this.params.get("-socket-wait", this.socket_wait);
    }
}

